/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.utils.io.JSONConverter;

public class LightAutoCompleteComboBox
extends LightUIComboBox {
    private static final String FILTER = "filter";
    private static final Pattern QUERY_SPLIT_PATTERN = Pattern.compile("\\s+");
    private String filter;
    private ComboSQLRequest request;

    public LightAutoCompleteComboBox(JSONObject json) {
        super(json);
    }

    public LightAutoCompleteComboBox(String id) {
        super(id);
        this.setType(31);
    }

    public void setComboRequest(ComboSQLRequest request) {
        this.request = request;
        this.setFilter("");
        this.setAlreadyFilled(true);
    }

    public ComboSQLRequest getComboRequest() {
        return this.request;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.applyFilter();
    }

    private void applyFilter() {
        if (this.request != null) {
            Integer selectedId = null;
            if (this.hasSelectedValue()) {
                selectedId = this.getSelectedValue().getId();
            }
            this.clearValues();
            if (this.hasNotSpecifedLine()) {
                this.addValue(LightUIComboBox.getDefaultValue());
            }
            Where where = this.hasSelectedValue() ? new Where((FieldRef)this.request.getPrimaryTable().getKey(), "=", this.getSelectedValue().getId()) : null;
            List<IComboSelectionItem> items = this.request.getComboItems(true, Arrays.asList(QUERY_SPLIT_PATTERN.split(this.filter)), Locale.getDefault(), where);
            System.err.println("LightAutoCompleteComboBox.applyFilter() - items count: " + items.size());
            for (IComboSelectionItem item : items) {
                int id = item.getId();
                String label = item.getLabel();
                System.err.println("LightAutoCompleteComboBox.applyFilter() " + id + " : " + label);
                this.addValue(new LightUIComboBoxElement(id, label));
            }
            this.setSelectedId(selectedId);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(FILTER, this.filter);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.filter = JSONConverter.getParameterFromJSON(json, FILTER, String.class);
    }
}

