/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.replication;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.CSVHandler;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.sql.utils.SQLCreateRoot;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.cc.IClosure;

public class MemoryRep {
    static final short MAX_CANCELED = 10;
    private static final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(MemoryRep.class.getName(), true));
    private final DBSystemRoot master;
    private final DBSystemRoot slave;
    private final TablesMap tables;
    private final String singleRootName;
    private ScheduledFuture<?> future;
    private Future<?> manualFuture;
    private short canceledCount;
    private final AtomicInteger count;

    public MemoryRep(SQLTable table) {
        this(table.getDBSystemRoot(), TablesMap.createByRootFromTable(table));
    }

    public MemoryRep(DBSystemRoot master, final TablesMap tables) {
        this.master = master;
        this.tables = TablesMap.create(tables);
        if (this.tables.size() == 1) {
            this.singleRootName = (String)this.tables.keySet().iterator().next();
            if (this.singleRootName == null) {
                throw new IllegalStateException();
            }
        } else {
            this.singleRootName = null;
        }
        this.slave = new SQLServer(SQLSystem.H2, "mem", null, null, null, (IClosure<? super DBSystemRoot>)new IClosure<DBSystemRoot>(){

            @Override
            public void executeChecked(DBSystemRoot input) {
                input.setRootsToMap(tables.keySet());
                input.initUseCache(false);
            }
        }, (IClosure<? super SQLDataSource>)new IClosure<SQLDataSource>(){

            @Override
            public void executeChecked(SQLDataSource input) {
                input.setInitialSize(1);
                input.setMaxActive(1);
                input.setMinIdle(0);
                input.setMaxIdle(1);
                input.setTimeBetweenEvictionRunsMillis(-1L);
                input.setBlockWhenExhausted(true);
                input.setMaxWait(TimeUnit.MINUTES.toMillis(3L));
            }
        }).getSystemRoot("");
        this.slave.getDataSource().execute(this.slave.getSyntax().disableFKChecks(null));
        this.count = new AtomicInteger(0);
        this.canceledCount = 0;
    }

    public final synchronized Future<?> start(long period, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (this.future != null) {
            if (this.future.isCancelled()) {
                throw new IllegalStateException("Already stopped");
            }
            throw new IllegalStateException("Already started");
        }
        exec.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MemoryRep.this.replicateStruct();
                return null;
            }
        }).get();
        Future<?> res = this.submitReplicate();
        this.future = exec.scheduleAtFixedRate(this.getRunnable(), period, period, unit);
        return res;
    }

    public final synchronized boolean hasStopped() {
        return this.future != null && this.future.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<?> stop() {
        MemoryRep memoryRep = this;
        synchronized (memoryRep) {
            block4: {
                if (this.future != null && !this.future.isCancelled()) break block4;
                return null;
            }
            this.future.cancel(true);
            this.manualFuture.cancel(true);
        }
        return exec.submit(new Runnable(){

            @Override
            public void run() {
                MemoryRep.this.slave.getServer().destroy();
            }
        });
    }

    public final DBSystemRoot getSlave() {
        return this.slave;
    }

    private final void checkTable(String root, String tableName) {
        if (!this.tables.containsKey(root)) {
            throw new IllegalArgumentException("Root not replicated : " + root + " " + tableName);
        }
        if (!((Set)this.tables.get(root)).contains(tableName)) {
            throw new IllegalArgumentException("Table not replicated : " + root + " " + tableName);
        }
    }

    public final SQLTable getMasterTable(String tableName) {
        return this.getMasterTable(this.singleRootName, tableName);
    }

    public final SQLTable getMasterTable(String root, String tableName) {
        this.checkTable(root, tableName);
        return this.master.getRoot(root).getTable(tableName);
    }

    public final SQLTable getSlaveTable(String tableName) {
        return this.getSlaveTable(this.singleRootName, tableName);
    }

    public final SQLTable getSlaveTable(String root, String tableName) {
        this.checkTable(root, tableName);
        return this.slave.getRoot(root).getTable(tableName);
    }

    private final Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    MemoryRep.this.replicateData();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public final synchronized Future<?> submitReplicate() {
        boolean canceled = this.manualFuture != null && this.canceledCount < 10 ? this.manualFuture.cancel(true) : false;
        this.canceledCount = canceled ? (short)(this.canceledCount + 1) : (short)0;
        this.manualFuture = exec.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MemoryRep.this.replicateData();
                return null;
            }
        });
        return this.manualFuture;
    }

    private final synchronized Future<?> getManualFuture() {
        return this.manualFuture;
    }

    public final void waitOnLastManualFuture() throws InterruptedException, ExecutionException {
        Future<?> f = this.getManualFuture();
        boolean done = false;
        while (!done) {
            try {
                f.get();
                done = true;
            }
            catch (CancellationException e) {
                if (this.hasStopped()) {
                    done = true;
                } else {
                    Future<?> old = f;
                    boolean bl = done = old == (f = this.getManualFuture());
                }
                if (!done) continue;
                throw e;
            }
        }
    }

    protected final void replicateStruct() throws SQLException, IOException {
        SQLSyntax slaveSyntax = this.slave.getSyntax();
        SQLDataSource slaveDS = this.slave.getDataSource();
        ArrayList<SQLCreateMoveableTable> createTables = new ArrayList<SQLCreateMoveableTable>();
        HashMap undefIDs = new HashMap();
        for (Map.Entry entry : this.tables.entrySet()) {
            String rootName = (String)entry.getKey();
            Set tableNames = (Set)entry.getValue();
            slaveDS.execute(new SQLCreateRoot(this.slave.getSyntax(), rootName).asString());
            DBRoot root = this.master.getRoot(rootName);
            HashMap<String, Number> rootUndefIDs = new HashMap<String, Number>(tableNames.size());
            undefIDs.put(rootName, rootUndefIDs);
            for (String tableName : tableNames) {
                SQLTable masterTable = root.getTable(tableName);
                SQLCreateMoveableTable ct = masterTable.getCreateTable(slaveSyntax);
                for (ChangeTable.FCSpec fc : new ArrayList<ChangeTable.FCSpec>(ct.getForeignConstraints())) {
                    SQLName refTable = new SQLName(rootName, tableName).resolve(fc.getRefTable());
                    String refTableName = refTable.getItem(-1);
                    String refRootName = refTable.getItem(-2);
                    if (this.tables.containsKey(refRootName) && ((Set)this.tables.get(refRootName)).contains(refTableName)) continue;
                    ct.removeForeignConstraint(fc);
                }
                createTables.add(ct);
                rootUndefIDs.put(tableName, masterTable.getUndefinedIDNumber());
            }
        }
        this.slave.refetch();
        for (Map.Entry entry : undefIDs.entrySet()) {
            SQLSchema schema = this.slave.getRoot((String)entry.getKey()).getSchema();
            SQLTable.setUndefIDs(schema, (Map)entry.getValue());
        }
        for (String string : ChangeTable.cat(createTables)) {
            slaveDS.execute(string);
        }
        this.slave.refetch();
    }

    protected final void replicateData() throws SQLException, IOException, InterruptedException {
        final SQLSyntax slaveSyntax = SQLSyntax.get(this.slave);
        File tempDir = FileUtils.createTempDir(String.valueOf(this.getClass().getCanonicalName()) + "_StoreData");
        try {
            final ArrayList<String> queries = new ArrayList<String>();
            final ArrayList<IResultSetHandler> handlers = new ArrayList<IResultSetHandler>();
            final HashMap files = new HashMap();
            for (Map.Entry e : this.tables.entrySet()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("While creating handlers");
                }
                String rootName = (String)e.getKey();
                final File rootDir = new File(tempDir, rootName);
                FileUtils.mkdir_p(rootDir);
                DBRoot root = this.master.getRoot(rootName);
                final DBRoot slaveRoot = this.slave.getRoot(rootName);
                for (final String tableName : (Set)e.getValue()) {
                    SQLTable masterT = root.getTable(tableName);
                    SQLSelect select = new SQLSelect(true).addSelectStar(masterT);
                    queries.add(select.asString());
                    handlers.add(new IResultSetHandler(new ResultSetHandler(masterT){
                        private final CSVHandler csvH;
                        {
                            this.csvH = new CSVHandler(sQLTable.getOrderedFields());
                        }

                        @Override
                        public Object handle(ResultSet rs) throws SQLException {
                            File tempFile = new File(rootDir, String.valueOf(FileUtils.FILENAME_ESCAPER.escape(tableName)) + ".csv");
                            if (!$assertionsDisabled && tempFile.exists()) {
                                throw new AssertionError();
                            }
                            try {
                                FileUtils.write(this.csvH.handle(rs), tempFile);
                                files.put(tempFile, slaveRoot.getTable(tableName));
                            }
                            catch (IOException e) {
                                throw new SQLException(e);
                            }
                            return null;
                        }
                    }, false));
                }
            }
            try {
                SQLUtils.executeAtomic(this.master.getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException {
                        SQLUtils.executeMultiple(MemoryRep.this.master, queries, handlers);
                        return null;
                    }
                });
            }
            catch (RTInterruptedException e) {
                InterruptedException exn = new InterruptedException("Interrupted while querying the master");
                exn.initCause(e);
                throw exn;
            }
            SQLUtils.executeAtomic(this.slave.getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException, IOException {
                    for (Map.Entry e : files.entrySet()) {
                        SQLTable slaveT = (SQLTable)e.getValue();
                        slaveSyntax.loadData((File)e.getKey(), slaveT, true);
                    }
                    return null;
                }
            });
            this.count.incrementAndGet();
        }
        finally {
            FileUtils.rm_R(tempDir);
        }
    }

    final int getCount() {
        return this.count.get();
    }

    public Future<?> executeModification(IClosure<SQLDataSource> cl) {
        cl.executeChecked(this.master.getDataSource());
        return this.submitReplicate();
    }
}

