/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.TransactionListener;
import org.openconcerto.utils.CompareUtils;

public class TransactionPoint {
    private State state = State.ACTIVE;
    private TransactionPoint previous = null;
    private TransactionPoint transaction = null;
    private final Connection conn;
    private final Savepoint savepoint;
    private final boolean namedSavePoint;
    private final String savePointID;
    private final List<TransactionListener> listeners;

    public TransactionPoint(Connection conn) throws SQLException {
        this(conn, null, false);
    }

    public TransactionPoint(Connection conn, Savepoint savepoint, boolean namedSavePoint) throws SQLException {
        if (conn == null) {
            throw new NullPointerException("Null connection");
        }
        this.conn = conn;
        this.savepoint = savepoint;
        this.namedSavePoint = namedSavePoint;
        this.savePointID = savepoint == null ? null : (namedSavePoint ? savepoint.getSavepointName() : String.valueOf(savepoint.getSavepointId()));
        this.listeners = new ArrayList<TransactionListener>();
    }

    public final Boolean getCommitted() {
        return this.getState().getCommitted();
    }

    public final boolean wasCommitted() throws IllegalStateException {
        State state = this.getState();
        if (state.isActive()) {
            throw new IllegalStateException("Still active");
        }
        return state.getCommitted();
    }

    public final synchronized State getState() {
        return this.state;
    }

    synchronized void setCommitted(boolean committed) {
        this.checkActive();
        State state = this.state = committed ? State.COMMITTED : State.ABORTED;
        assert (!this.isActive());
    }

    public boolean isActive() {
        return this.getState().isActive();
    }

    synchronized void setPrevious(TransactionPoint previous) {
        TransactionPoint newTx;
        assert (previous == null == (this.getSavePoint() == null));
        TransactionPoint transactionPoint = newTx = previous == null ? this : previous.getTransaction();
        if (this.transaction != null && newTx != this.transaction) {
            throw new IllegalArgumentException("Previous is in a different transaction");
        }
        this.previous = previous;
        this.transaction = newTx;
    }

    public final synchronized TransactionPoint getPrevious() {
        return this.previous;
    }

    public final synchronized TransactionPoint getTransaction() {
        return this.transaction;
    }

    final Connection getConn() {
        return this.conn;
    }

    public final Savepoint getSavePoint() {
        return this.savepoint;
    }

    public final boolean isNamedSavePoint() {
        return this.namedSavePoint;
    }

    protected final String getSavePointID() {
        return this.savePointID;
    }

    public final synchronized void addListener(TransactionListener l) {
        this.checkActive();
        this.listeners.add(l);
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction point inactive");
        }
    }

    public final synchronized void removeListener(TransactionListener l) {
        this.checkActive();
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fire() {
        ArrayList<TransactionListener> ls;
        TransactionPoint transactionPoint = this;
        synchronized (transactionPoint) {
            assert (!this.isActive()) : "Fire while still active";
            ls = new ArrayList<TransactionListener>(this.listeners);
            this.listeners.clear();
        }
        for (TransactionListener l : ls) {
            l.transactionEnded(this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conn == null ? 0 : this.conn.hashCode());
        result = 31 * result + (this.namedSavePoint ? 1231 : 1237);
        result = 31 * result + (this.savePointID == null ? 0 : this.savePointID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionPoint other = (TransactionPoint)obj;
        return this.conn == other.conn && this.namedSavePoint == other.namedSavePoint && CompareUtils.equals(this.savePointID, other.savePointID);
    }

    public String toString() {
        String id = this.getSavePointID();
        String sp = id != null ? " / savepoint " + id : "";
        return String.valueOf(this.getClass().getSimpleName()) + " " + (Object)((Object)this.getState()) + " for transaction " + System.identityHashCode(this.getTransaction()) + sp;
    }

    public static enum State {
        ACTIVE(null),
        COMMITTED(true),
        ABORTED(false);

        private final Boolean committed;

        private State(Boolean b) {
            this.committed = b;
        }

        public final Boolean getCommitted() {
            return this.committed;
        }

        public final boolean isActive() {
            return this.committed == null;
        }
    }
}

