/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.jdom2.Element;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.xml.JDOM2Utils;

public final class SQLSchema
extends SQLIdentifier {
    public static final String NOAUTO_CREATE_METADATA = "org.openconcerto.sql.noautoCreateMetadata";
    public static final String FWK_TABLENAME_PREFIX = "FWK_";
    static final String METADATA_TABLENAME = "FWK_SCHEMA_METADATA";
    private static final String VERSION_MDKEY = "VERSION";
    private static final String VERSION_XMLATTR = "schemaVersion";
    private String version;
    private final CopyOnWriteMap<String, SQLTable> tables = new CopyOnWriteMap();
    private final Map<String, String> procedures = new CopyOnWriteMap<String, String>();
    private boolean fetchAllUndefIDs = true;

    public static final void getVersionAttr(SQLSchema schema, Appendable sb) {
        String version = schema.getFullyRefreshedVersion();
        try {
            SQLSchema.appendVersionAttr(version, sb);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't append version of " + schema, e);
        }
    }

    public static final void appendVersionAttr(String version, StringBuilder sb) {
        try {
            SQLSchema.appendVersionAttr(version, (Appendable)sb);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't append version" + version, e);
        }
    }

    public static final void appendVersionAttr(String version, Appendable sb) throws IOException {
        if (version != null) {
            sb.append(' ');
            sb.append(VERSION_XMLATTR);
            sb.append("=\"");
            sb.append(JDOM2Utils.OUTPUTTER.escapeAttributeEntities(version));
            sb.append('\"');
        }
    }

    public static final String getVersion(Element schemaElem) {
        return schemaElem.getAttributeValue(VERSION_XMLATTR);
    }

    public static final Map<String, String> getVersions(SQLBase base, Set<String> schemaNames) {
        return base.getFwkMetadata(schemaNames, VERSION_MDKEY);
    }

    private static String getVersionSQL(SQLSyntax syntax) {
        return syntax.getFormatTimestamp("CURRENT_TIMESTAMP", true);
    }

    static SQLCreateMoveableTable getCreateMetadata(final SQLSyntax syntax) throws SQLException {
        if (Boolean.getBoolean(NOAUTO_CREATE_METADATA)) {
            return null;
        }
        SQLCreateMoveableTable create = new SQLCreateMoveableTable(syntax, METADATA_TABLENAME);
        ((SQLCreateMoveableTable)create.addVarCharColumn("NAME", 100)).addVarCharColumn("VALUE", 250);
        create.setPrimaryKey("NAME");
        create.addOutsideClause(new ChangeTable.DeferredClause(){

            @Override
            public String asString(ChangeTable<?> ct, SQLName tableName) {
                return syntax.getInsertOne(tableName, Arrays.asList("NAME", "VALUE"), SQLBase.quoteStringStd(SQLSchema.VERSION_MDKEY), SQLSchema.getVersionSQL(syntax));
            }

            @Override
            public ChangeTable.ClauseType getType() {
                return ChangeTable.ClauseType.OTHER;
            }
        });
        return create;
    }

    SQLSchema(SQLBase base, String name) {
        super(base, name);
    }

    public final SQLBase getBase() {
        return (SQLBase)this.getParent();
    }

    @Override
    protected void onDrop() {
        SQLTable.removeUndefID(this);
        super.onDrop();
    }

    final synchronized String getFullyRefreshedVersion() {
        return this.version;
    }

    final synchronized void setFullyRefreshedVersion(String vers) {
        this.version = vers;
    }

    public final Map<String, String> getProcedures() {
        return Collections.unmodifiableMap(this.procedures);
    }

    final void putProcedures(Map<String, String> m) {
        this.procedures.putAll(m);
    }

    void clearNonPersistent() {
        this.procedures.clear();
    }

    void load(Element schemaElem, Set<String> tableNames) {
        this.setFullyRefreshedVersion(SQLSchema.getVersion(schemaElem));
        for (Element elementTable : schemaElem.getChildren("table")) {
            this.refreshTable(elementTable, tableNames);
        }
        HashMap<String, String> procMap = new HashMap<String, String>();
        for (Element procElem : schemaElem.getChild("procedures").getChildren("proc")) {
            Element src = procElem.getChild("src");
            procMap.put(procElem.getAttributeValue("name"), src == null ? null : src.getText());
        }
        this.putProcedures(procMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SQLTable fetchTable(String tableName) throws SQLException {
        Object object = this.getTreeMutex();
        synchronized (object) {
            this.getBase().fetchTables(TablesMap.createFromTables(this.getName(), Collections.singleton(tableName)));
            return this.getTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mutateTo(SQLSchema newSchema) {
        assert (Thread.holdsLock(this.getDBSystemRoot().getTreeMutex()));
        SQLSchema sQLSchema = this;
        synchronized (sQLSchema) {
            this.version = newSchema.version;
            this.clearNonPersistent();
            this.putProcedures(newSchema.procedures);
            for (SQLTable t : newSchema.getTables()) {
                this.getTable(t.getName()).mutateTo(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SQLTable addTable(String tableName) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            return this.addTableWithoutSysRootLock(tableName);
        }
    }

    final SQLTable addTableWithoutSysRootLock(String tableName) {
        if (this.contains(tableName)) {
            throw new IllegalStateException(String.valueOf(tableName) + " already in " + this);
        }
        CollectionChangeEventCreator c = this.createChildrenCreator();
        SQLTable res = new SQLTable(this, tableName);
        this.tables.put(tableName, res);
        this.fireChildrenChanged(c);
        return res;
    }

    private final void refreshTable(Element tableElem, Set<String> tableNames) {
        String tableName = tableElem.getAttributeValue("name");
        if (tableNames.contains(tableName)) {
            this.getTable(tableName).loadFields(tableElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Boolean refreshTable(DatabaseMetaData metaData, ResultSet rs, String version) throws SQLException {
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLSchema sQLSchema = this;
            synchronized (sQLSchema) {
                String tableName = rs.getString("TABLE_NAME");
                if (this.contains(tableName)) {
                    return this.getTable(tableName).fetchFields(metaData, rs, version);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void rmTable(String tableName) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            this.rmTableWithoutSysRootLock(tableName);
        }
    }

    private final void rmTableWithoutSysRootLock(String tableName) {
        CollectionChangeEventCreator c = this.createChildrenCreator();
        SQLTable tableToDrop = this.tables.remove(tableName);
        this.fireChildrenChanged(c);
        if (tableToDrop != null) {
            tableToDrop.dropped();
        }
    }

    public final SQLTable getTable(String tablename) {
        return this.tables.get(tablename);
    }

    public Set<String> getTableNames() {
        return Collections.unmodifiableSet(this.tables.keySet());
    }

    public Set<SQLTable> getTables() {
        return new HashSet<SQLTable>(this.tables.values());
    }

    @Override
    public Map<String, SQLTable> getChildrenMap() {
        return this.tables.getImmutable();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder sb = new StringBuilder(256000);
        sb.append("<schema ");
        if (this.getName() != null) {
            sb.append(" name=\"");
            sb.append(JDOM2Utils.OUTPUTTER.escapeAttributeEntities(this.getName()));
            sb.append('\"');
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLSchema sQLSchema = this;
            synchronized (sQLSchema) {
                SQLSchema.getVersionAttr(this, sb);
                sb.append(" >\n");
                sb.append("<procedures>\n");
                for (Map.Entry<String, String> e : this.procedures.entrySet()) {
                    sb.append("<proc name=\"");
                    sb.append(JDOM2Utils.OUTPUTTER.escapeAttributeEntities(e.getKey()));
                    sb.append("\" ");
                    if (e.getValue() == null) {
                        sb.append("/>");
                        continue;
                    }
                    sb.append("><src>");
                    sb.append(JDOM2Utils.OUTPUTTER.escapeElementEntities(e.getValue()));
                    sb.append("</src></proc>\n");
                }
                sb.append("</procedures>\n");
                for (SQLTable table : this.getTables()) {
                    sb.append(table.toXML());
                    sb.append("\n");
                }
                sb.append("</schema>");
            }
        }
        return sb.toString();
    }

    String getFwkMetadata(String name) {
        if (!this.contains(METADATA_TABLENAME)) {
            return null;
        }
        return this.getBase().getFwkMetadata(this.getName(), name);
    }

    boolean setFwkMetadata(String name, String value) throws SQLException {
        return this.setFwkMetadata(name, value, true).get0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Tuple2<Boolean, String> setFwkMetadata(String name, String sqlExpr, boolean createTable) throws SQLException {
        if (Boolean.getBoolean(NOAUTO_CREATE_METADATA)) {
            return Tuple2.create(false, null);
        }
        SQLSystem sys = this.getServer().getSQLSystem();
        SQLSyntax syntax = this.getDBSystemRoot().getSyntax();
        SQLDataSource ds = this.getDBSystemRoot().getDataSource();
        Object object = this.getTreeMutex();
        synchronized (object) {
            Tuple2<Boolean, Object> res;
            boolean shouldRefresh;
            if (createTable && !this.contains(METADATA_TABLENAME)) {
                SQLCreateMoveableTable create = SQLSchema.getCreateMetadata(syntax);
                ds.execute(create.asString(this.getDBRoot().getName()));
                shouldRefresh = true;
            } else {
                shouldRefresh = false;
            }
            if (createTable || this.contains(METADATA_TABLENAME)) {
                List<ScalarHandler> handlers;
                ArrayList<String> queries = new ArrayList<String>();
                SQLName tableName = new SQLName(this.getBase().getName(), this.getName(), METADATA_TABLENAME);
                String where = " WHERE " + SQLBase.quoteIdentifier("NAME") + " = " + this.getBase().quoteString(name);
                queries.add("DELETE FROM " + tableName.quote() + where);
                String returning = sys == SQLSystem.POSTGRESQL ? " RETURNING " + SQLBase.quoteIdentifier("VALUE") : "";
                String ins = String.valueOf(syntax.getInsertOne(tableName, Arrays.asList("NAME", "VALUE"), this.getBase().quoteString(name), sqlExpr)) + returning;
                queries.add(ins);
                if (returning.length() == 0) {
                    queries.add("SELECT " + SQLBase.quoteIdentifier("VALUE") + " FROM " + tableName.quote() + where);
                    handlers = Arrays.asList(null, null, SQLDataSource.SCALAR_HANDLER);
                } else {
                    handlers = Arrays.asList(null, SQLDataSource.SCALAR_HANDLER);
                }
                List<?> ress = SQLUtils.executeMultiple(this.getDBSystemRoot(), queries, handlers);
                res = Tuple2.create(true, (String)ress.get(ress.size() - 1));
            } else {
                res = Tuple2.create(false, null);
            }
            if (shouldRefresh) {
                this.fetchTable(METADATA_TABLENAME);
            }
            return res;
        }
    }

    public final String getVersion() {
        return this.getFwkMetadata(VERSION_MDKEY);
    }

    public final String updateVersion() throws SQLException {
        return this.updateVersion(true);
    }

    final String updateVersion(boolean createTable) throws SQLException {
        return this.setFwkMetadata(VERSION_MDKEY, SQLSchema.getVersionSQL(SQLSyntax.get(this)), createTable).get1();
    }

    public final synchronized void setFetchAllUndefinedIDs(boolean b) {
        this.fetchAllUndefIDs = b;
    }

    public final synchronized boolean isFetchAllUndefinedIDs() {
        return this.fetchAllUndefIDs;
    }
}

