/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.openconcerto.sql.model.SQLRequestLog;

public class SQLRequestLogModel
extends DefaultTableModel {
    SQLRequestLogModel() {
        SQLRequestLog.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SQLRequestLogModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 9) {
            return Integer.class;
        }
        if (columnIndex < 5) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Time";
            }
            case 1: {
                return "SQL";
            }
            case 2: {
                return "Processing";
            }
            case 3: {
                return "Cleanup";
            }
            case 4: {
                return "Total duration";
            }
            case 5: {
                return "Query";
            }
            case 6: {
                return "Info";
            }
            case 7: {
                return "Connection";
            }
            case 8: {
                return "Thread";
            }
            case 9: {
                return "Returned rows";
            }
        }
        return "??";
    }

    @Override
    public int getRowCount() {
        return SQLRequestLog.getSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SQLRequestLog l = this.getRowAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return l.getStartAsMs();
            }
            case 1: {
                return l.getDurationSQLNano();
            }
            case 2: {
                return l.getDurationHandleNano();
            }
            case 3: {
                return l.getDurationCleanupNano();
            }
            case 4: {
                return l.getDurationTotalNano();
            }
            case 5: {
                return l.getQuery();
            }
            case 6: {
                return l.getComment();
            }
            case 7: {
                if (l.getConnectionId() == 0) {
                    return "";
                }
                return String.valueOf(l.getConnectionId());
            }
            case 8: {
                if (l.isInSwing()) {
                    return "Swing";
                }
                return l.getThreadId();
            }
            case 9: {
                return l.getResultCount();
            }
        }
        return "";
    }

    public SQLRequestLog getRowAt(int rowIndex) {
        return SQLRequestLog.get(SQLRequestLog.getSize() - rowIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

