/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFilterListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.GraFFF;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.CollectionUtils;

public final class SQLFilter {
    private final SQLElementDirectory dir;
    private final GraFFF filterGraph;
    private final List<Set<SQLRow>> filteredIDs;
    private List<SQLFilterListener> listeners;

    public static SQLFilter create(DBSystemRoot root, SQLElementDirectory dir) {
        Collection<SQLElement> elements = dir.getElements();
        HashSet<SQLField> toKeep = new HashSet<SQLField>(elements.size());
        for (SQLElement elem : elements) {
            SQLField parentFF = elem.getParentForeignField();
            if (parentFF == null) continue;
            toKeep.add(parentFF);
        }
        return new SQLFilter(dir, root.getGraph().cloneForFilterKeep(toKeep));
    }

    public SQLFilter(SQLElementDirectory dir, GraFFF filterGraph) {
        this.dir = dir;
        this.filterGraph = filterGraph;
        this.filteredIDs = new ArrayList<Set<SQLRow>>();
        this.listeners = Collections.emptyList();
    }

    public final SQLElementDirectory getDirectory() {
        return this.dir;
    }

    public Path getPath(SQLTable tableToDisplay) {
        Set<Path> paths;
        Path res = null;
        if (this.getDepth() > 0 && !(paths = this.getPaths(tableToDisplay, this.getLeafTable())).isEmpty()) {
            res = paths.iterator().next().reverse();
        }
        return res;
    }

    private Set<Path> getPaths(SQLTable tableToDisplay, SQLTable filterTable) {
        Path shortestPath = this.filterGraph.getShortestPath(filterTable, tableToDisplay);
        Set<Object> paths = shortestPath == null ? Collections.emptySet() : Collections.singleton(shortestPath);
        return paths;
    }

    public void setFilteredID(SQLTable table, Integer ID) {
        this.setFiltered(Collections.singletonList(Collections.singleton(new SQLRow(table, ID))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiltered(List<Set<SQLRow>> r) {
        SQLTable broadestTable;
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            if (r.equals(this.filteredIDs)) {
                return;
            }
            int prevDepth = this.getDepth();
            SQLTable prevTable = this.getLeafTable();
            this.filteredIDs.clear();
            this.filteredIDs.addAll(r);
            broadestTable = prevDepth < this.getDepth() ? prevTable : this.getLeafTable();
        }
        this.fireConnected(broadestTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDepth() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return this.filteredIDs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Set<SQLRow>> getRows() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return new ArrayList<Set<SQLRow>>(this.filteredIDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<SQLRow> getLeaf() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return CollectionUtils.getFirst(this.filteredIDs);
        }
    }

    private final SQLTable getLeafTable() {
        Set<SQLRow> leaf = this.getLeaf();
        return leaf == null ? null : leaf.iterator().next().getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireConnected(SQLTable table) {
        List<SQLFilterListener> dispatchingListeners;
        Set<SQLTable> connectedSet;
        if (table == null) {
            connectedSet = this.filterGraph.getAllTables();
        } else {
            SQLField parentForeignField = this.getDirectory().getElement(table).getParentForeignField();
            connectedSet = this.filterGraph.getDescTables(table, parentForeignField);
        }
        SQLFilter sQLFilter = this;
        synchronized (sQLFilter) {
            dispatchingListeners = this.listeners;
        }
        for (SQLFilterListener l : dispatchingListeners) {
            l.filterChanged(connectedSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return "SQLFilter on: " + this.filteredIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SQLFilterListener l) {
        SQLFilter sQLFilter = this;
        synchronized (sQLFilter) {
            ArrayList<SQLFilterListener> newListeners = new ArrayList<SQLFilterListener>(this.listeners.size() + 1);
            newListeners.addAll(this.listeners);
            newListeners.add(l);
            this.listeners = Collections.unmodifiableList(newListeners);
        }
    }

    public void addWeakListener(SQLFilterListener l) {
        this.addListener(new WeakListener(l));
    }

    public void rmListener(SQLFilterListener lToRm) {
        assert (!(lToRm instanceof WeakListener)) : "Only expose regular listeners";
        this.rmListener_(lToRm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmListener_(SQLFilterListener lToRm) {
        SQLFilter sQLFilter = this;
        synchronized (sQLFilter) {
            int stop = this.listeners.size();
            int indexToRm = -1;
            int i = 0;
            while (i < stop && indexToRm < 0) {
                SQLFilterListener l = this.listeners.get(i);
                if (l.equals(lToRm) || l instanceof WeakListener && lToRm.equals(((WeakListener)l).get())) {
                    indexToRm = i;
                }
                ++i;
            }
            if (indexToRm >= 0) {
                ArrayList<SQLFilterListener> newListeners = new ArrayList<SQLFilterListener>(stop - 1);
                newListeners.addAll(this.listeners.subList(0, indexToRm));
                newListeners.addAll(this.listeners.subList(indexToRm + 1, stop));
                this.listeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    private final class WeakListener
    extends WeakReference<SQLFilterListener>
    implements SQLFilterListener {
        private WeakListener(SQLFilterListener referent) {
            super(referent);
        }

        @Override
        public void filterChanged(Collection<SQLTable> tables) {
            SQLFilterListener l = (SQLFilterListener)this.get();
            if (l != null) {
                l.filterChanged(tables);
            } else {
                SQLFilter.this.rmListener_(this);
            }
        }
    }
}

