/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;

public interface LoadingListener {
    public void loading(LoadingEvent var1);

    public static class GraphLoadingEvent
    extends LoadingEvent {
        public GraphLoadingEvent(DBSystemRoot source) {
            super(source);
        }

        protected GraphLoadingEvent(DBSystemRoot source, boolean starting) {
            super(source, starting);
        }

        public final DBSystemRoot getSystemRoot() {
            return (DBSystemRoot)this.getSource();
        }

        public final GraphLoadingEvent fireEvent() {
            this.getSystemRoot().fireLoading(this);
            return this;
        }

        @Override
        public GraphLoadingEvent createFinishingEvent() {
            return new GraphLoadingEvent(this.getSystemRoot(), false);
        }

        public final void fireFinishingEvent() {
            this.getSystemRoot().fireLoading(this.createFinishingEvent());
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + (this.isStarting() ? " starting" : " finishing") + " loading of " + this.getSource();
        }
    }

    public static class LoadingChangeSupport {
        private final DBSystemRoot source;
        private final List<LoadingListener> loadingListeners;

        public LoadingChangeSupport(DBSystemRoot source) {
            this.source = source;
            this.loadingListeners = new ArrayList<LoadingListener>(4);
        }

        public final synchronized void addLoadingListener(LoadingListener l) {
            this.loadingListeners.add(l);
        }

        public final synchronized void removeLoadingListener(LoadingListener l) {
            this.loadingListeners.remove(l);
        }

        public synchronized void fireLoading(LoadingEvent evt) {
            assert (evt.getSource().getDBSystemRoot() == this.source);
            for (LoadingListener l : this.loadingListeners) {
                l.loading(evt);
            }
        }
    }

    public static abstract class LoadingEvent {
        private final DBStructureItem<?> source;
        private final boolean starting;

        public LoadingEvent(DBStructureItem<?> source) {
            this(source, true);
        }

        protected LoadingEvent(DBStructureItem<?> source, boolean starting) {
            this.source = source;
            this.starting = starting;
        }

        public final DBStructureItem<?> getSource() {
            return this.source;
        }

        public final boolean isStarting() {
            return this.starting;
        }

        public abstract LoadingEvent createFinishingEvent();
    }

    public static class StructureLoadingEvent
    extends LoadingEvent {
        private final Set<String> children;

        public StructureLoadingEvent(DBStructureItemJDBC source, Set<String> children) {
            this(source, true, children);
        }

        protected StructureLoadingEvent(DBStructureItemJDBC source, boolean starting, Set<String> children) {
            super(source, starting);
            this.children = children;
        }

        public final Set<String> getChildren() {
            return this.children;
        }

        @Override
        public final StructureLoadingEvent createFinishingEvent() {
            if (!this.isStarting()) {
                throw new IllegalStateException("Already a finishing event");
            }
            return new StructureLoadingEvent((DBStructureItemJDBC)this.getSource(), false, this.children);
        }

        public String toString() {
            String children = this.getChildren() == null ? "all children" : this.getChildren().toString();
            return String.valueOf(this.getClass().getSimpleName()) + (this.isStarting() ? " starting" : " finishing") + " loading " + children + " of " + this.getSource();
        }
    }
}

