/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.request.SQLCache;

class HandlersStack {
    private final SQLDataSource ds;
    private Connection conn;
    private final LinkedList<ConnectionHandler<?, ?>> stack;
    private boolean changeAllowed;
    private final LinkedList<TransactionPoint> txPoints;
    private final LinkedList<SQLCache<List<?>, Object>> caches;
    private final Thread thr;
    private boolean dirtyCache;

    HandlersStack(SQLDataSource ds, Connection conn, ConnectionHandler<?, ?> handler) {
        if (conn == null) {
            throw new NullPointerException("null connection");
        }
        this.ds = ds;
        this.changeAllowed = false;
        this.conn = conn;
        this.stack = new LinkedList();
        this.push(handler);
        this.txPoints = new LinkedList();
        this.caches = new LinkedList();
        this.thr = Thread.currentThread();
        this.dirtyCache = false;
    }

    final Thread getThread() {
        return this.thr;
    }

    private synchronized boolean setDirtyCache(boolean dirtyCache) {
        boolean prev = this.dirtyCache;
        this.dirtyCache = dirtyCache;
        return prev;
    }

    private boolean checkDirtyCache() {
        boolean dirtyCache = this.setDirtyCache(false);
        if (dirtyCache) {
            boolean done = this.updateCache();
            assert (done) : "The caches were not updated even though this is the correct thread";
        }
        return dirtyCache;
    }

    public final boolean hasValidConnection() {
        return this.conn != null;
    }

    public final boolean hasTransaction() {
        return !this.txPoints.isEmpty();
    }

    public final Connection getConnection() throws IllegalStateException {
        if (this.conn == null) {
            throw new IllegalStateException("connection was invalidated");
        }
        return this.conn;
    }

    final Connection invalidConnection() {
        Connection res = this.conn;
        this.conn = null;
        return res;
    }

    final HandlersStack push(ConnectionHandler<?, ?> handler) {
        this.stack.addFirst(handler);
        return this;
    }

    final boolean pop() {
        this.stack.removeFirst();
        return this.stack.isEmpty();
    }

    private final boolean assertPointsAndCacheCoherence(int size) {
        assert (Thread.currentThread() == this.getThread()) : "Wrong thread : " + Thread.currentThread() + " should be " + this.getThread();
        assert (this.txPoints.size() == this.caches.size());
        if (size >= 0) assert (this.txPoints.size() == size);
        return true;
    }

    final void addTxPoint(TransactionPoint txPoint) {
        if (txPoint.getConn() != this.conn) {
            throw new IllegalArgumentException("Different connections");
        }
        this.checkDirtyCache();
        assert (this.stack.size() > 0 || txPoint.getSavePoint() == null);
        txPoint.setPrevious(this.getLastTxPoint());
        this.txPoints.add(txPoint);
        this.addCache();
        assert (this.assertPointsAndCacheCoherence(-1));
    }

    private void addCache() {
        TransactionPoint txPoint = this.txPoints.get(this.caches.size());
        SQLCache<List<?>, Object> previous = this.getCache();
        SQLCache<List<?>, Object> current = this.ds.createCache(txPoint);
        this.caches.add(current);
        if (current != null) {
            current.setParent(null);
            current.putAll(previous != null ? previous : this.ds.getCommittedCache(), false);
        }
    }

    private final void removeLastCache() {
        SQLCache<List<?>, Object> last = this.caches.removeLast();
        if (last != null) {
            last.clear();
        }
        if (this.caches.isEmpty()) {
            this.setDirtyCache(false);
        }
    }

    boolean updateCache() {
        boolean done;
        boolean bl = done = Thread.currentThread() == this.getThread();
        if (done) {
            int size = this.txPoints.size();
            if (size > 0) {
                this.clearCache();
                int i = 0;
                while (i < size) {
                    this.addCache();
                    ++i;
                }
            }
            assert (this.assertPointsAndCacheCoherence(size));
        } else {
            this.setDirtyCache(true);
        }
        return done;
    }

    private final void clearCache() {
        while (!this.caches.isEmpty()) {
            this.removeLastCache();
        }
    }

    final TransactionPoint getLastTxPoint() {
        return this.txPoints.peekLast();
    }

    final SQLCache<List<?>, Object> getCache() {
        this.checkDirtyCache();
        return this.caches.peekLast();
    }

    private final TransactionPoint removeFirstTxPoint() {
        return this.txPoints.pollFirst();
    }

    private final TransactionPoint removeLastTxPoint() {
        return this.txPoints.pollLast();
    }

    void commit(TransactionPoint newTxPoint) throws SQLException {
        if (!this.hasTransaction()) {
            throw new IllegalStateException("No transaction to commit");
        }
        if (this.txPoints.size() > 1) {
            this.releaseSavepoint(this.txPoints.get(1).getSavePoint());
        }
        assert (this.txPoints.size() == 1);
        TransactionPoint txPoint = this.removeFirstTxPoint();
        txPoint.setCommitted(true);
        this.removeLastCache();
        assert (this.assertPointsAndCacheCoherence(0));
        assert (!this.checkDirtyCache());
        if (newTxPoint != null) {
            this.addTxPoint(newTxPoint);
        }
        txPoint.fire();
    }

    void rollback(TransactionPoint newTxPoint) throws SQLException {
        if (newTxPoint == null) {
            throw new NullPointerException("Missing transaction point");
        }
        LinkedList<TransactionPoint> toFire = new LinkedList<TransactionPoint>(this.txPoints);
        this.txPoints.clear();
        this.clearCache();
        assert (this.assertPointsAndCacheCoherence(0));
        assert (!this.checkDirtyCache());
        this.addTxPoint(newTxPoint);
        Iterator<TransactionPoint> iter = toFire.descendingIterator();
        while (iter.hasNext()) {
            TransactionPoint txPoint = iter.next();
            txPoint.setCommitted(false);
            txPoint.fire();
        }
    }

    void rollback(Savepoint savepoint) throws SQLException {
        ArrayList<TransactionPoint> pointsToFire = new ArrayList<TransactionPoint>();
        TransactionPoint txPoint = this.removeLastTxPoint();
        while (txPoint.getSavePoint() != savepoint) {
            pointsToFire.add(txPoint);
            this.removeLastCache();
            txPoint = this.removeLastTxPoint();
        }
        pointsToFire.add(txPoint);
        this.removeLastCache();
        assert (this.assertPointsAndCacheCoherence(-1));
        this.checkDirtyCache();
        for (TransactionPoint toFire : pointsToFire) {
            toFire.setCommitted(false);
            toFire.fire();
        }
    }

    /*
     * Unable to fully structure code
     */
    void releaseSavepoint(Savepoint savepoint) {
        if (savepoint == null) {
            throw new NullPointerException("Null savepoint");
        }
        toRelease = new LinkedList<TransactionPoint>();
        iter = this.txPoints.descendingIterator();
        found = null;
        while (iter.hasNext() && found == null) {
            current = iter.next();
            if (current.getSavePoint() == savepoint) {
                found = current;
            }
            toRelease.add(current);
        }
        if (found == null) {
            throw new NoSuchElementException("Savepoint not found :" + savepoint);
        }
        index = this.txPoints.size() - toRelease.size();
        if (HandlersStack.$assertionsDisabled || index > 0) ** GOTO lbl27
        throw new AssertionError((Object)"First point is a transaction not a savepoint");
lbl-1000:
        // 1 sources

        {
            removed = this.txPoints.remove(index);
            removed.setCommitted(true);
            if (index < this.txPoints.size()) {
                this.txPoints.get(index).setPrevious(this.txPoints.get(index - 1));
            }
            if ((cache = this.caches.remove(index)) == null) continue;
            this.caches.get(index - 1).clear();
            this.caches.get(index - 1).putAll(cache, true);
            this.caches.get(index - 1).addReleasedSavePoints(cache);
            cache.clear();
lbl27:
            // 3 sources

            ** while (this.txPoints.size() > index)
        }
lbl28:
        // 1 sources

        if (!HandlersStack.$assertionsDisabled && !this.assertPointsAndCacheCoherence(index)) {
            throw new AssertionError();
        }
        for (TransactionPoint toFire : toRelease) {
            toFire.fire();
        }
    }

    public final boolean isChangeAllowed() {
        return this.changeAllowed;
    }

    final void setChangeAllowed(boolean b) {
        this.changeAllowed = b;
    }
}

