/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.SQLResultSet;

public class ColumnListHandlerGeneric<T>
implements ResultSetHandler {
    private static final Map<Class<?>, ColumnListHandlerGeneric<?>> cache = new LinkedHashMap<Class<?>, ColumnListHandlerGeneric<?>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, ColumnListHandlerGeneric<?>> eldest) {
            return this.size() > 20;
        }
    };
    private final int columnIndex;
    private final String columnName;
    private final Class<T> clz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ColumnListHandlerGeneric<T> create(Class<T> clz) {
        Map<Class<?>, ColumnListHandlerGeneric<?>> map = cache;
        synchronized (map) {
            ColumnListHandlerGeneric<Object> res = cache.get(clz);
            if (res == null) {
                res = ColumnListHandlerGeneric.create(1, clz);
                assert (res != null);
                cache.put(clz, res);
            }
            return res;
        }
    }

    public static <T> ColumnListHandlerGeneric<T> create(int columnIndex, Class<T> clz) {
        return new ColumnListHandlerGeneric<T>(columnIndex, clz);
    }

    public ColumnListHandlerGeneric(int columnIndex, Class<T> clz) {
        this(columnIndex, null, clz);
    }

    public ColumnListHandlerGeneric(String columnName, Class<T> clz) {
        this(-1, columnName, clz);
    }

    protected ColumnListHandlerGeneric(int columnIndex, String columnName, Class<T> clz) {
        boolean noIndex;
        boolean noName = columnName == null;
        boolean bl = noIndex = columnIndex <= 0;
        if (noName && noIndex) {
            throw new IllegalArgumentException("Missing column information");
        }
        assert (noName || noIndex) : "A constructor passed more than one argument";
        this.columnIndex = columnIndex;
        this.columnName = columnName;
        this.clz = clz;
    }

    @Override
    public final List<T> handle(ResultSet rs) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            if (this.columnName == null) {
                result.add(SQLResultSet.getValue(rs, this.clz, this.columnIndex));
                continue;
            }
            result.add(SQLResultSet.getValue(rs, this.clz, this.columnName));
        }
        return result;
    }
}

