/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.TableRef;

public class AliasedField
implements FieldRef {
    private final TableRef t;
    private final SQLField f;

    public AliasedField(SQLField f) {
        this(f, null);
    }

    public AliasedField(TableRef t, String fieldName) {
        this.t = t;
        this.f = t.getTable().getField(fieldName);
    }

    public AliasedField(SQLField f, String alias) {
        if (f == null) {
            throw new NullPointerException("f is null");
        }
        this.f = f;
        this.t = AliasedTable.getTableRef(f.getTable(), alias);
    }

    @Override
    public SQLField getField() {
        return this.f;
    }

    @Override
    public String getFieldRef() {
        return String.valueOf(SQLBase.quoteIdentifier(this.getAlias())) + "." + SQLBase.quoteIdentifier(this.getField().getName());
    }

    @Override
    public String getAlias() {
        return this.t.getAlias();
    }

    @Override
    public TableRef getTableRef() {
        return this.t;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AliasedField) {
            AliasedField o = (AliasedField)obj;
            return this.getAlias().equals(o.getAlias()) && this.getField().equals(o.getField());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getAlias().hashCode() + this.getField().hashCode();
    }

    public String toString() {
        return this.getFieldRef();
    }
}

