/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLUtils;

public class RemoveDuplicates
extends Changer<SQLTable> {
    private final List<String> fields = new ArrayList<String>();

    public RemoveDuplicates(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected Class<? extends DBStructureItem<?>> getMaxLevel() {
        return SQLTable.class;
    }

    public final List<String> getFields() {
        return this.fields;
    }

    public final void setFields(List<String> fields) {
        this.fields.clear();
        this.fields.addAll(fields);
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        this.setFields(SQLRow.toList(System.getProperty("org.openconcerto.sql.pks", "")));
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().print(String.valueOf(t.getName()) + "... ");
        if (this.getFields().size() == 0) {
            throw new IllegalStateException("no fields defined");
        }
        this.getStream().print(this.getFields() + " ");
        if (t.getPKsNames().equals(this.getFields()) || t.getConstraint(SQLSyntax.ConstraintType.UNIQUE, this.getFields()) != null) {
            this.getStream().println("already");
        } else {
            this.getStream().println(SQLUtils.executeAtomic(this.getDS(), new ConnectionHandlerNoSetup<String, SQLException>(){

                @Override
                public String handle(SQLDataSource ds) throws SQLException {
                    String addedPK;
                    if (t.getKey() == null) {
                        addedPK = "ID";
                        ds.execute(new AlterTable(t).addColumn(addedPK, RemoveDuplicates.this.getSyntax().getPrimaryIDDefinition()).asString());
                        t.fetchFields();
                    } else {
                        addedPK = null;
                    }
                    if (!$assertionsDisabled && t.getKey() == null) {
                        throw new AssertionError();
                    }
                    SQLSelect sel = new SQLSelect(t.getBase());
                    sel.addSelect(t.getKey(), "min");
                    for (String f : RemoveDuplicates.this.getFields()) {
                        sel.addGroupBy(t.getField(f));
                    }
                    ds.execute("CREATE TEMPORARY TABLE " + SQLBase.quoteIdentifier("ID_TO_KEEP") + " as " + sel.asString());
                    ds.execute(t.getBase().quote("DELETE FROM %f where %n not in (SELECT * from " + SQLBase.quoteIdentifier("ID_TO_KEEP") + ")", t, t.getKey()));
                    if (addedPK != null) {
                        ds.execute(new AlterTable(t).dropColumn(addedPK).asString());
                        ds.execute(((AlterTable)new AlterTable(t).addClause("ADD PRIMARY KEY(" + SQLSyntax.quoteIdentifiers(RemoveDuplicates.this.getFields()) + ")", ChangeTable.ClauseType.ADD_CONSTRAINT)).asString());
                        return "added primary key";
                    }
                    ds.execute(((AlterTable)new AlterTable(t).addUniqueConstraint("uniq", RemoveDuplicates.this.getFields())).asString());
                    return "added unique constraint";
                }
            }));
        }
    }
}

