/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openconcerto.map.model.MapPoint;
import org.openconcerto.map.model.MapPointSelection;
import org.openconcerto.map.model.Region;
import org.openconcerto.map.model.Ville;
import org.openconcerto.map.ui.ModeListener;
import org.openconcerto.map.ui.RegionPointsCache;
import org.openconcerto.map.ui.StatusPanel;
import org.openconcerto.map.ui.VilleRendererListener;
import org.openconcerto.map.ui.ZoomListener;
import org.openconcerto.utils.ArrayListOfInt;
import org.openconcerto.utils.checks.MutableValueObject;

public class VilleRendererPanel
extends JPanel
implements MutableValueObject<String> {
    private static final long serialVersionUID = -6477685676332334863L;
    private static final Color COLOR_POINT_VILLE = new Color(220, 80, 80);
    private static final BasicStroke STROKE_CONTOUR = new BasicStroke(1.0f, 1, 1);
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    double dx;
    double dy;
    private int startX;
    private int startY;
    double offsetX = Ville.getMinXLambert();
    double offsetY = Ville.getMinYLambert();
    private int currentMouseX;
    private int currentMouseY;
    private List<VilleRendererListener> listenersVille = new Vector<VilleRendererListener>();
    private Set<Ville> alwayVisible = new HashSet<Ville>();
    private Map<Ville, Integer> matching = new HashMap<Ville, Integer>();
    private Set<Ville> hightlightVisible = new HashSet<Ville>();
    private boolean gridActicvated;
    private List<RegionPointsCache> cacheRegions = new ArrayList<RegionPointsCache>();
    private List<Ville> cacheVilles = new ArrayList<Ville>();
    public static final int MODE_MOVE = 0;
    public static final int MODE_DRAW = 1;
    private ArrayListOfInt drawX = new ArrayListOfInt();
    private ArrayListOfInt drawY = new ArrayListOfInt();
    private final MapPointSelection selectedPoints = new MapPointSelection();
    private int mode = 0;
    protected boolean quickdraw;
    private MapPoint highLightedPoint;
    private ArrayList<ModeListener> modeListeners = new ArrayList();
    private Map<Ville, Color> colors = new HashMap<Ville, Color>();
    private final PropertyChangeSupport supp;
    private final List<Double> zoomValues = new ArrayList<Double>();
    int currentZoomIndex = 1;
    final Color BG_COLOR = new Color(154, 178, 204);
    private Image imgMarker;
    private ZoomListener zoomListener;

    public VilleRendererPanel() {
        double first = 3328.0;
        int i = 0;
        while (i < 6) {
            this.zoomValues.add(first);
            first /= 2.0;
            ++i;
        }
        this.imgMarker = new ImageIcon(StatusPanel.class.getResource("marker.png")).getImage();
        this.supp = new PropertyChangeSupport(this);
        this.setBackground(Color.white);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (VilleRendererPanel.this.mode == 0) {
                    if (e.getWheelRotation() < 0) {
                        VilleRendererPanel.this.zoomIn();
                    } else {
                        VilleRendererPanel.this.zoomOut();
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (VilleRendererPanel.this.startX > 0) {
                    if (VilleRendererPanel.this.mode == 0) {
                        VilleRendererPanel.this.dx += (double)(e.getX() - VilleRendererPanel.this.startX);
                        VilleRendererPanel.this.dy += (double)(e.getY() - VilleRendererPanel.this.startY);
                    }
                    VilleRendererPanel.this.startX = e.getX();
                    VilleRendererPanel.this.startY = e.getY();
                    if (VilleRendererPanel.this.mode == 1) {
                        VilleRendererPanel.this.drawX.add(VilleRendererPanel.this.startX);
                        VilleRendererPanel.this.drawY.add(VilleRendererPanel.this.startY);
                    }
                    VilleRendererPanel.this.quickdraw = true;
                    VilleRendererPanel.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                VilleRendererPanel.this.currentMouseX = e.getX();
                VilleRendererPanel.this.currentMouseY = e.getY();
                if (VilleRendererPanel.this.mode == 0) {
                    VilleRendererPanel.this.fireVilleRendererListener();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VilleRendererPanel.this.requestFocus();
                if (VilleRendererPanel.this.mode == 1) {
                    VilleRendererPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    VilleRendererPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                }
                VilleRendererPanel.this.startX = e.getX();
                VilleRendererPanel.this.startY = e.getY();
                if (VilleRendererPanel.this.mode == 1) {
                    VilleRendererPanel.this.drawX.clear();
                    VilleRendererPanel.this.drawY.clear();
                    VilleRendererPanel.this.drawX.add(VilleRendererPanel.this.startX);
                    VilleRendererPanel.this.drawY.add(VilleRendererPanel.this.startY);
                    VilleRendererPanel.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VilleRendererPanel.this.setCursor(Cursor.getDefaultCursor());
                VilleRendererPanel.this.startX = -1;
                VilleRendererPanel.this.startY = -1;
                VilleRendererPanel.this.quickdraw = false;
                if (VilleRendererPanel.this.mode == 1) {
                    MapPointSelection newSel = new MapPointSelection();
                    int i = 0;
                    while (i < VilleRendererPanel.this.drawX.size()) {
                        long xx = VilleRendererPanel.this.XToLongitude(VilleRendererPanel.this.drawX.get(i));
                        long yy = VilleRendererPanel.this.YTolatitude(VilleRendererPanel.this.drawY.get(i));
                        MapPoint p = new MapPoint(xx, yy);
                        newSel.add(p);
                        ++i;
                    }
                    VilleRendererPanel.this.setSelectedPoints(newSel);
                    VilleRendererPanel.this.drawX.clear();
                    VilleRendererPanel.this.drawY.clear();
                    VilleRendererPanel.this.setMode(0);
                }
                VilleRendererPanel.this.repaint();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.rebuildCacheRegions();
        this.rebuildVisibleVilleCache();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.fireModeChanged();
    }

    public int getMode() {
        return this.mode;
    }

    public void addModeListener(ModeListener l) {
        this.modeListeners.add(l);
    }

    private void fireModeChanged() {
        for (ModeListener l : this.modeListeners) {
            l.modeChanged();
        }
    }

    public void setHighlight(Ville v) {
        this.hightlightVisible.add(v);
        this.repaint();
    }

    public void clearMatching() {
        this.matching.clear();
    }

    public void incrementMacthing(Ville v) {
        Integer i = this.matching.get(v);
        if (i == null) {
            this.matching.put(v, 1);
        } else {
            this.matching.put(v, i + 1);
        }
    }

    public void setAlwayVisible(Ville v) {
        this.alwayVisible.add(v);
        this.rebuildVisibleVilleCache();
        this.repaint();
    }

    public void clearAlwayVisible() {
        for (Ville element : this.alwayVisible) {
            this.colors.remove(element);
        }
        this.alwayVisible.clear();
        this.rebuildVisibleVilleCache();
        this.repaint();
    }

    protected void setZoomIndex(int index) {
        if (index != this.currentZoomIndex) {
            long xCenter = this.XToLongitude(this.getWidth() / 2);
            long yCenter = this.YTolatitude(this.getHeight() / 2);
            this.currentZoomIndex = index;
            this.rebuildCacheRegions();
            this.rebuildVisibleVilleCache();
            this.centerScreenXYLambert(xCenter, yCenter);
            this.zoomListener.zoomChanged(index);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        System.out.println("VilleRendererPanel.repaint()");
    }

    private void rebuildCacheRegions() {
        this.cacheRegions.clear();
        List<Region> l = Region.getRegions();
        double currentZoomValue = this.getCurrentZoomValue();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Region region = l.get(i);
            if (i != 138 && i != 147 && i != 148 && i != 149) {
                this.cacheRegions.add(new RegionPointsCache(region, currentZoomValue));
            }
            ++i;
        }
    }

    public void centerScreenXYLambert(long xLambert, long yLambert) {
        if (xLambert == Long.MAX_VALUE) {
            xLambert = 664843L;
        }
        if (yLambert == Long.MAX_VALUE) {
            yLambert = 6872333L;
        }
        System.out.println("\nCenterScreenLatLong: " + xLambert + "," + yLambert);
        System.out.println("Panel:" + this.getWidth() + " " + this.getHeight());
        System.out.println("Old OffSet: " + this.offsetX + "," + this.offsetY);
        this.dx = 0.0;
        this.dy = 0.0;
        this.offsetX = xLambert;
        this.offsetY = yLambert;
        System.out.println("New OffSet: " + this.offsetX + "," + this.offsetY);
        this.offsetX = this.XToLongitude(-this.getWidth() / 2);
        this.offsetY = this.YTolatitude(1.5 * (double)this.getHeight());
        System.out.println("New OffSet: " + this.offsetX + "," + this.offsetY);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)g;
        Stroke oStroke = g2.getStroke();
        g.setColor(Color.BLACK);
        this.drawRegion(g2);
        List<Ville> onScreenVille = this.getOnScreenVille();
        this.drawVille(g2, onScreenVille);
        this.drawPaintedArea(g2);
        this.drawEchelle(g2);
        if (this.highLightedPoint != null) {
            g2.setColor(Color.RED);
            int x = this.longitudeToX(this.highLightedPoint.getX());
            int y = this.latitudeToY(this.highLightedPoint.getY());
            g2.drawRect(x, y, 2, 2);
        }
        g2.setStroke(oStroke);
    }

    private List<Ville> getOnScreenVille() {
        ArrayList<Ville> l = new ArrayList<Ville>();
        long minXLambertViewable = this.XToLongitude(0.0);
        long minYLambertViewable = this.YTolatitude(0.0);
        long maxXLambertViewable = this.XToLongitude(this.getWidth());
        long maxYLambertViewable = this.YTolatitude(this.getHeight());
        int vCount = this.cacheVilles.size();
        int i = 0;
        while (i < vCount) {
            Ville v = this.cacheVilles.get(i);
            if (v.getXLambert() >= minXLambertViewable && v.getXLambert() <= maxXLambertViewable && v.getYLambert() <= minYLambertViewable && v.getYLambert() >= maxYLambertViewable) {
                l.add(v);
            }
            ++i;
        }
        return l;
    }

    private void drawPaintedArea(Graphics2D g2) {
        if (this.drawX.size() > 2) {
            g2.setColor(new Color(255, 0, 0, 128));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setStroke(new BasicStroke(1.0f));
            int[] toArrayX = this.drawX.toArray();
            int[] toArrayY = this.drawY.toArray();
            g2.fillPolygon(toArrayX, toArrayY, this.drawX.size());
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(3.0f));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawPolyline(toArrayX, toArrayY, this.drawX.size());
            g2.setColor(Color.GRAY);
            g2.drawLine(toArrayX[0], toArrayY[0], toArrayX[this.drawX.size() - 1], toArrayY[this.drawX.size() - 1]);
        } else if (this.getSelectedPoints().size() > 2) {
            g2.setColor(new Color(255, 0, 0, 128));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setStroke(new BasicStroke(1.0f));
            ArrayListOfInt x = new ArrayListOfInt(this.getSelectedPoints().size());
            ArrayListOfInt y = new ArrayListOfInt(this.getSelectedPoints().size());
            int i = 0;
            while (i < this.getSelectedPoints().size()) {
                MapPoint element = this.getSelectedPoints().get(i);
                x.add(this.longitudeToX(element.getX()));
                y.add(this.latitudeToY(element.getY()));
                ++i;
            }
            int[] toArrayX = x.toArray();
            int[] toArrayY = y.toArray();
            g2.fillPolygon(toArrayX, toArrayY, toArrayX.length);
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(3.0f));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawPolygon(toArrayX, toArrayY, toArrayX.length);
        }
    }

    private void drawEchelle(Graphics2D g) {
        int width = 100;
        if (this.isGridActivated()) {
            g.setColor(new Color(12, 35, 250));
            float[] dash = new float[]{10.0f};
            g.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
            int maxX = 1 + this.getWidth() / width;
            int maxY = 1 + this.getHeight() / width;
            int i = 0;
            while (i < maxX) {
                g.drawLine(width / 2 + i * width, 0, width / 2 + i * width, this.getHeight());
                ++i;
            }
            int j = 0;
            while (j < maxY) {
                g.drawLine(0, width / 2 + j * width, this.getWidth(), width / 2 + j * width);
                ++j;
            }
        }
        g.setStroke(BASIC_STROKE);
        int posX = width / 2;
        int posY = this.getHeight() - 20;
        int height = 5;
        g.setColor(new Color(255, 255, 255, 200));
        g.fillRect(posX - 10, posY - 12, width + 20, height + 30);
        g.setColor(Color.BLACK);
        g.drawLine(posX, posY, posX, posY + height);
        g.drawLine(posX, posY + height, posX + width, posY + height);
        g.drawLine(posX + width, posY, posX + width, posY + height);
        g.drawString("0", posX - 2, posY - 2);
        double f = (double)width * this.getCurrentZoomValue() / 930.0;
        String echelle = String.valueOf(Double.valueOf(f).intValue());
        Rectangle2D rect = this.getFont().getStringBounds(echelle, g.getFontRenderContext());
        g.drawString(echelle, (int)((double)(posX + width) - rect.getWidth() / 2.0), posY - 2);
        g.drawString("Kms", posX + width / 2 - 10, posY + 16);
    }

    public void setGridActivated(boolean b) {
        this.gridActicvated = b;
        this.repaint();
    }

    private boolean isGridActivated() {
        return this.gridActicvated;
    }

    private void addToCachedVille(Ville v) {
        if (!this.cacheVilles.contains(v)) {
            this.cacheVilles.add(v);
        }
    }

    private void rebuildVisibleVilleCache() {
        int zoom = this.currentZoomIndex;
        this.cacheVilles.clear();
        List<Ville> villes = Ville.getVilles();
        this.cacheVilles.addAll(this.alwayVisible);
        if (zoom == 0) {
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Paris (75000)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Lille (59800)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Marseille (13000)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Lyon (69000)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Bordeaux (33300)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Nantes (44200)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Toulouse (31500)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Le Havre (76620)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Strasbourg (67000)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Limoges (87280)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Dijon (21000)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Reims (51100)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Rennes (35000)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Orl\u00e9ans (45100)"));
            this.addToCachedVille(Ville.getVilleFromVilleEtCode("Pau (64000)"));
            Ville.sortByPopulation(this.cacheVilles);
            return;
        }
        int popMin = 0;
        popMin = zoom == 1 ? 100000 : (zoom == 2 ? 50000 : (zoom == 3 ? 20000 : (zoom == 4 ? 4000 : 1000)));
        int vCount = villes.size();
        int i = 0;
        while (i < vCount) {
            Ville v = villes.get(i);
            if (v.getPopulation() >= (long)popMin) {
                this.addToCachedVille(v);
            }
            ++i;
        }
        if (zoom == 1) {
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Villeurbanne (69100)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Aix-en-provence (13100)"));
        } else if (zoom == 2) {
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Villeurbanne (69100)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Villeneuve-d'ascq (59491)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Sartrouville (78500)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Versailles (78000)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("V\u00e9nissieux (69200)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Pessac (33600)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Antibes (06160)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("La Seyne-sur-mer (83500)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("M\u00e9rignac (33700)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Tourcoing (59200)"));
            this.removeIfNotAlwaysVisible(Ville.getVilleFromVilleEtCode("Roubaix (59100)"));
        }
        Ville.sortByPopulation(this.cacheVilles);
    }

    private void removeIfNotAlwaysVisible(Ville v) {
        if (!this.alwayVisible.contains(v)) {
            this.cacheVilles.remove(v);
        }
    }

    private void drawVille(Graphics2D g2, List<Ville> villes) {
        Rectangle2D rect;
        String label;
        int roundedY;
        int roundedX;
        ArrayList<Rectangle2D.Double> rectangles = new ArrayList<Rectangle2D.Double>();
        int vCount = villes.size();
        Font font = this.getFont();
        ArrayList<Ville> labelToDraw = new ArrayList<Ville>();
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.2f));
        int i = 0;
        while (i < vCount) {
            Ville v = villes.get(i);
            roundedX = Math.round(this.longitudeToX(v.getXLambert()));
            roundedY = Math.round(this.latitudeToY(v.getYLambert()));
            label = v.getName();
            rect = font.getStringBounds(label, g2.getFontRenderContext());
            rect.setRect((double)roundedX + rect.getX() - 4.0 - rect.getWidth() / 2.0, (double)roundedY - rect.getHeight() - 4.0, rect.getWidth() + 8.0, rect.getHeight());
            boolean overlap = false;
            int size = rectangles.size();
            int j = 0;
            while (j < size) {
                Rectangle2D r = (Rectangle2D)rectangles.get(j);
                if (rect.intersects(r)) {
                    overlap = true;
                    break;
                }
                ++j;
            }
            if (!overlap) {
                rectangles.add(new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() * 2.0));
            }
            if (this.alwayVisible.contains(v) || !overlap) {
                Color c = this.colors.get(v);
                if (c == null) {
                    c = COLOR_POINT_VILLE;
                }
                g2.setColor(c);
                int tailleOvale = 12;
                long population = v.getPopulation();
                if (population < 1000L) {
                    tailleOvale = 4;
                } else if (population < 10000L) {
                    tailleOvale = 6;
                } else if (population < 100000L) {
                    tailleOvale = 10;
                } else if (population < 250000L) {
                    tailleOvale = 12;
                    if (this.currentZoomIndex > 2) {
                        tailleOvale = 20;
                    }
                } else {
                    tailleOvale = 18;
                    if (this.currentZoomIndex > 2) {
                        tailleOvale = 24;
                    }
                }
                int demiOvale = tailleOvale / 2;
                g2.fillOval(roundedX - demiOvale, roundedY - demiOvale, tailleOvale, tailleOvale);
                g2.setColor(Color.DARK_GRAY);
                g2.drawOval(roundedX - demiOvale, roundedY - demiOvale, tailleOvale, tailleOvale);
            }
            if (!overlap || this.alwayVisible.contains(v) && this.currentZoomIndex == this.getMaxZoomIndex()) {
                labelToDraw.add(v);
            }
            ++i;
        }
        for (Ville v : this.hightlightVisible) {
            if (v == null) continue;
            double x1 = this.longitudeToX(v.getXLambert());
            double y1 = this.latitudeToY(v.getYLambert());
            int roundedX2 = (int)Math.round(x1);
            int roundedY2 = (int)Math.round(y1);
            g2.drawImage(this.imgMarker, roundedX2 -= 7, roundedY2 -= 34, null);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (Ville v : labelToDraw) {
            if (this.hightlightVisible.contains(v)) {
                g2.setColor(new Color(255, 255, 0, 200));
            } else if (this.quickdraw) {
                g2.setColor(new Color(255, 255, 255));
            } else {
                g2.setColor(new Color(255, 255, 255, 200));
            }
            roundedX = Math.round(this.longitudeToX(v.getXLambert()));
            roundedY = Math.round(this.latitudeToY(v.getYLambert()));
            label = v.getName();
            if (this.matching.get(v) != null) {
                label = String.valueOf(label) + " (" + this.matching.get(v) + ")";
            }
            rect = font.getStringBounds(label, g2.getFontRenderContext());
            rect.setRect((double)roundedX + rect.getX() - 4.0 - rect.getWidth() / 2.0, (double)roundedY - rect.getHeight() - 4.0, rect.getWidth() + 8.0, rect.getHeight());
            g2.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            int x = (int)(rect.getX() + 4.0);
            int y = (int)(rect.getY() + rect.getHeight() - 4.0);
            g2.setColor(Color.BLACK);
            g2.drawString(label, x, y);
        }
    }

    private int longitudeToX(long longitude) {
        return (int)(this.dx + ((double)longitude - this.offsetX) / this.getCurrentZoomValue());
    }

    private double getCurrentZoomValue() {
        return this.zoomValues.get(this.currentZoomIndex);
    }

    private long XToLongitude(double x) {
        return (long)(this.getCurrentZoomValue() * (x - this.dx) + this.offsetX);
    }

    private int latitudeToY(long lat) {
        return (int)(this.dy - ((double)lat - this.offsetY) / this.getCurrentZoomValue() + (double)this.getHeight());
    }

    private long YTolatitude(double y) {
        return (long)(this.getCurrentZoomValue() * (this.dy - y + (double)this.getHeight()) + this.offsetY);
    }

    private void drawRegion(Graphics2D g2) {
        int regionP = 0;
        int rCount = this.cacheRegions.size();
        long minXLambertViewable = this.XToLongitude(0.0);
        long minYLambertViewable = this.YTolatitude(0.0);
        long maxXLambertViewable = this.XToLongitude(this.getWidth());
        int finalHeight = this.getHeight();
        long maxYLambertViewable = this.YTolatitude(finalHeight);
        g2.setColor(Color.BLACK);
        int moveX = (int)(this.dx - this.offsetX / this.getCurrentZoomValue());
        int moveY = (int)(this.dy + (double)this.getHeight() + this.offsetY / this.getCurrentZoomValue());
        int i = 0;
        while (i < rCount) {
            RegionPointsCache r = this.cacheRegions.get(i);
            int regionPoints = r.size();
            if (regionPoints >= 50 && r.getMaxX() >= minXLambertViewable && r.getMaxY() >= maxYLambertViewable && r.getMinX() <= maxXLambertViewable && r.getMinY() <= minYLambertViewable) {
                int[] x = new int[regionPoints];
                int[] y = new int[regionPoints];
                System.arraycopy(r.absX, 0, x, 0, regionPoints);
                System.arraycopy(r.absY, 0, y, 0, regionPoints);
                this.regionToPoly(moveX, moveY, x, y);
                int pointCount = x.length;
                regionP += pointCount;
                if (pointCount > 3) {
                    g2.setStroke(BASIC_STROKE);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g2.setColor(new Color(242, 240, 232));
                    g2.fillPolygon(x, y, pointCount - 1);
                    if (!this.quickdraw) {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    g2.setColor(Color.LIGHT_GRAY);
                    g2.setStroke(STROKE_CONTOUR);
                    g2.drawPolygon(x, y, pointCount - 1);
                }
            }
            ++i;
        }
    }

    private void regionToPoly(int moveX, int moveY, int[] x, int[] y) {
        int stop = x.length;
        int j = 0;
        while (j < stop) {
            int n = j;
            x[n] = x[n] + moveX;
            y[j] = moveY - y[j];
            ++j;
        }
    }

    public String getStatus() {
        String s = "Zoom:" + this.getCurrentZoomValue() + " dx:" + this.dx + ",dy" + this.dy + " Mouse:" + this.getCurrentMouseX() + "," + this.getCurrentMouseY();
        s = String.valueOf(s) + " Long: " + this.XToLongitude(this.getCurrentMouseX()) + ", " + this.YTolatitude(this.getCurrentMouseY());
        s = String.valueOf(s) + " | OffsetX: " + this.offsetX + ", " + this.offsetY;
        return s;
    }

    public int getCurrentMouseX() {
        return this.currentMouseX;
    }

    public void setCurrentMouseX(int currentMouseX) {
        this.currentMouseX = currentMouseX;
    }

    public int getCurrentMouseY() {
        return this.currentMouseY;
    }

    public void setCurrentMouseY(int currentMouseY) {
        this.currentMouseY = currentMouseY;
    }

    public void addVilleRendererListener(VilleRendererListener l) {
        this.listenersVille.add(l);
    }

    public void fireVilleRendererListener() {
        int i = 0;
        while (i < this.listenersVille.size()) {
            this.listenersVille.get(i).selectionChanged(this);
            ++i;
        }
    }

    public MapPointSelection getSelectedPoints() {
        return this.selectedPoints;
    }

    public void setSelectedPoints(MapPointSelection selectedPoints) {
        this.selectedPoints.mutateTo(selectedPoints);
        this.centerScreenXYLambert(selectedPoints.getMinX(), selectedPoints.getMinY());
        this.supp.firePropertyChange("selectedPoints", null, this.selectedPoints);
        this.repaint();
    }

    public void centerOn(Ville v) {
        System.out.println("Centering on:" + v);
        if (v != null) {
            this.centerScreenXYLambert(v.getXLambert(), v.getYLambert());
        }
    }

    public void setAlwayVisible(Ville v, Color color) {
        this.colors.put(v, color);
        this.setAlwayVisible(v);
    }

    public void setMatchingVille(List<Ville> v, Color c) {
        for (Ville ville : v) {
            this.alwayVisible.add(ville);
            this.colors.put(ville, c);
            this.incrementMacthing(ville);
        }
        this.rebuildVisibleVilleCache();
        this.repaint();
    }

    public void zoomIn() {
        if (this.currentZoomIndex < this.getMaxZoomIndex()) {
            this.setZoomIndex(this.currentZoomIndex + 1);
        }
    }

    public void zoomOut() {
        if (this.currentZoomIndex > 0) {
            this.setZoomIndex(this.currentZoomIndex - 1);
        }
    }

    public int getMaxZoomIndex() {
        return this.zoomValues.size() - 1;
    }

    @Override
    public String getValue() {
        return this.getSelectedPoints().toDBString();
    }

    @Override
    public void resetValue() {
        this.getSelectedPoints().clear();
    }

    @Override
    public void setValue(String val) {
        this.setSelectedPoints(new MapPointSelection(val));
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void addZoomListener(ZoomListener z) {
        this.zoomListener = z;
    }
}

