/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.openconcerto.map.ui.StatusPanel;
import org.openconcerto.map.ui.VilleRendererPanel;

public class MapViewerPanel
extends JPanel {
    final VilleRendererPanel villeRendererPanel = new VilleRendererPanel();

    public MapViewerPanel() {
        this(false, false);
    }

    public MapViewerPanel(boolean viewOnly) {
        this(viewOnly, false);
    }

    public MapViewerPanel(boolean viewOnly, boolean mapOnTop) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        StatusPanel statusPanel = null;
        if (!mapOnTop) {
            statusPanel = this.addMap(viewOnly, c);
        }
        this.villeRendererPanel.setBorder(BorderFactory.createEtchedBorder());
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.villeRendererPanel, c);
        if (mapOnTop) {
            statusPanel = this.addMap(viewOnly, c);
        }
        this.villeRendererPanel.addVilleRendererListener(statusPanel);
    }

    private StatusPanel addMap(boolean viewOnly, GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        StatusPanel statusPanel = new StatusPanel(this.villeRendererPanel, viewOnly);
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)statusPanel, c);
        return statusPanel;
    }

    public VilleRendererPanel getVilleRendererPanel() {
        return this.villeRendererPanel;
    }
}

