/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openconcerto.map.model.Ville;
import org.openconcerto.map.ui.ITextComboCacheVille;
import org.openconcerto.map.ui.MapViewerPanel;
import org.openconcerto.map.ui.VilleEditorPanel;
import org.openconcerto.map.ui.VilleListModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class ITextComboVilleViewer
extends JPanel
implements DocumentComponent,
TextComponent,
ValueWrapper<Ville> {
    private static final long serialVersionUID = 3397210337907076649L;
    private final ISearchableCombo<Ville> text;
    private final JButton button = new JButton("Afficher sur la carte");
    private final JButton buttonAdd;
    private Ville currentVille = null;
    private final ValueChangeSupport<Ville> supp;
    private final ITextComboCacheVille cache;

    public ITextComboVilleViewer() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 2);
        this.buttonAdd = new JButton(new ImageIcon(ITextComboVilleViewer.class.getResource("add.png")));
        this.supp = new ValueChangeSupport<Ville>(this);
        this.cache = new ITextComboCacheVille();
        this.text = new ISearchableCombo<Ville>(ComboLockedMode.ITEMS_LOCKED, 0, 17){

            @Override
            protected Ville stringToT(String t) {
                Ville v = Ville.getVilleFromVilleEtCode(t);
                return v;
            }
        };
        this.text.setMaxVisibleRows(20);
        this.text.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITextComboVilleViewer.this.supp.fireValueChange();
            }
        });
        this.text.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                ITextComboVilleViewer.this.supp.fireValidChange();
            }
        });
        final VilleListModel acache = new VilleListModel();
        this.text.initCache(acache);
        final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                acache.fireModify();
            }
        };
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                Ville.removeListener(listener);
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                Ville.addListener(listener);
            }
        });
        c.weightx = 1.0;
        c.fill = 2;
        this.add(this.text, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.button.setOpaque(false);
        this.add((Component)this.button, c);
        ++c.gridx;
        this.buttonAdd.setPreferredSize(new Dimension(24, 16));
        this.buttonAdd.setBorder(BorderFactory.createEmptyBorder());
        this.buttonAdd.setOpaque(false);
        this.buttonAdd.setContentAreaFilled(false);
        this.buttonAdd.setFocusPainted(false);
        this.buttonAdd.setFocusable(false);
        this.add((Component)this.buttonAdd, c);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame();
                MapViewerPanel mapViewerPanel = new MapViewerPanel(true);
                f.setContentPane(mapViewerPanel);
                f.setDefaultCloseOperation(2);
                f.setSize(600, 500);
                f.setMinimumSize(new Dimension(600, 500));
                File conf = new File(System.getProperty("user.home"), ".java" + File.separator + "ilm" + File.separator + "map" + File.separator);
                new WindowStateManager(f, new File(conf, "Configuration" + File.separator + "MapFrame.properties"), true).loadState();
                f.setVisible(true);
                if (ITextComboVilleViewer.this.currentVille != null) {
                    long x = ITextComboVilleViewer.this.currentVille.getXLambert();
                    long y = ITextComboVilleViewer.this.currentVille.getYLambert();
                    f.setTitle(ITextComboVilleViewer.this.currentVille.getName());
                    mapViewerPanel.getVilleRendererPanel().centerScreenXYLambert(x, y);
                    mapViewerPanel.getVilleRendererPanel().setHighlight(ITextComboVilleViewer.this.currentVille);
                    mapViewerPanel.getVilleRendererPanel().setAlwayVisible(ITextComboVilleViewer.this.currentVille);
                }
            }
        });
        this.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITextComboVilleViewer.this.currentVille = evt.getNewValue() == null ? null : Ville.getVilleFromVilleEtCode(evt.getNewValue().toString());
                ITextComboVilleViewer.this.button.setEnabled(ITextComboVilleViewer.this.currentVille != null && ITextComboVilleViewer.this.isEnabled());
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ITextComboVilleViewer.this), true);
                String rawTtext = ITextComboVilleViewer.this.text.getTextComp().getText();
                d.setContentPane(new VilleEditorPanel(rawTtext));
                d.setTitle("Nouvelle ville");
                d.pack();
                d.setResizable(false);
                d.setLocationRelativeTo(ITextComboVilleViewer.this);
                d.setVisible(true);
            }
        });
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public Document getDocument() {
        return this.text.getDocument();
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text.getTextComp();
    }

    @Override
    public Ville getValue() {
        return this.text.getValue();
    }

    @Override
    public ValidState getValidState() {
        return this.text.getValidState();
    }

    @Override
    public void resetValue() {
        this.text.resetValue();
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    public void setButtonVisible(boolean b) {
        this.button.setVisible(b);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setValue(Ville val) {
        this.text.setValue(val);
    }
}

