/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.model;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.map.model.MapPoint;

public class MapPointSelection {
    private final List<MapPoint> points = new ArrayList<MapPoint>();
    long maxX = 0L;
    long maxY = 0L;
    long minX = Long.MAX_VALUE;
    long minY = Long.MAX_VALUE;

    public MapPointSelection() {
        this(null);
    }

    public MapPointSelection(String dbString) {
        if (dbString != null && dbString.length() > 0) {
            String[] pts = dbString.split(";");
            int i = 0;
            while (i < pts.length) {
                String string = pts[i];
                int index = string.indexOf(44);
                String sx = string.substring(0, index);
                String sy = string.substring(index + 1);
                MapPoint p = new MapPoint(Long.parseLong(sx), Long.parseLong(sy));
                this.add(p);
                ++i;
            }
        }
    }

    public void mutateTo(MapPointSelection o) {
        this.clear();
        this.points.addAll(o.points);
        this.maxX = o.maxX;
        this.maxY = o.maxY;
        this.minX = o.minX;
        this.minY = o.minY;
    }

    public void add(MapPoint p) {
        if (!this.points.contains(p)) {
            long x = p.getX();
            long y = p.getY();
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            this.points.add(p);
        }
    }

    public String toDBString() {
        String r = "";
        int i = 0;
        while (i < this.points.size()) {
            MapPoint element = this.points.get(i);
            r = String.valueOf(r) + element.getX() + "," + element.getY();
            if (i != this.points.size() - 1) {
                r = String.valueOf(r) + ";";
            }
            ++i;
        }
        return r;
    }

    public void clear() {
        this.maxX = 0L;
        this.maxY = 0L;
        this.minX = Long.MAX_VALUE;
        this.minY = Long.MAX_VALUE;
        this.points.clear();
    }

    public int size() {
        return this.points.size();
    }

    public MapPoint get(int i) {
        return this.points.get(i);
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMinY() {
        return this.minY;
    }
}

