/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.utils.cc.IPredicate;

public final class Dependency {
    private final Map<String, IPredicate<ModuleFactory>> predicates;

    public static final List<Dependency> createList(List<String> ids) {
        ArrayList<Dependency> res = new ArrayList<Dependency>(ids.size());
        for (String id : ids) {
            res.add(Dependency.createFromReference(new ModuleReference(id, null)));
        }
        return res;
    }

    public static final Dependency createFromIDs(List<String> ids) {
        LinkedHashMap<String, IPredicate<ModuleFactory>> map = new LinkedHashMap<String, IPredicate<ModuleFactory>>(ids.size());
        for (String id : ids) {
            map.put(id, Dependency.createPred(new ModuleReference(id, null)));
        }
        return new Dependency(Collections.unmodifiableMap(map), true);
    }

    public static final Dependency createFromReferences(List<ModuleReference> refs) {
        LinkedHashMap<String, IPredicate<ModuleFactory>> map = new LinkedHashMap<String, IPredicate<ModuleFactory>>(refs.size());
        for (ModuleReference ref : refs) {
            map.put(ref.getID(), Dependency.createPred(ref));
        }
        return new Dependency(Collections.unmodifiableMap(map), true);
    }

    private static final IPredicate<ModuleFactory> createPred(ModuleReference ref) {
        final ModuleVersion version = ref.getVersion();
        return version == null ? IPredicate.truePredicate() : new IPredicate<ModuleFactory>(){

            @Override
            public boolean evaluateChecked(ModuleFactory input) {
                return version.equals(input.getVersion());
            }
        };
    }

    public static final Dependency createFromFactory(ModuleFactory f) {
        return Dependency.createFromReference(f.getReference());
    }

    public static final Dependency createFromReference(ModuleReference ref) {
        return new Dependency(ref.getID(), Dependency.createPred(ref));
    }

    public Dependency(String moduleID, IPredicate<ModuleFactory> pred) {
        this(Collections.singletonMap(moduleID, pred), true);
    }

    public Dependency(Map<String, IPredicate<ModuleFactory>> map) {
        this(map, false);
    }

    private Dependency(Map<String, IPredicate<ModuleFactory>> map, boolean mapSafe) {
        Map<String, IPredicate<ModuleFactory>> map2 = this.predicates = mapSafe ? map : Collections.unmodifiableMap(new LinkedHashMap<String, IPredicate<ModuleFactory>>(map));
        if (this.predicates.size() == 0) {
            throw new IllegalArgumentException("Empty");
        }
    }

    public final Set<String> getRequiredIDs() {
        return this.predicates.keySet();
    }

    public final boolean isRequiredFactoryOK(ModuleFactory f) {
        IPredicate<ModuleFactory> pred = this.predicates.get(f.getID());
        if (pred == null) {
            return false;
        }
        return pred.evaluateChecked(f);
    }
}

