/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openconcerto.erp.modules.DepSolverGraph;
import org.openconcerto.erp.modules.DepSolverResult;
import org.openconcerto.erp.modules.Dependency;
import org.openconcerto.erp.modules.DependencyGraph;
import org.openconcerto.erp.modules.FactoriesByID;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.erp.modules.VirtualModuleFactory;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;

final class DepSolver {
    private static final Logger L = ModuleManager.L;
    private int maxSuccess = 1;
    private DepSolverResult.Factory resultFactory;
    private ITransformer<? super DepSolverResult, ValidState> resultPred;
    private final Deque<Work> toTry = new LinkedList<Work>();
    private final LinkedHashMap<FactoriesByID, DepSolverResult> tried = new LinkedHashMap();

    public DepSolver() {
        this.setResultFactory(null);
        this.setResultFilter(null);
    }

    public final DepSolver setMaxSuccess(int maxSuccess) {
        if (maxSuccess < 1 || maxSuccess > 100) {
            throw new IllegalArgumentException("Max success : " + maxSuccess);
        }
        this.maxSuccess = maxSuccess;
        return this;
    }

    public final int getMaxSuccess() {
        return this.maxSuccess;
    }

    public final DepSolver setResultFilter(ITransformer<? super DepSolverResult, ValidState> resultPred) {
        this.resultPred = resultPred;
        return this;
    }

    public final DepSolver setResultFactory(DepSolverResult.Factory resultFactory) {
        this.resultFactory = resultFactory;
        return this;
    }

    private final DepSolverResult createResult(DepSolverResult parent, int tryCount, String error, DepSolverGraph graph) {
        if (this.resultFactory == null) {
            return new DepSolverResult(parent, tryCount, error, graph);
        }
        return this.resultFactory.create(parent, tryCount, error, graph);
    }

    final List<DepSolverResult> solve(FactoriesByID pool, DependencyGraph currentGraph, List<ModuleReference> refs) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>(refs.size());
        for (ModuleReference ref : refs) {
            deps.add(Dependency.createFromReference(ref));
        }
        VirtualModuleFactory virtualFactory = new VirtualModuleFactory(new ModuleReference(String.valueOf(this.getClass().getName()) + ".virtual", ModuleVersion.MIN), this.getClass().getName(), deps);
        return this.solve(pool, currentGraph, virtualFactory, true);
    }

    final List<DepSolverResult> solve(FactoriesByID pool, DependencyGraph currentGraph, ModuleFactory factory) {
        return this.solve(pool, currentGraph, factory, false);
    }

    final synchronized List<DepSolverResult> solve(FactoriesByID pool, DependencyGraph currentGraph, ModuleFactory factory, boolean virtualRoot) {
        Work current;
        if (factory == null) {
            throw new NullPointerException("Null factory");
        }
        if (this.maxSuccess == 0) {
            return Collections.emptyList();
        }
        if (!virtualRoot && !pool.contains(factory)) {
            throw new IllegalArgumentException("Factory not in pool : " + factory);
        }
        this.toTry.clear();
        this.toTry.add(new Work(null, pool, new DepSolverGraph(factory, virtualRoot, currentGraph)));
        this.tried.clear();
        LinkedHashMap<DepSolverGraph, DepSolverResult> res = new LinkedHashMap<DepSolverGraph, DepSolverResult>();
        int tryCount = 15000;
        while (res.size() < this.maxSuccess && this.tried.size() < 15000 && (current = this.toTry.poll()) != null) {
            FactoriesByID factories = (FactoriesByID)current.get1();
            if (this.tried.containsKey(factories)) continue;
            DepSolverResult parentRes = (DepSolverResult)current.get0();
            if (L.isLoggable(Level.FINER)) {
                String reason = parentRes == null ? "" : "Because of " + parentRes + "\n";
                L.finer(String.valueOf(reason) + "Trying " + factories + "\nwith " + current.get2());
            }
            DepSolverResult solve = this.solve(parentRes, this.tried.size(), factories, (DepSolverGraph)current.get2(), null, null, factory);
            solve.getGraph().freeze();
            if (solve.getError() == null) {
                ValidState validity;
                ValidState validState = validity = this.resultPred == null ? ValidState.getTrueInstance() : this.resultPred.transformChecked(solve);
                if (!validity.isValid()) {
                    L.log(Level.FINE, "Ignoring {0} : " + validity, solve);
                } else if (!res.containsKey(solve.getGraph())) {
                    res.put(solve.getGraph(), solve);
                }
            }
            this.tried.put(factories, solve);
        }
        return new ArrayList<DepSolverResult>(res.values());
    }

    final synchronized int getTriedCount() {
        return this.tried.size();
    }

    private final void addWork(DepSolverResult parent, FactoriesByID factories, DepSolverGraph graph, Set<ModuleFactory> toRemove) {
        if (!this.tried.containsKey(factories)) {
            factories = new FactoriesByID(factories);
            factories.removeAll(toRemove);
            this.toTry.add(new Work(parent, factories, graph.copyAndRemove(toRemove)));
        }
    }

    private final DepSolverResult solve(DepSolverResult parent, int tryCount, FactoriesByID factories, DepSolverGraph graph, ModuleFactory requiredByFactory, Object requiredByDep, ModuleFactory f) {
        DepSolverGraph.NodeState state = graph.getState(f);
        if (state == DepSolverGraph.NodeState.SOLVED) {
            if (requiredByFactory != null) {
                graph.addDependency(requiredByFactory, requiredByDep, f);
            }
            return this.createResult(parent, tryCount, null, graph);
        }
        if (state == DepSolverGraph.NodeState.SOLVING) {
            DepSolverResult cycleRes = this.createResult(parent, tryCount, "cycle", graph);
            ModuleFactory current = requiredByFactory;
            while (current != f) {
                this.addWork(cycleRes, factories, graph, Collections.singleton(current));
                current = graph.getPreviousSolving(current);
            }
            this.addWork(cycleRes, factories, graph, Collections.singleton(current));
            return cycleRes;
        }
        assert (state == DepSolverGraph.NodeState.NOT_SOLVING);
        Set<ModuleFactory> conflicts = graph.getConflicts(f);
        if (conflicts.size() > 0) {
            DepSolverResult conflictRes = this.createResult(parent, tryCount, "conflict", graph);
            HashSet<ModuleFactory> toRemove = new HashSet<ModuleFactory>();
            for (SortedMap<ModuleVersion, ModuleFactory> m : factories.getMap().values()) {
                for (ModuleFactory mf : m.values()) {
                    boolean conflictFound = false;
                    Iterator<ModuleFactory> iter = conflicts.iterator();
                    while (iter.hasNext() && !conflictFound) {
                        ModuleFactory conflict = iter.next();
                        conflictFound = conflict.conflictsWith(mf);
                    }
                    if (!conflictFound) continue;
                    toRemove.add(mf);
                }
            }
            assert (toRemove.contains(f));
            this.addWork(conflictRes, factories, graph, toRemove);
            toRemove.clear();
            for (SortedMap<ModuleVersion, ModuleFactory> m : factories.getMap().values()) {
                for (ModuleFactory mf : m.values()) {
                    if (!f.conflictsWith(mf)) continue;
                    toRemove.add(mf);
                }
            }
            assert (!toRemove.contains(f));
            this.addWork(conflictRes, factories, graph, toRemove);
            this.addWork(conflictRes, factories, graph, Collections.singleton(f));
            for (ModuleFactory conflict : conflicts) {
                this.addWork(conflictRes, factories, graph, Collections.singleton(conflict));
            }
            toRemove.clear();
            toRemove.addAll(conflicts);
            toRemove.add(f);
            this.addWork(conflictRes, factories, graph, toRemove);
            return conflictRes;
        }
        graph.addSolving(requiredByFactory, requiredByDep, f);
        for (Map.Entry<Object, Dependency> e : f.getDependencies().entrySet()) {
            Object depID = e.getKey();
            Dependency dep = e.getValue();
            ModuleFactory dependency = graph.getDependency(f, depID);
            assert (dependency == null || graph.getState(dependency) == DepSolverGraph.NodeState.SOLVED);
            if (dependency == null) {
                Set<String> graphIDs = graph.getIDs();
                HashSet<String> rootIDs = new HashSet<String>(graph.getRootIDs());
                LinkedList<String> inGraph = new LinkedList<String>();
                LinkedList inRoots = new LinkedList();
                LinkedList nowhere = new LinkedList();
                for (String requiredID : dep.getRequiredIDs()) {
                    LinkedList<String> l = graphIDs.contains(requiredID) ? inGraph : (rootIDs.contains(requiredID) ? inRoots : nowhere);
                    l.add(requiredID);
                }
                LinkedList<String> requiredIDs = inGraph;
                requiredIDs.addAll(inRoots);
                requiredIDs.addAll(nowhere);
                ModuleFactory found = null;
                for (String reqID : requiredIDs) {
                    LinkedList<ModuleFactory> candidates = new LinkedList<ModuleFactory>(factories.getVersions(reqID).values());
                    while (found == null && candidates.size() > 0) {
                        DepSolverResult recRes;
                        ModuleFactory current = (ModuleFactory)candidates.remove();
                        assert (current != null);
                        if (!dep.isRequiredFactoryOK(current) || (recRes = this.solve(parent, tryCount, factories, graph, f, depID, current)).getError() != null) continue;
                        found = current;
                    }
                    if (found != null) break;
                }
                if (found == null) {
                    return this.createResult(parent, tryCount, "missing dependency", graph);
                }
            }
            assert (graph.getState(graph.getDependency(f, depID)) == DepSolverGraph.NodeState.SOLVED);
        }
        graph.setSolved(f);
        return this.createResult(parent, tryCount, null, graph);
    }

    private static final class Work
    extends Tuple3<DepSolverResult, FactoriesByID, DepSolverGraph> {
        public Work(DepSolverResult a, FactoriesByID b, DepSolverGraph c) {
            super(a, b, c);
        }
    }
}

