/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import org.openconcerto.utils.GestionDevise;

public class PrixHT {
    private double ht;
    private long value;

    public PrixHT(double ht) {
        long pi;
        this.value = pi = Math.round(100.0 * ht);
        this.ht = (double)pi / 100.0;
    }

    public PrixHT(long value) {
        this.value = value;
    }

    public double calculTTC(double taxe) {
        return (double)Math.round(100.0 * (this.ht + this.calculTVA(taxe))) / 100.0;
    }

    public double calculTVA(double taxe) {
        return (double)Math.round(100.0 * taxe * this.ht) / 100.0;
    }

    public double getValue() {
        return (double)Math.round(100.0 * this.ht) / 100.0;
    }

    public float getFloatValue() {
        return (float)Math.round(100.0 * this.ht) / 100.0f;
    }

    public long calculLongTVA(float taxe) {
        return Math.round(taxe * (float)this.value);
    }

    public long calculLongTTC(float taxe) {
        return this.value + this.calculLongTVA(taxe);
    }

    public long getLongValue() {
        return this.value;
    }

    public String toString() {
        return GestionDevise.currencyToString(this.value);
    }
}

