/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAchat;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieAchat
extends GenerationEcritures
implements Runnable {
    public static final String ID = "accounting.records.supply.order";
    private final SQLRow saisieRow;
    private static final String source = "SAISIE_ACHAT";
    private static final Integer journal = new Integer(2);
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableFournisseur = base.getTable("FOURNISSEUR");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtSaisieAchat(SQLRow row) {
        this.setRowAnalytiqueSource(row);
        this.saisieRow = row;
        this.idMvt = row.getInt("ID_MOUVEMENT");
    }

    public void genereMouvement() throws Exception {
        int idCompteFourn;
        SQLRowValues rowValsPiece;
        SQLRow rowFournisseur = tableFournisseur.getRow(this.saisieRow.getInt("ID_FOURNISSEUR"));
        this.date = (Date)this.saisieRow.getObject("DATE");
        this.nom = "Achat : " + rowFournisseur.getString("NOM") + " Facture : " + this.saisieRow.getObject("NUMERO_FACTURE").toString() + " " + this.saisieRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", this.date);
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get(ID);
        provider.putLabel(this.saisieRow, this.mEcritures);
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", new Integer(1));
        PrixTTC prixTTC = new PrixTTC(this.saisieRow.getLong("MONTANT_TTC"));
        PrixHT prixTVA = new PrixHT(this.saisieRow.getLong("MONTANT_TVA"));
        PrixHT prixHT = new PrixHT(this.saisieRow.getLong("MONTANT_HT"));
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(this.saisieRow, rowValsPiece);
            this.getNewMouvement(source, this.saisieRow.getID(), 1, rowValsPiece);
        } else {
            rowValsPiece = pieceTable.getTable("MOUVEMENT").getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(this.saisieRow, rowValsPiece);
            rowValsPiece.update();
            this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
        }
        int idCompteAchat = this.saisieRow.getInt("ID_COMPTE_PCE");
        if (idCompteAchat <= 1 && (idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteAchat));
        this.mEcritures.put("DEBIT", new Long(prixHT.getLongValue()));
        this.mEcritures.put("CREDIT", new Long(0L));
        SQLRow rowEcr = this.ajoutEcriture();
        if (prixTVA.getLongValue() > 0L) {
            SQLRow rowCptTva;
            int idCompteTVA;
            if (this.saisieRow.getBoolean("IMMO").booleanValue()) {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_IMMO");
                if (idCompteTVA <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVAImmo");
                }
            } else {
                rowCptTva = this.saisieRow.getForeign("ID_TAXE").getForeign(rowFournisseur.getBoolean("UE") != false ? "ID_COMPTE_PCE_DED_INTRA" : "ID_COMPTE_PCE_DED");
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT");
                    if (idCompteTVA <= 1) {
                        idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVADeductible");
                    }
                } else {
                    idCompteTVA = ((SQLRowAccessor)rowCptTva).getID();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVA));
            this.mEcritures.put("DEBIT", new Long(prixTVA.getLongValue()));
            this.mEcritures.put("CREDIT", new Long(0L));
            this.ajoutEcriture();
            if (rowFournisseur.getBoolean("UE").booleanValue()) {
                int idCompteTVAIntra;
                rowCptTva = this.saisieRow.getForeign("ID_TAXE").getForeign("ID_COMPTE_PCE_COLLECTE_INTRA");
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    idCompteTVAIntra = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_INTRA");
                    if (idCompteTVAIntra <= 1) {
                        idCompteTVAIntra = ComptePCESQLElement.getIdComptePceDefault("TVAIntraComm");
                    }
                } else {
                    idCompteTVAIntra = ((SQLRowAccessor)rowCptTva).getID();
                }
                this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVAIntra));
                this.mEcritures.put("DEBIT", new Long(0L));
                this.mEcritures.put("CREDIT", new Long(prixTVA.getLongValue()));
                this.ajoutEcriture();
            }
        }
        if ((idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
            idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteFourn));
        this.mEcritures.put("DEBIT", new Long(0L));
        if (rowFournisseur.getBoolean("UE").booleanValue()) {
            this.mEcritures.put("CREDIT", new Long(prixHT.getLongValue()));
        } else {
            this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
        }
        this.ajoutEcriture();
        new GenerationMvtReglementAchat(this.saisieRow, this.idMvt);
        SQLRowValues valAchat = this.saisieRow.createEmptyUpdateRow();
        valAchat.put("ID_MOUVEMENT", new Integer(this.idMvt));
        valAchat.update();
        this.displayMvtNumber();
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

