/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtReglementVenteFacture
extends GenerationEcritures
implements Runnable {
    private int idSaisieVenteFacture;
    private static final Integer journalCaisse = new Integer(5);
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private int idPere = 1;

    public GenerationMvtReglementVenteFacture(int idSaisieVenteFacture, int idMvt) {
        this.idSaisieVenteFacture = idSaisieVenteFacture;
        System.err.println("**************Init Generation Reglement");
        this.idPere = idMvt;
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            PrixTTC prixTTC;
            System.err.println("****g\u00e9n\u00e9ration des ecritures de r\u00e8glement vente facture");
            SQLRow saisieRow = base.getTable("SAISIE_VENTE_FACTURE").getRow(this.idSaisieVenteFacture);
            SQLRow clientRow = base.getTable("CLIENT").getRow(saisieRow.getInt("ID_CLIENT"));
            SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(saisieRow.getInt("ID_MODE_REGLEMENT"));
            SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
            int idAvoir = saisieRow.getInt("ID_AVOIR_CLIENT");
            if (idAvoir > 1) {
                long l = ((Number)saisieRow.getObject("T_AVOIR_TTC")).longValue();
                prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC") - l);
            } else {
                prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC"));
            }
            if (prixTTC.getLongValue() == 0L) {
                return;
            }
            this.date = (Date)saisieRow.getObject("DATE");
            this.nom = "Saisie Vente facture " + saisieRow.getObject("NUMERO").toString() + " (" + typeRegRow.getString("NOM") + ")";
            if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
                if (typeRegRow.getID() == 2) {
                    this.paiementCheque(this.date);
                } else {
                    this.setDateReglement(saisieRow);
                    if (typeRegRow.getID() == 4) {
                        this.mEcritures.put("ID_JOURNAL", journalCaisse);
                    } else {
                        this.fillJournalBanqueFromRow(modeRegRow);
                    }
                    this.idMvt = this.idPere;
                    this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
                    this.mEcritures.put("NOM", this.nom);
                    this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
                    int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                    if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteClient));
                    this.mEcritures.put("DEBIT", new Long(0L));
                    this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
                    this.ajoutEcriture();
                    this.fillCompteBanqueFromRow(modeRegRow, "VenteCB", false);
                    this.mEcritures.put("DEBIT", new Long(prixTTC.getLongValue()));
                    this.mEcritures.put("CREDIT", new Long(0L));
                    this.ajoutEcriture();
                }
            } else {
                Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
                if (typeRegRow.getID() == 2) {
                    this.paiementCheque(dateEch);
                } else {
                    System.err.println("Ech\u00e9ance client");
                    SQLRowValues valEcheance = new SQLRowValues(base.getTable("ECHEANCE_CLIENT"));
                    valEcheance.put("DATE", dateEch);
                    valEcheance.put("MONTANT", new Long(prixTTC.getLongValue()));
                    valEcheance.put("ID_CLIENT", new Integer(saisieRow.getInt("ID_CLIENT")));
                    SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
                    this.idMvt = this.getNewMouvement("ECHEANCE_CLIENT", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
                    valEcheance.put("ID_MOUVEMENT", new Integer(this.idMvt));
                    if (valEcheance.getInvalid() == null) {
                        SQLRow row = valEcheance.insert();
                        SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                        rowVals.put("IDSOURCE", row.getID());
                        rowVals.update(this.idMvt);
                    }
                }
            }
            System.err.println("****End g\u00e9n\u00e9ration des ecritures de r\u00e8glement vente facture");
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }

    private void setDateReglement(SQLRow saisieRow) throws SQLException {
        SQLRowValues rowValsUpdateVF = saisieRow.createEmptyUpdateRow();
        rowValsUpdateVF.put("DATE_REGLEMENT", new Timestamp(this.date.getTime()));
        rowValsUpdateVF.update();
    }

    private void paiementCheque(Date dateEch) throws SQLException {
        PrixTTC prixTTC;
        SQLRow saisieRow = base.getTable("SAISIE_VENTE_FACTURE").getRow(this.idSaisieVenteFacture);
        int idAvoir = saisieRow.getInt("ID_AVOIR_CLIENT");
        if (idAvoir > 1) {
            long l = ((Number)saisieRow.getObject("T_AVOIR_TTC")).longValue();
            prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC") - l);
        } else {
            prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC"));
        }
        SQLRowValues valEncaisse = new SQLRowValues(base.getTable("CHEQUE_A_ENCAISSER"));
        valEncaisse.put("ID_CLIENT", new Integer(saisieRow.getInt("ID_CLIENT")));
        valEncaisse.put("DATE_VENTE", new java.sql.Date(this.date.getTime()));
        valEncaisse.put("DATE_MIN_DEPOT", new java.sql.Date(dateEch.getTime()));
        if (saisieRow.isForeignEmpty("ID_MODE_REGLEMENT")) {
            SQLRow rowModeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
            valEncaisse.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
        }
        SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
        this.idMvt = this.getNewMouvement("CHEQUE_A_ENCAISSER", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
        valEncaisse.put("ID_MOUVEMENT", new Integer(this.idMvt));
        valEncaisse.put("MONTANT", new Long(prixTTC.getLongValue()));
        if (valEncaisse.getInvalid() == null) {
            SQLRow row = valEncaisse.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }
}

