/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public final class GenerationMvtReglementFactureFournisseur
extends GenerationEcritures
implements Runnable {
    private int idfacture;
    private static final Integer journalCaisse = 5;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private int idPere = 1;

    public GenerationMvtReglementFactureFournisseur(int idFacture, int idMvt) {
        this.idfacture = idFacture;
        this.idPere = idMvt;
        new Thread(this).start();
    }

    private void genereReglement() throws Exception {
        System.out.println("G\u00e9n\u00e9ration des ecritures du reglement du mouvement " + this.idMvt);
        SQLRow saisieRow = base.getTable("FACTURE_FOURNISSEUR").getRow(this.idfacture);
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(saisieRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        System.out.println("Mode de reglement " + saisieRow.getInt("ID_MODE_REGLEMENT"));
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC"));
        this.date = (java.util.Date)saisieRow.getObject("DATE");
        SQLRow rowFournisseur = base.getTable("FOURNISSEUR").getRow(saisieRow.getInt("ID_FOURNISSEUR"));
        this.nom = "R\u00e8glement Achat : " + rowFournisseur.getString("NOM") + " Facture : " + saisieRow.getObject("NUMERO").toString() + " (" + typeRegRow.getString("NOM") + ")";
        if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            System.out.println("R\u00e8glement Comptant");
            if (typeRegRow.getID() == 2) {
                Calendar c = modeRegRow.getDate("DATE_DEPOT");
                if (c != null) {
                    this.paiementCheque(c.getTime());
                } else {
                    this.paiementCheque(this.date);
                }
            } else {
                this.idMvt = this.idPere;
                this.mEcritures.put("DATE", new Date(this.date.getTime()));
                this.mEcritures.put("NOM", this.nom);
                this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
                if (typeRegRow.getID() == 4) {
                    this.mEcritures.put("ID_JOURNAL", journalCaisse);
                } else {
                    this.fillJournalBanqueFromRow(modeRegRow);
                }
                int compteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
                if (compteFourn <= 1 && (compteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
                    compteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                }
                this.mEcritures.put("ID_COMPTE_PCE", compteFourn);
                this.mEcritures.put("DEBIT", prixTTC.getLongValue());
                this.mEcritures.put("CREDIT", 0L);
                this.ajoutEcriture();
                if (typeRegRow.getID() == 4) {
                    int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_FOURN");
                    if (idCompteRegl <= 1) {
                        idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("AchatEspece");
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteRegl);
                } else {
                    this.fillCompteBanqueFromRow(modeRegRow, "AchatCB", true);
                }
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", prixTTC.getLongValue());
                this.ajoutEcriture();
            }
        } else {
            java.util.Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            System.out.println("Date d'\u00e9ch\u00e9ance " + dateFormat.format(dateEch));
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch);
            } else {
                HashMap<String, Comparable<Integer>> mEcheance = new HashMap<String, Comparable<Integer>>();
                SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
                this.idMvt = this.getNewMouvement("ECHEANCE_FOURNISSEUR", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
                mEcheance.put("ID_MOUVEMENT", Integer.valueOf(this.idMvt));
                mEcheance.put("DATE", new Date(dateEch.getTime()));
                mEcheance.put("MONTANT", Long.valueOf(prixTTC.getLongValue()));
                mEcheance.put("ID_FOURNISSEUR", Integer.valueOf(saisieRow.getInt("ID_FOURNISSEUR")));
                SQLTable echeanceTable = base.getTable("ECHEANCE_FOURNISSEUR");
                SQLRowValues valEcheance = new SQLRowValues(echeanceTable, mEcheance);
                if (valEcheance.getInvalid() == null) {
                    SQLRow row = valEcheance.insert();
                    SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                    rowVals.put("IDSOURCE", row.getID());
                    rowVals.update(this.idMvt);
                }
            }
        }
    }

    private void paiementCheque(java.util.Date dateEch) throws SQLException {
        SQLRow saisieRow = base.getTable("FACTURE_FOURNISSEUR").getRow(this.idfacture);
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC"));
        HashMap<String, Comparable<Integer>> mEncaisse = new HashMap<String, Comparable<Integer>>();
        mEncaisse.put("ID_FOURNISSEUR", Integer.valueOf(saisieRow.getInt("ID_FOURNISSEUR")));
        mEncaisse.put("DATE_ACHAT", new Date(this.date.getTime()));
        mEncaisse.put("DATE_MIN_DECAISSE", new Date(dateEch.getTime()));
        mEncaisse.put("MONTANT", Long.valueOf(prixTTC.getLongValue()));
        if (!saisieRow.isForeignEmpty("ID_MODE_REGLEMENT")) {
            SQLRow rowModeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
            mEncaisse.put("ID_" + BanqueSQLElement.TABLENAME, Integer.valueOf(rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME)));
        }
        SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
        this.idMvt = this.getNewMouvement("CHEQUE_FOURNISSEUR", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
        mEncaisse.put("ID_MOUVEMENT", Integer.valueOf(this.idMvt));
        SQLTable chqFournTable = base.getTable("CHEQUE_FOURNISSEUR");
        SQLRowValues valDecaisse = new SQLRowValues(chqFournTable, mEncaisse);
        if (valDecaisse.getInvalid() == null) {
            SQLRow row = valDecaisse.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }

    @Override
    public void run() {
        try {
            this.genereReglement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

