/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtReglementAvoir
extends GenerationEcritures
implements Runnable {
    private int idAvoir;
    private static final Integer journalCaisse = new Integer(5);
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private int idPere = 1;

    @Override
    public void run() {
        try {
            System.err.println("****g\u00e9n\u00e9ration des ecritures de r\u00e8glement d'avoir");
            SQLRow avoirRow = base.getTable("AVOIR_CLIENT").getRow(this.idAvoir);
            SQLRow clientRow = avoirRow.getForeignRow("ID_CLIENT");
            SQLRow modeRegRow = avoirRow.getForeignRow("ID_MODE_REGLEMENT");
            SQLRow typeRegRow = modeRegRow.getForeignRow("ID_TYPE_REGLEMENT");
            PrixTTC prixTTC = new PrixTTC((Long)avoirRow.getObject("MONTANT_TTC"));
            this.date = (Date)avoirRow.getObject("DATE");
            this.nom = "Avoir client " + avoirRow.getString("NUMERO") + " (" + typeRegRow.getString("NOM") + ")";
            if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
                if (typeRegRow.getID() == 2) {
                    this.paiementCheque(this.date);
                } else {
                    if (typeRegRow.getID() == 4) {
                        this.mEcritures.put("ID_JOURNAL", journalCaisse);
                    } else {
                        this.fillJournalBanqueFromRow(modeRegRow);
                    }
                    this.idMvt = this.idPere;
                    this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
                    this.mEcritures.put("NOM", this.nom);
                    this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
                    int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                    if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteClient));
                    this.mEcritures.put("DEBIT", new Long(prixTTC.getLongValue()));
                    this.mEcritures.put("CREDIT", new Long(0L));
                    this.ajoutEcriture();
                    if (typeRegRow.getID() == 4) {
                        int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_CLIENT");
                        if (idCompteRegl <= 1) {
                            idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("VenteEspece");
                        }
                        this.mEcritures.put("ID_COMPTE_PCE", idCompteRegl);
                    } else {
                        this.fillCompteBanqueFromRow(modeRegRow, "VenteCB", false);
                    }
                    this.mEcritures.put("DEBIT", new Long(0L));
                    this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
                    this.ajoutEcriture();
                }
            } else {
                Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
                if (typeRegRow.getID() == 2) {
                    this.paiementCheque(dateEch);
                } else {
                    System.err.println("Pas d'\u00e9ch\u00e9ance pour les avoirs");
                }
            }
            SQLRowValues rowValsAvoir = avoirRow.createEmptyUpdateRow();
            rowValsAvoir.put("SOLDE", Boolean.TRUE);
            rowValsAvoir.update();
            System.err.println("****End g\u00e9n\u00e9ration des ecritures de r\u00e8glement vente facture");
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des ecritures de r\u00e8glement facture", e);
        }
    }

    private void paiementCheque(Date dateEch) throws SQLException {
        SQLRow saisieRow = base.getTable("AVOIR_CLIENT").getRow(this.idAvoir);
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC"));
        SQLRowValues valEncaisse = new SQLRowValues(base.getTable("CHEQUE_AVOIR_CLIENT"));
        valEncaisse.put("ID_CLIENT", new Integer(saisieRow.getInt("ID_CLIENT")));
        valEncaisse.put("DATE_AVOIR", this.date);
        valEncaisse.put("DATE_MIN_DECAISSE", dateEch);
        if (!saisieRow.isForeignEmpty("ID_MODE_REGLEMENT")) {
            SQLRow rowModeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
            valEncaisse.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
        }
        SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
        this.idMvt = this.getNewMouvement("CHEQUE_AVOIR_CLIENT", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
        valEncaisse.put("ID_MOUVEMENT", new Integer(this.idMvt));
        valEncaisse.put("MONTANT", new Long(prixTTC.getLongValue()));
        if (valEncaisse.getInvalid() == null) {
            SQLRow row = valEncaisse.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }

    public GenerationMvtReglementAvoir(SQLRow rowAvoir, int idMvt) {
        this.setRowAnalytiqueSource(rowAvoir);
        this.idAvoir = rowAvoir.getID();
        this.idPere = idMvt;
        new Thread(this).start();
    }
}

