/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.AnalytiqueCache;
import org.openconcerto.erp.generationEcritures.provider.AnalytiqueProvider;
import org.openconcerto.erp.generationEcritures.provider.AnalytiqueProviderManager;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationEcritures {
    protected static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    protected static final SQLTable compteTable = base.getTable("COMPTE_PCE");
    protected static final SQLTable journalTable = base.getTable("JOURNAL");
    protected static final SQLTable ecritureTable = base.getTable("ECRITURE");
    protected static final SQLTable pieceTable = base.getTable("PIECE");
    protected static final SQLTable mouvementTable = base.getTable("MOUVEMENT");
    protected int idMvt;
    protected int idPiece;
    protected Date date;
    protected String nom;
    private SQLRow rowAnalytiqueSource;
    public Map<String, Object> mEcritures = new HashMap<String, Object>();
    private static SQLTable tableAssoc = null;
    private static SQLTable tablePoste = Configuration.getInstance().getDirectory().getElement("POSTE_ANALYTIQUE").getTable();

    public void setRowAnalytiqueSource(SQLRow rowAnalytiqueSource) {
        this.rowAnalytiqueSource = rowAnalytiqueSource;
    }

    public SQLRow getRowAnalytiqueSource() {
        return this.rowAnalytiqueSource;
    }

    public synchronized SQLRow ajoutEcriture() throws IllegalArgumentException {
        Number n2;
        long debit = (Long)this.mEcritures.get("DEBIT");
        long credit = (Long)this.mEcritures.get("CREDIT");
        Number n = (Number)this.mEcritures.get("ID_JOURNAL");
        if (n != null) {
            SQLRow rowJrnl = journalTable.getRow(n.intValue());
            if (rowJrnl == null) {
                throw new IllegalArgumentException("Le journal qui a pour ID " + n + " a \u00e9t\u00e9 archiv\u00e9.");
            }
            this.mEcritures.put("JOURNAL_NOM", rowJrnl.getString("NOM"));
            this.mEcritures.put("JOURNAL_CODE", rowJrnl.getString("CODE"));
        }
        if ((n2 = (Number)this.mEcritures.get("ID_COMPTE_PCE")) != null) {
            SQLRow rowCpt = compteTable.getRow(n2.intValue());
            this.mEcritures.put("COMPTE_NUMERO", rowCpt.getString("NUMERO"));
            this.mEcritures.put("COMPTE_NOM", rowCpt.getString("NOM"));
        }
        if (debit != 0L && credit != 0L) {
            throw new IllegalArgumentException("Le d\u00e9bit et le cr\u00e9dit ne peuvent pas \u00eatre tous les 2 diff\u00e9rents de 0. Debit : " + debit + " Credit : " + credit);
        }
        if (debit < 0L) {
            credit = -debit;
            debit = 0L;
        }
        if (credit < 0L) {
            debit = -credit;
            credit = 0L;
        }
        this.mEcritures.put("DEBIT", debit);
        this.mEcritures.put("CREDIT", credit);
        Date d = (Date)this.mEcritures.get("DATE");
        SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = tableExercice.getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        Date dDebEx = (Date)rowExercice.getObject("DATE_DEB");
        Date dCloture = (Date)rowExercice.getObject("DATE_CLOTURE");
        if (dCloture != null) {
            if (dCloture.after(d)) {
                System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
                throw new IllegalArgumentException("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            }
        } else if (dDebEx.after(d)) {
            System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            throw new IllegalArgumentException("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
        }
        SQLRowValues valEcriture = new SQLRowValues(ecritureTable, this.mEcritures);
        valEcriture.put("IDUSER_CREATE", UserManager.getInstance().getCurrentUser().getId());
        try {
            if (valEcriture.getInvalid() == null) {
                SQLRow ecritureRow = valEcriture.insert();
                this.addAssocAnalytiqueFromProvider(ecritureRow, this.rowAnalytiqueSource);
                return ecritureRow;
            }
            System.err.println("GenerationEcritures.java :: Error in values for insert in table " + ecritureTable.getName() + " : " + valEcriture.toString());
            throw new IllegalArgumentException("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures donn\u00e9es incorrectes. " + valEcriture);
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + ecritureTable.getName() + " : " + e);
            final SQLException eFinal = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures.", eFinal);
                }
            });
            e.printStackTrace();
            return null;
        }
    }

    public void addAssocAnalytique(SQLRow rowEcr, int idPoste) throws SQLException {
        if (tablePoste.getUndefinedID() == idPoste) {
            return;
        }
        if (tableAssoc == null) {
            tableAssoc = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE").getTable();
        }
        SQLRowValues rowVals = new SQLRowValues(tableAssoc);
        rowVals.put("ID_POSTE_ANALYTIQUE", idPoste);
        rowVals.put("POURCENT", 100.0);
        rowVals.put("ID_ECRITURE", rowEcr.getID());
        rowVals.put("MONTANT", rowEcr.getLong("DEBIT") - rowEcr.getLong("CREDIT"));
        rowVals.commit();
    }

    public void addAssocAnalytiqueFromProvider(SQLRow rowEcr, SQLRow rowSource) throws SQLException {
        String numeroCpt = rowEcr.getString("COMPTE_NUMERO");
        if (rowSource != null && !rowSource.getTable().getName().equalsIgnoreCase("SAISIE_KM") && (numeroCpt.startsWith("6") || numeroCpt.startsWith("7"))) {
            for (SQLRow axe : AnalytiqueCache.getCache().getAxes()) {
                SQLRow poste;
                int assoc = 0;
                Collection<AnalytiqueProvider> l = AnalytiqueProviderManager.getAll();
                for (AnalytiqueProvider analytiqueProvider : l) {
                    List<SQLRow> result = analytiqueProvider.addAssociation(axe, rowEcr, rowSource);
                    if (result == null) continue;
                    assoc += result.size();
                }
                if (assoc != 0 || (poste = AnalytiqueCache.getCache().getDefaultPoste(axe.getID())) == null) continue;
                if (tableAssoc == null) {
                    tableAssoc = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE").getTable();
                }
                SQLRowValues rowVals = new SQLRowValues(tableAssoc);
                rowVals.put("ID_POSTE_ANALYTIQUE", poste.getID());
                rowVals.put("POURCENT", 100.0);
                rowVals.put("ID_ECRITURE", rowEcr.getID());
                rowVals.put("MONTANT", rowEcr.getLong("DEBIT") - rowEcr.getLong("CREDIT"));
                rowVals.put("GESTION_AUTO", Boolean.TRUE);
                rowVals.commit();
            }
        }
    }

    public void genereEcritures(List<SQLRowValues> l) {
        block6: {
            if (l == null) {
                return;
            }
            try {
                for (SQLRowValues rowVals : l) {
                    this.checkDateValide(rowVals);
                    this.checkDebitCreditValide(rowVals);
                }
                if (this.isSoldeNul(l)) {
                    for (SQLRowValues rowVals : l) {
                        rowVals.put("IDUSER_CREATE", UserManager.getInstance().getCurrentUser().getId());
                        rowVals.insert();
                    }
                    break block6;
                }
                throw new IllegalArgumentException("La partie double n'est pas respect\u00e9e. Impossible de g\u00e9n\u00e9rer les \u00e9critures comptables.");
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExceptionHandler.handle("", e);
                    }
                });
            }
        }
    }

    private void checkDateValide(SQLRowValues rowVals) throws Exception {
        Date d = (Date)rowVals.getObject("DATE");
        SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = tableExercice.getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        Date dDebEx = (Date)rowExercice.getObject("DATE_DEB");
        Date dCloture = (Date)rowExercice.getObject("DATE_CLOTURE");
        if (dCloture != null) {
            if (dCloture.after(d)) {
                System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
                throw new Exception("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            }
        } else if (dDebEx.after(d)) {
            System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            throw new Exception("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
        }
    }

    private void checkDebitCreditValide(SQLRowValues rowVals) throws Exception {
        long debit = rowVals.getLong("DEBIT");
        long credit = rowVals.getLong("CREDIT");
        if (debit != 0L && credit != 0L) {
            throw new Exception("Le d\u00e9bit et le cr\u00e9dit ne peuvent pas \u00eatre tous les 2 diff\u00e9rents de 0. Debit : " + debit + " Credit : " + credit);
        }
        if (debit < 0L) {
            credit = -debit;
            debit = 0L;
        }
        if (credit < 0L) {
            debit = -credit;
            credit = 0L;
        }
        rowVals.put("DEBIT", debit);
        rowVals.put("CREDIT", credit);
    }

    private boolean isSoldeNul(List<SQLRowValues> l) {
        long debit = 0L;
        long credit = 0L;
        for (SQLRowValues rowVals : l) {
            debit += rowVals.getLong("DEBIT");
            credit += rowVals.getLong("CREDIT");
        }
        return debit - credit == 0L;
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, SQLRowValues rowValsPiece) throws SQLException {
        SQLRow rowPiece = rowValsPiece.insert();
        return this.getNewMouvement(source, idSource, idPere, rowPiece.getID());
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, String nomPiece) throws SQLException {
        SQLRowValues rowValsPiece = new SQLRowValues(pieceTable);
        rowValsPiece.put("NOM", nomPiece);
        return this.getNewMouvement(source, idSource, idPere, rowValsPiece);
    }

    protected TotalCalculator getValuesFromElement(SQLRow row, SQLTable foreign, BigDecimal portHT, SQLRow rowTVAPort, SQLTable tableEchantillon) {
        return this.getValuesFromElement(false, false, "T_PV_HT", row, foreign, portHT, rowTVAPort, tableEchantillon, null);
    }

    protected TotalCalculator getValuesFromElement(boolean intra, boolean achat, String fieldTotalHT, SQLRow row, SQLTable foreign, BigDecimal portHT, SQLRow rowTVAPort, SQLTable tableEchantillon, SQLRow defaultCompte) {
        SQLRow produitCompte;
        SQLRow serviceCompte;
        TotalCalculator calc = new TotalCalculator("T_PA_HT", fieldTotalHT, null, achat, defaultCompte);
        calc.setIntraComm(intra);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
        if (row.getTable().contains("ID_COMPTE_PCE_SERVICE") && !row.isForeignEmpty("ID_COMPTE_PCE_SERVICE") && !(serviceCompte = row.getForeign("ID_COMPTE_PCE_SERVICE")).isUndefined()) {
            calc.setRowDefaultCptService(serviceCompte);
        }
        if (row.getTable().contains("ID_COMPTE_PCE_VENTE") && !row.isForeignEmpty("ID_COMPTE_PCE_VENTE") && !(produitCompte = row.getForeign("ID_COMPTE_PCE_VENTE")).isUndefined()) {
            calc.setRowDefaultCptProduit(produitCompte);
        }
        long remise = 0L;
        BigDecimal totalAvtRemise = BigDecimal.ZERO;
        if (row.getTable().contains("REMISE_HT") && (remise = row.getLong("REMISE_HT")) != 0L) {
            Collection rows = row.getReferentRows(foreign);
            for (SQLRow sqlRow : rows) {
                calc.addLine(sqlRow, sqlRow.getForeign("ID_ARTICLE"), 1, false);
            }
            if (tableEchantillon != null) {
                Collection rowsEch = row.getReferentRows(tableEchantillon);
                for (SQLRow sqlRow : rowsEch) {
                    calc.addEchantillon((BigDecimal)sqlRow.getObject("T_PV_HT"), sqlRow.getForeign("ID_TAXE"));
                }
            }
            calc.checkResult();
            totalAvtRemise = calc.getTotalHT();
        }
        calc.initValues();
        long valRemiseHTReel = remise;
        if (row.getFields().contains("POURCENT_FACTURABLE") && row.getFields().contains("MONTANT_FACTURABLE")) {
            BigDecimal montantFact = row.getBigDecimal("MONTANT_FACTURABLE");
            BigDecimal percentFact = row.getBigDecimal("POURCENT_FACTURABLE");
            if (montantFact != null && montantFact.signum() > 0) {
                valRemiseHTReel = 0L;
            } else if (percentFact != null && percentFact.signum() > 0) {
                valRemiseHTReel = percentFact.movePointLeft(2).multiply(new BigDecimal(remise)).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        calc.setRemise(valRemiseHTReel, totalAvtRemise);
        Collection rows = row.getReferentRows(foreign);
        int i = 0;
        while (i < rows.size()) {
            SQLRow sqlRow = (SQLRow)rows.get(i);
            calc.addLine(sqlRow, sqlRow.getForeign("ID_ARTICLE"), i, i == rows.size() - 1);
            ++i;
        }
        if (tableEchantillon != null) {
            Collection rowsEch = row.getReferentRows(tableEchantillon);
            for (SQLRow sqlRow : rowsEch) {
                calc.addEchantillon((BigDecimal)sqlRow.getObject("T_PV_HT"), sqlRow.getForeign("ID_TAXE"));
            }
        }
        if (rowTVAPort != null && !rowTVAPort.isUndefined()) {
            SQLRow rowDefaultCptPort;
            SQLRowValues rowValsPort = new SQLRowValues(foreign);
            rowValsPort.put("T_PV_HT", portHT);
            rowValsPort.put("QTE", 1);
            rowValsPort.put("ID_TAXE", rowTVAPort.getIDNumber());
            SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
            SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
            if (rowTVAPort.getFloat("TAUX") > 0.0f) {
                rowDefaultCptPort = rowPrefsCompte.getForeign("ID_COMPTE_PCE_PORT_SOUMIS");
                if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                    try {
                        rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteSoumisTVA");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                rowDefaultCptPort = rowPrefsCompte.getForeign("ID_COMPTE_PCE_PORT_NON_SOUMIS");
                if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                    try {
                        rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteNonSoumisTVA");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            SQLRowValues rowValsArt = rowValsPort.putRowValues("ID_ARTICLE");
            rowValsArt.put("ID_COMPTE_PCE", rowDefaultCptPort.getID());
            rowValsArt.put("ID_TAXE_COMPLEMENTAIRE", null);
            calc.addLine(rowValsPort, rowValsPort.getForeign("ID_ARTICLE"), 1, false);
        }
        calc.checkResult();
        return calc;
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, int idPiece) throws SQLException {
        SQLTable mouvementTable = base.getTable("MOUVEMENT");
        SQLSelect selNumMvt = new SQLSelect();
        selNumMvt.addSelect(mouvementTable.getField("NUMERO"), "MAX");
        String reqNumMvt = selNumMvt.asString();
        Object obNumMvt = base.getDataSource().executeScalar(reqNumMvt);
        int numMvt = 1;
        if (obNumMvt != null) {
            numMvt = Integer.parseInt(obNumMvt.toString());
        }
        ++numMvt;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("SOURCE", source);
        m.put("IDSOURCE", idSource);
        m.put("ID_MOUVEMENT_PERE", idPere);
        this.idPiece = idPiece;
        m.put("ID_PIECE", idPiece);
        m.put("NUMERO", numMvt);
        SQLRowValues val = new SQLRowValues(mouvementTable, m);
        if (val.getInvalid() != null) {
            throw new IllegalStateException("Error in values for insert in table " + val.getTable().getName() + " : " + val.toString());
        }
        SQLRow row = val.insert();
        this.idMvt = row.getID();
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        System.err.println("Numero de mouvement g\u00e9n\u00e9r\u00e9 : " + numMvt);
        return this.idMvt;
    }

    protected void displayMvtNumber() {
        if (DefaultNXProps.getInstance().getBooleanValue("ShowMouvementNumber", false)) {
            final int numero = mouvementTable.getRow(this.idMvt).getInt("NUMERO");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "N\u00b0 de mouvement associ\u00e9 : " + numero);
                }
            });
        }
    }

    protected void fillJournalBanqueFromRow(SQLRow sqlRow) {
        SQLRow rowBanque;
        this.mEcritures.put("ID_JOURNAL", 4);
        if (!sqlRow.isForeignEmpty("ID_" + BanqueSQLElement.TABLENAME) && !(rowBanque = sqlRow.getForeignRow("ID_" + BanqueSQLElement.TABLENAME)).isForeignEmpty("ID_JOURNAL")) {
            SQLRow rowJournal = rowBanque.getForeignRow("ID_JOURNAL");
            this.mEcritures.put("ID_JOURNAL", rowJournal.getID());
        }
    }

    protected void fillCompteBanqueFromRow(SQLRow sqlRow, String defaultProps, boolean achat) throws Exception {
        SQLRow rowBanque;
        int idPce = -1;
        idPce = sqlRow.getTable().contains("ID_TYPE_REGLEMENT") ? sqlRow.getForeign("ID_TYPE_REGLEMENT").getInt("ID_COMPTE_PCE_" + (achat ? "FOURN" : "CLIENT")) : base.getTable("TYPE_REGLEMENT").getRow(2).getInt("ID_COMPTE_PCE_" + (achat ? "FOURN" : "CLIENT"));
        if (idPce <= 1) {
            idPce = ComptePCESQLElement.getIdComptePceDefault(defaultProps);
        }
        if (!sqlRow.isForeignEmpty("ID_" + BanqueSQLElement.TABLENAME) && !(rowBanque = sqlRow.getForeignRow("ID_" + BanqueSQLElement.TABLENAME)).isForeignEmpty("ID_COMPTE_PCE")) {
            SQLRow rowCompteBanque = rowBanque.getForeignRow("ID_COMPTE_PCE");
            idPce = rowCompteBanque.getID();
        }
        this.mEcritures.put("ID_COMPTE_PCE", idPce);
    }
}

