/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.util.Arrays;
import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.erp.generationDoc.MetaDataSheet;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class DemandePrixSheetXML
extends AbstractSheetXMLWithDate {
    public static String TEMPLATE_ID = "DemandePrix";
    public static String TEMPLATE_PROPERTY_NAME = "LocationDmd";

    @Override
    public String getReference() {
        return this.row.getString("NUMERO");
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.row.getForeignRow("ID_FOURNISSEUR");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            return rowClient.getForeignRow("ID_LANGUE");
        }
        return super.getRowLanguage();
    }

    public DemandePrixSheetXML(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("dmdCliPrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("DEMANDE_PRIX");
        SQLRow foreign = this.row.getForeign("ID_FOURNISSEUR");
        if (foreign != null && !foreign.isUndefined()) {
            MetaDataSheet meta = new MetaDataSheet();
            meta.setKeywords(Arrays.asList(foreign.getString("NOM")));
            this.setMetaGeneration(meta);
        }
    }

    @Override
    public String getTemplateId() {
        return "DemandePrix";
    }

    @Override
    public String getName() {
        return "DemandePrix_" + this.row.getString("NUMERO");
    }

    @Override
    public String getDefaultTemplateId() {
        return "DemandePrix";
    }
}

