/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class TouchScrollPane
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    private JComponent child;
    private int mousePressedY;
    private double viewY;
    private int lastLocationOnscreen;

    public TouchScrollPane(JComponent l) {
        super(l);
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        if (!(l instanceof Scrollable)) {
            throw new IllegalArgumentException("Argument is not implementing Scrollable");
        }
        this.child = l;
        this.child.addMouseListener(this);
        this.child.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.RED);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < 100) {
            v.add("Item " + i);
            ++i;
        }
        JList l = new JList(v);
        l.putClientProperty("List.isFileList", Boolean.TRUE);
        l.setFixedCellHeight(50);
        TouchScrollPane t = new TouchScrollPane(l);
        f.setContentPane(t);
        f.setSize(200, 400);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressedY = e.getLocationOnScreen().y;
        this.viewY = this.getViewport().getViewPosition().getY();
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        if (e.getLocationOnScreen().y == this.lastLocationOnscreen) {
            return;
        }
        this.lastLocationOnscreen = e.getLocationOnScreen().y;
        int yDiff = this.mousePressedY;
        JViewport jv = this.getViewport();
        int newX = 0;
        int deplacementY = e.getLocationOnScreen().y - yDiff;
        int newY = (int)this.viewY - deplacementY;
        if (newY < 0) {
            newY = 0;
        }
        jv.setViewPosition(new Point(newX, newY));
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

