/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.erp.core.sales.pos.ui.POSRadioButton;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;

public class PriceEditorPanel
extends JPanel {
    CaisseFrame frame;
    private POSLabel labelPrice;
    private Article article;
    final POSRadioButton rHT;
    final POSRadioButton rTTC;
    final POSRadioButton rDiscountPercent;
    final POSRadioButton rDiscount;
    private NumericTextField htTextField;
    private NumericTextField ttcTextField;
    private NumericTextField discountPercentTextField;
    private NumericTextField discountTextField;

    public PriceEditorPanel(final CaisseFrame caisseFrame, final Article article) {
        this.article = article;
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 20, 30, 20);
        c.gridwidth = 2;
        POSLabel title = new POSLabel("Modification du prix de vente");
        this.add((Component)title, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.rHT = new POSRadioButton("prix HT");
        this.rHT.setSelected(true);
        c.weightx = 0.0;
        this.add((Component)this.rHT, c);
        this.htTextField = new NumericTextField();
        this.htTextField.setValue(article.getPriceWithoutTax());
        this.htTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.htTextField, c);
        ++c.gridy;
        this.rTTC = new POSRadioButton("prix TTC");
        this.htTextField.setValue(article.getPriceWithTax());
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)this.rTTC, c);
        this.ttcTextField = new NumericTextField();
        this.ttcTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.ttcTextField, c);
        ++c.gridy;
        this.rDiscountPercent = new POSRadioButton("remise en %");
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)this.rDiscountPercent, c);
        this.discountPercentTextField = new NumericTextField();
        this.discountPercentTextField.setValue(BigDecimal.ZERO);
        this.discountPercentTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.discountPercentTextField, c);
        this.rDiscount = new POSRadioButton("remise HT");
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        this.add((Component)this.rDiscount, c);
        this.discountTextField = new NumericTextField();
        this.discountTextField.setValue(BigDecimal.ZERO);
        this.discountTextField.setFont(title.getFont());
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.discountTextField, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rHT);
        group.add(this.rTTC);
        group.add(this.rDiscountPercent);
        group.add(this.rDiscount);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        POSLabel labelPriceOld = new POSLabel("Ancien Prix : ");
        BigDecimal ttc = Article.computePriceWithTax(this.article.getPriceWithoutTax(), this.article.getIdTaxe());
        this.ttcTextField.setValue(ttc);
        labelPriceOld.setText("Ancien Prix : " + TicketCellRenderer.toString(this.article.getPriceWithoutTax()) + " HT, " + TicketCellRenderer.toString(ttc));
        this.add((Component)labelPriceOld, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelPrice = new POSLabel("Nouveau Prix : ");
        this.add((Component)this.labelPrice, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 14;
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        POSButton bApply = new POSButton("Appliquer");
        buttons.add((Component)bApply, c);
        POSButton bCancel = new POSButton("Annuler");
        buttons.add((Component)bCancel, c);
        bApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                caisseFrame.getControler().setArticleHT(article, PriceEditorPanel.this.getHTFromUI());
                caisseFrame.showCaisse();
            }
        });
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                caisseFrame.showCaisse();
            }
        });
        this.add((Component)buttons, c);
        this.updatePrice(article.getPriceWithoutTax());
        this.updateTextFields();
        ActionListener listenerRadio = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriceEditorPanel.this.updatePrice(PriceEditorPanel.this.getHTFromUI());
                PriceEditorPanel.this.updateTextFields();
            }
        };
        this.rDiscount.addActionListener(listenerRadio);
        this.rDiscountPercent.addActionListener(listenerRadio);
        this.rHT.addActionListener(listenerRadio);
        this.rTTC.addActionListener(listenerRadio);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PriceEditorPanel.this.updatePrice(PriceEditorPanel.this.getHTFromUI());
            }
        };
        this.ttcTextField.getDocument().addDocumentListener(docListener);
        this.htTextField.getDocument().addDocumentListener(docListener);
        this.discountPercentTextField.getDocument().addDocumentListener(docListener);
        this.discountTextField.getDocument().addDocumentListener(docListener);
    }

    protected BigDecimal getHTFromUI() {
        BigDecimal r = null;
        try {
            if (this.rHT.isSelected()) {
                r = this.htTextField.getValue();
            } else if (this.rTTC.isSelected()) {
                BigDecimal value = this.ttcTextField.getValue();
                r = value != null ? Article.computePriceWithoutTax(value, this.article.getIdTaxe()) : BigDecimal.ZERO;
            } else if (this.rDiscountPercent.isSelected()) {
                r = this.article.getPriceWithoutTax().subtract(this.article.getPriceWithoutTax().multiply(this.discountPercentTextField.getValue().divide(new BigDecimal(100))));
            } else if (this.rDiscount.isSelected()) {
                r = this.article.getPriceWithoutTax().subtract(this.discountTextField.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (r == null) {
            r = this.article.getPriceWithoutTax();
        }
        return r;
    }

    void updatePrice(BigDecimal ht) {
        BigDecimal ttc = Article.computePriceWithTax(ht, this.article.getIdTaxe());
        this.labelPrice.setText("Nouveau Prix : " + TicketCellRenderer.toString(ht) + " HT, " + TicketCellRenderer.toString(ttc));
    }

    public void updateTextFields() {
        this.invalidate();
        this.htTextField.setVisible(false);
        this.ttcTextField.setVisible(false);
        this.discountPercentTextField.setVisible(false);
        this.discountTextField.setVisible(false);
        if (this.rHT.isSelected()) {
            this.htTextField.setVisible(true);
        } else if (this.rTTC.isSelected()) {
            this.ttcTextField.setVisible(true);
        } else if (this.rDiscountPercent.isSelected()) {
            this.discountPercentTextField.setVisible(true);
        } else if (this.rDiscount.isSelected()) {
            this.discountTextField.setVisible(true);
        }
        this.validate();
        this.repaint();
    }
}

