/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;

public class PaiementPanel
extends JPanel
implements MouseListener,
BarcodeListener,
CaisseListener {
    private static final int PAYMENT_POS_Y = 50;
    private static final int PAYMENT_LINE_HEIGHT = 60;
    private CaisseControler controller;
    private String calculatorValue = "";
    int calcHeight = 340;
    int calcWidth = 276;
    int BUTTON_SIZE = 64;
    private char mode = (char)32;
    private boolean init = true;

    public PaiementPanel(CaisseControler controller) {
        this.controller = controller;
        this.controller.addCaisseListener(this);
        this.controller.addBarcodeListener(this);
        this.setOpaque(false);
        this.addMouseListener(this);
        this.setLayout(null);
        StatusBar st = new StatusBar();
        st.setTitle("R\u00e8glement");
        st.setLocation(0, 0);
        st.setSize(320, (int)st.getPreferredSize().getHeight());
        this.add(st);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(new Color(250, 250, 250));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawLine(0, 0, 0, this.getHeight());
        int y = 50;
        for (Paiement p : this.controller.getPaiements()) {
            if (p.getType() == 3) {
                this.drawMontant(g, "CB", p, 227, y, true);
            } else if (p.getType() == 2) {
                this.drawMontant(g, "Ch\u00e8que", p, 227, y, true);
            } else if (p.getType() == 1) {
                this.drawMontant(g, "Esp\u00e8ces", p, 255, y, false);
            } else if (p.getType() == 4) {
                this.drawMontant(g, "Solde", p, 255, y, false);
            }
            y += 60;
        }
        this.drawKey(g2, "0", 0, 0, 2, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, ".", 2, 0, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "1", 0, 1, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "2", 1, 1, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "3", 2, 1, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "=", 3, 1, 1, 2, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "4", 0, 2, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "5", 1, 2, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "6", 2, 2, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "7", 0, 3, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "8", 1, 3, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "9", 2, 3, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "+", 3, 3, 1, 2, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "C", 0, 4, 2, 1, CaissePanel.LIGHT_BLUE);
        this.drawKey(g2, "x", 2, 4, 1, 1, CaissePanel.DARK_BLUE);
        this.drawKey(g2, "-", 3, 4, 1, 1, CaissePanel.DARK_BLUE);
        this.drawCalculator(g);
        super.paint(g);
    }

    private void drawKey(Graphics2D g2, String string, int col, int row, int w, int h, Color color) {
        g2.setColor(color);
        g2.fillRect(3 + col * 69, this.getHeight() - 68 * (row + 1) + 2, 69 * w - 5, 68 * h - 4);
        g2.setColor(Color.WHITE);
        g2.setFont(g2.getFont().deriveFont(32.0f));
        int width2 = (int)g2.getFontMetrics().getStringBounds(string, g2).getWidth();
        int x = -width2 / 2 + 34 + col * 69;
        int y = this.getHeight() - (row * 68 + 20);
        g2.drawString(string, x, y);
    }

    public int getLCDY() {
        return this.getHeight() - this.calcHeight - 66;
    }

    public int getLCDHeight() {
        return 64;
    }

    private void drawCalculator(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.controller.getArticleSelected() != null || this.controller.getPaiementSelected() != null) {
            g.setColor(new Color(232, 242, 254));
        } else {
            g.setColor(new Color(240, 240, 240));
        }
        g.fillRect(3, this.getLCDY(), this.getWidth() - 5, this.getLCDHeight());
        int y = this.getHeight() - this.calcHeight - 10;
        g.setFont(new Font("Arial", 0, 32));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Article article = this.controller.getArticleSelected();
        g.setColor(Color.DARK_GRAY);
        if (article != null) {
            String string = this.calculatorValue;
            g.setFont(g.getFont().deriveFont(52.0f));
            Rectangle2D r1 = g.getFontMetrics().getStringBounds(string, g2);
            g.drawString(string, (int)(260.0 - r1.getWidth()), y);
            g.setFont(g.getFont().deriveFont(14.0f));
            g.drawString("Quantit\u00e9", 10, 460 + y);
        } else {
            Paiement paiement = this.controller.getPaiementSelected();
            if (paiement != null) {
                String string = this.calculatorValue;
                g.setFont(g.getFont().deriveFont(52.0f));
                Rectangle2D r1 = g.getFontMetrics().getStringBounds(string, g2);
                g.drawString(string, (int)(260.0 - r1.getWidth()), y);
                g.setFont(g.getFont().deriveFont(14.0f));
                String str = "Paiement ";
                if (paiement.getType() == 3) {
                    str = String.valueOf(str) + " CB";
                } else if (paiement.getType() == 1) {
                    str = String.valueOf(str) + " en esp\u00e8ces";
                } else if (paiement.getType() == 2) {
                    str = String.valueOf(str) + " par ch\u00e8que";
                } else if (paiement.getType() == 4) {
                    str = String.valueOf(str) + " depuis solde";
                }
                g.drawString(str, 10, y - 40);
            }
        }
        g.setFont(g.getFont().deriveFont(14.0f));
        g.drawString("" + this.mode, 10, y - 20);
    }

    private char getToucheFrom(int x, int y) {
        int yy = (this.getHeight() - y) / 68;
        int xx = x / 69;
        switch (yy) {
            case 0: {
                if (xx == 0) {
                    return '0';
                }
                if (xx == 1) {
                    return '0';
                }
                if (xx == 2) {
                    return '.';
                }
                if (xx != 3) break;
                return '=';
            }
            case 1: {
                if (xx == 0) {
                    return '1';
                }
                if (xx == 1) {
                    return '2';
                }
                if (xx == 2) {
                    return '3';
                }
                if (xx != 3) break;
                return '=';
            }
            case 2: {
                if (xx == 0) {
                    return '4';
                }
                if (xx == 1) {
                    return '5';
                }
                if (xx == 2) {
                    return '6';
                }
                if (xx != 3) break;
                return '+';
            }
            case 3: {
                if (xx == 0) {
                    return '7';
                }
                if (xx == 1) {
                    return '8';
                }
                if (xx == 2) {
                    return '9';
                }
                if (xx != 3) break;
                return '+';
            }
            case 4: {
                if (xx == 0) {
                    return 'c';
                }
                if (xx == 1) {
                    return 'c';
                }
                if (xx == 2) {
                    return '*';
                }
                if (xx != 3) break;
                return '-';
            }
        }
        return '?';
    }

    private void drawMontant(Graphics g, String label, Paiement p, int x, int y, boolean showAdd) {
        y += 36;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int cents = p.getMontantInCents() % 100;
        int euros = p.getMontantInCents() / 100;
        g.setColor(new Color(240, 240, 240));
        g.fillRect(3, y - 36, this.getWidth() - 5, 44);
        g.setColor(CaissePanel.DARK_BLUE);
        g.fillRect(3, y - 36, 95, 44);
        if (showAdd) {
            g.setColor(CaissePanel.DARK_BLUE);
            g.fillRect(this.getWidth() - 46, y - 36, 44, 44);
        }
        g.setFont(g.getFont().deriveFont(20.0f));
        g.setFont(g.getFont().deriveFont(1));
        g.setColor(Color.WHITE);
        g.drawString(label, 10, y - 8);
        if (showAdd) {
            g.drawString("+", this.getWidth() - 32, y - 8);
        }
        g.setColor(Color.GRAY);
        String sCents = String.valueOf(cents);
        if (sCents.length() < 2) {
            sCents = "0" + sCents;
        }
        g.setFont(this.getFont().deriveFont(18.0f));
        Rectangle2D r1 = g.getFontMetrics().getStringBounds(sCents, g2);
        g.drawString(sCents, (int)((double)x - r1.getWidth()), y);
        g.setFont(g.getFont().deriveFont(36.0f));
        g.setFont(g.getFont().deriveFont(1));
        g.setColor(Color.BLACK);
        String sEuros = String.valueOf(String.valueOf(euros)) + ".";
        Rectangle2D r2 = g.getFontMetrics().getStringBounds(sEuros, g2);
        g.drawString(sEuros, (int)((double)x - r1.getWidth() - r2.getWidth()), y);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.calcWidth, 768);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.calcWidth, 768);
    }

    @Override
    public void caisseStateChanged() {
        if (this.controller.getArticleSelected() != null) {
            this.initCaisseArticle();
        } else if (this.controller.getPaiementSelected() != null) {
            this.initCaissePaiement();
        }
        boolean soldeIsShown = false;
        for (Paiement p : this.controller.getPaiements()) {
            if (p.getType() != 4) continue;
            soldeIsShown = true;
            break;
        }
        if (this.controller.isClientDefined()) {
            if (!soldeIsShown && this.controller.getClient().getSolde().signum() == 1) {
                this.controller.addPaiement(new Paiement(4));
            }
        } else if (soldeIsShown) {
            List<Paiement> paiements = this.controller.getPaiements();
            int i = 0;
            while (i < paiements.size()) {
                Paiement p = paiements.get(i);
                if (p.getType() == 4) {
                    this.controller.getPaiements().remove(i);
                    break;
                }
                ++i;
            }
        }
        this.repaint();
    }

    private void initCaisseArticle() {
        this.calculatorValue = String.valueOf(this.controller.getItemCount(this.controller.getArticleSelected()));
        this.init = true;
        this.mode = (char)32;
    }

    private void initCaissePaiement() {
        this.calculatorValue = TicketCellRenderer.centsToString(this.controller.getPaiementSelected().getMontantInCents());
        this.init = true;
        this.mode = (char)32;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getY() > this.getLCDY() && e.getY() < this.getLCDY() + this.getLCDHeight()) {
            this.lcdPressed();
            return;
        }
        char c = this.getToucheFrom(e.getX(), e.getY());
        if (c != '?') {
            this.handleCharacter(c);
        } else {
            Paiement p = this.getPaiementFrom(e.getY());
            if (p != null) {
                if (e.getX() > this.getWidth() - 68 && p.getType() != 1 && this.controller.canAddPaiement(p.getType())) {
                    p = new Paiement(p.getType());
                    this.controller.addPaiement(p);
                }
                this.controller.autoFillPaiement(p);
                this.calculatorValue = TicketCellRenderer.centsToString(p.getMontantInCents());
                try {
                    this.controller.openDrawer();
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(this, "Ouverture du tiroir caisse impossible");
                }
                if (p.getType() == 3) {
                    this.controller.sendCBRequest(p);
                }
            }
            this.controller.setPaiementSelected(p);
        }
    }

    public void lcdPressed() {
        System.err.println("PaiementPanel.lcdPressed()");
        Article articleSelected = this.controller.getArticleSelected();
        if (articleSelected != null) {
            this.controller.openPriceEditor(articleSelected);
        }
        this.repaint();
    }

    private void handleCharacter(char c) {
        System.out.println("Handle: " + c);
        if (c == '?') {
            return;
        }
        Article article = this.controller.getArticleSelected();
        if (c == '+' || c == '-' || c == '*') {
            this.mode = c;
            this.repaint();
            return;
        }
        if (article != null) {
            if (c == 'c' || c == '/') {
                System.out.println("Clear quantit\u00e9");
                this.mode = (char)32;
                this.controller.clearArticle(article);
            } else if (c == '=' || c == '\n') {
                if (!this.init) {
                    int v = Integer.parseInt(this.calculatorValue);
                    if (this.mode == ' ') {
                        this.controller.setArticleCount(article, v);
                    } else if (this.mode == '+') {
                        this.controller.setArticleCount(article, this.controller.getItemCount(article) + v);
                    } else if (this.mode == '-') {
                        this.controller.setArticleCount(article, this.controller.getItemCount(article) - v);
                    } else if (this.mode == '*') {
                        this.controller.setArticleCount(article, this.controller.getItemCount(article) * v);
                    }
                }
                this.initCaisseArticle();
            } else if (Character.isDigit(c)) {
                if (this.init) {
                    this.calculatorValue = "";
                    this.init = false;
                }
                if (this.calculatorValue.length() < 8) {
                    this.calculatorValue = String.valueOf(this.calculatorValue) + c;
                }
            }
        } else {
            Paiement paiement = this.controller.getPaiementSelected();
            if (paiement != null) {
                if (c == 'c' || c == '/') {
                    System.out.println("Clear paiement");
                    this.mode = (char)32;
                    this.controller.clearPaiement(paiement);
                } else if (c == '.' && this.calculatorValue.indexOf(46) < 0) {
                    this.calculatorValue = String.valueOf(this.calculatorValue) + ".";
                } else if (c == '=' || c == '\n') {
                    if (!this.init) {
                        int v = this.getCentsFrom(this.calculatorValue);
                        if (this.mode == ' ') {
                            this.controller.setPaiementValue(paiement, v);
                        } else if (this.mode == '+') {
                            this.controller.setPaiementValue(paiement, paiement.getMontantInCents() + v);
                        } else if (this.mode == '-') {
                            this.controller.setPaiementValue(paiement, paiement.getMontantInCents() - v);
                        } else if (this.mode == '*') {
                            this.controller.setPaiementValue(paiement, paiement.getMontantInCents() * v);
                        }
                    }
                    this.initCaissePaiement();
                    this.controller.setPaiementSelected(null);
                } else if (Character.isDigit(c)) {
                    int i;
                    if (this.init) {
                        this.calculatorValue = "";
                        this.init = false;
                    }
                    if (this.calculatorValue.length() < 9 && ((i = this.calculatorValue.indexOf(46)) < 0 || this.calculatorValue.length() - i < 3)) {
                        this.calculatorValue = String.valueOf(this.calculatorValue) + c;
                    }
                }
            }
        }
        this.repaint();
    }

    private int getCentsFrom(String str) {
        int i = str.indexOf(46);
        if (i >= 0) {
            String euros = str.substring(0, i);
            String cents = str.substring(i + 1);
            if (cents.length() == 1) {
                cents = String.valueOf(cents) + "0";
            }
            int e = 0;
            if (euros.length() > 0) {
                e = Integer.parseInt(euros);
            }
            int c = 0;
            if (cents.length() > 0) {
                c = Integer.parseInt(cents);
            }
            return e * 100 + c;
        }
        return Integer.parseInt(str) * 100;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void barcodeRead(String code) {
    }

    private Paiement getPaiementFrom(int y) {
        int index = (y - 50) / 60;
        if (index < this.controller.getPaiements().size() && index >= 0) {
            return this.controller.getPaiements().get(index);
        }
        return null;
    }

    @Override
    public void keyReceived(KeyEvent e) {
        if (e.getID() == 400) {
            System.out.println("PaiementPanel.keyPressed()" + e.getKeyChar());
            this.handleCharacter(e.getKeyChar());
        }
    }
}

