/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jdom2.JDOMException;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.model.DBState;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterDB;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseMenuPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.ListeDesClientsPanel;
import org.openconcerto.erp.core.sales.pos.ui.ListeDesTicketsPanel;
import org.openconcerto.erp.core.sales.pos.ui.POSGlassPane;
import org.openconcerto.erp.core.sales.pos.ui.PriceEditorPanel;
import org.openconcerto.sql.RemoteShell;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.utils.ClassPathLoader;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ExnTransformer;

public class CaisseFrame
extends JFrame {
    private final ComptaPropsConfiguration conf;
    private final RegisterFiles files;
    private final RegisterDB registerDB;
    final CaissePanel mainPanel;

    CaisseFrame(ComptaPropsConfiguration conf, RegisterFiles files, RegisterDB registerDB) throws Exception {
        this.conf = conf;
        this.files = files;
        this.registerDB = registerDB;
        this.mainPanel = new CaissePanel(this);
        this.setContentPane(this.mainPanel);
        this.setFocusable(true);
    }

    public final ComptaPropsConfiguration getConf() {
        return this.conf;
    }

    public final RegisterFiles getFiles() {
        return this.files;
    }

    public final RegisterDB getDB() {
        return this.registerDB;
    }

    public static void main(String[] args) {
        ComptaPropsConfiguration.checkJava();
        System.setProperty("SQLRowAccessor.accessDBIfNeeded", "true");
        try {
            System.out.println("Lancement du module de caisse");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            RemoteShell.startDefaultInstance(null, null);
            System.setProperty("redirectToFile", "true");
            System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
            ExceptionHandler.setForceUI(true);
            ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
            ExceptionHandler.setThrowableHandler(Gestion.createDefaultThrowableHandler());
            System.setProperty("sun.java2d.pmoffscreen", "false");
            System.setProperty("org.openconcerto.sql.structure.useXML", "true");
            System.setProperty("redirectToFile", "true");
            if (POSConfiguration.getInstance().isUsingJPos()) {
                ClassPathLoader c = ClassPathLoader.getInstance();
                try {
                    List<String> posDirectories = POSConfiguration.getInstance().getJPosDirectories();
                    for (String posDirectory : posDirectories) {
                        if (posDirectory == null || posDirectory.trim().isEmpty()) continue;
                        c.addJarFromDirectory(new File(posDirectory.trim()));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                c.load();
            }
            final ComptaPropsConfiguration conf = POSConfiguration.getInstance().createConnexion();
            final int userID = POSConfiguration.getInstance().getUserID();
            final RegisterFiles registerFiles = new RegisterFiles(POSConfiguration.getInstance().getRootDir(), true, POSConfiguration.getInstance().getPosID());
            final RegisterDB registerDB = new RegisterDB(conf.getDirectory(), conf.getProductInfo(), POSConfiguration.getInstance().getPosID());
            RegisterState reconciledState = registerFiles.doWithLock(new ExnTransformer<RegisterFiles, RegisterState, IOException>(){

                @Override
                public RegisterState transformChecked(RegisterFiles input) throws IOException {
                    try {
                        return CaisseFrame.reconcileFSandDB(conf.getDirectory(), input, registerDB, userID);
                    }
                    catch (Exception e) {
                        throw new IOException("Couldn't reconcile local and remote state", e);
                    }
                }
            });
            POSConfiguration.getLogger().log(Level.INFO, "FS and DB states reconciled : {0}", reconciledState);
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
            System.setProperty("org.openconcerto.sql.comboCanModify", "true");
            RegisterState state = reconciledState;
            if (reconciledState.getStatus() == RegisterState.Status.CLOSED) {
                FutureTask<Boolean> askUserCallable = new FutureTask<Boolean>(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int ans = JOptionPane.showConfirmDialog(null, "La caisse n\u2019est pas ouverte, voulez-vous l\u2019ouvrir ?", "Caisse ferm\u00e9e", 0);
                        if (ans == 0) {
                            return true;
                        }
                        return false;
                    }
                });
                SwingUtilities.invokeLater(askUserCallable);
                boolean userAgreed = askUserCallable.get();
                if (userAgreed) {
                    RegisterLog newLog = registerFiles.open(userID, registerDB);
                    state = newLog.getRegisterState();
                }
            }
            if (state.getStatus() != RegisterState.Status.OPEN) {
                POSConfiguration.getLogger().log(Level.FINE, "State not open ({0}), exiting", state);
                POSConfiguration.getInstance().closeConnexion();
                return;
            }
            POSConfiguration.getLogger().log(Level.INFO, "FS and DB states open, opening UI");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CaisseFrame f = new CaisseFrame(conf, registerFiles, registerDB);
                        f.setUndecorated(true);
                        f.setDefaultCloseOperation(3);
                        f.pack();
                        f.setLocation(0, 0);
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        if (POSConfiguration.getInstance().getScreenWidth() > 0 && POSConfiguration.getInstance().getScreenHeight() > 0) {
                            f.setSize(new Dimension(POSConfiguration.getInstance().getScreenWidth(), POSConfiguration.getInstance().getScreenHeight()));
                        } else {
                            f.setSize(screenSize);
                        }
                        System.out.println("Affichage de l'interface");
                        f.setVisible(true);
                        if (screenSize.getWidth() < 1280.0 || screenSize.getHeight() < 720.0) {
                            JOptionPane.showMessageDialog(f, "La r\u00e9solution de votre \u00e9cran est trop faible.\nLa largeur doit \u00eatre au minium de 1280 pixels.\nLa hauteur doit \u00eatre au minium de 720 pixels.");
                        }
                    }
                    catch (Throwable e) {
                        ExceptionHandler.handle("Erreur d'initialisation de la caisse (main)", e);
                    }
                }
            });
        }
        catch (Throwable e) {
            ExceptionHandler.handle("Erreur d'initialisation de la caisse", e);
        }
    }

    private static RegisterState reconcileFSandDB(SQLElementDirectory dir, RegisterFiles files, RegisterDB registerDB, int userID) throws IOException, JDOMException, ParseException, SQLException {
        RegisterState remoteState;
        RegisterState localState;
        block27: {
            EnumSet<RegisterState.Status> validStatus;
            List<File> remainingReceipts;
            RegisterLog lastLog = files.getLastLog();
            POSConfiguration.getLogger().log(Level.CONFIG, "Found last log {0}", lastLog);
            localState = lastLog == null ? new RegisterState((remainingReceipts = ReceiptCode.getReceiptsToImport(files.getPosID())).isEmpty() ? RegisterState.Status.CLOSED : RegisterState.Status.OBSOLETE, null) : lastLog.getRegisterState();
            POSConfiguration.getLogger().log(Level.CONFIG, "FS state {0}", localState);
            DBState fetchedState = registerDB.fetchRegisterState();
            remoteState = fetchedState.getRegisterState();
            POSConfiguration.getLogger().log(Level.CONFIG, "DB state {0}", fetchedState);
            if (localState.getStatus() == RegisterState.Status.OBSOLETE) {
                if (remoteState.hasDate()) {
                    throw new IllegalStateException("There remains obsolete receipts but DB can no longer import them : " + remoteState);
                }
                List<Ticket> allTickets = POSConfiguration.getInstance().allTickets();
                POSConfiguration.getLogger().log(Level.INFO, "{0} obsolete receipt(s) will be stored in the DB", allTickets.size());
                POSConfiguration.getInstance().commitAll(allTickets);
                List<File> remainingReceipts2 = ReceiptCode.getReceiptsToImport(files.getPosID());
                if (!remainingReceipts2.isEmpty()) {
                    throw new IllegalStateException("Not all obsolete receipts could be imported : " + remainingReceipts2);
                }
                localState = new RegisterState(RegisterState.Status.CLOSED, null);
                POSConfiguration.getLogger().log(Level.FINE, "All obsolete receipts have been stored in the DB");
            }
            if (!(validStatus = EnumSet.of(RegisterState.Status.OPEN, RegisterState.Status.CLOSED)).contains((Object)localState.getStatus())) {
                throw new IllegalStateException("Unexpected local status :" + localState);
            }
            if (!validStatus.contains((Object)remoteState.getStatus())) {
                throw new IllegalStateException("Unexpected remote status :" + remoteState);
            }
            if (!localState.equals(remoteState)) {
                POSConfiguration.getLogger().log(Level.INFO, "Different FS and DB state, will try to reconcile\nFS " + localState + " with\nDB " + remoteState);
                boolean localOpen = localState.getStatus() == RegisterState.Status.OPEN;
                boolean remoteOpen = remoteState.getStatus() == RegisterState.Status.OPEN;
                try {
                    if (localOpen) {
                        if (remoteOpen) {
                            throw new IllegalStateException("Both open with but with different dates");
                        }
                        throw new IllegalStateException("local is open but the DB isn't");
                    }
                    if (remoteOpen) {
                        Date lastClosureDate;
                        assert (remoteState.hasDate()) : "Remote state open without date : " + remoteState;
                        SQLRowValues lastClosure = fetchedState.getLastClosureEntry();
                        Date date = lastClosureDate = lastClosure == null ? null : lastClosure.getDate("DATE").getTime();
                        if (!localState.hasDate()) {
                            if (lastClosureDate != null) {
                                throw new IllegalStateException("DB was closed (" + lastClosureDate + ") and now open, but local log is missing");
                            }
                            try {
                                localState = files.open(userID, fetchedState).getRegisterState();
                                break block27;
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("The local opening (following the already open DB) failed", e);
                            }
                        }
                        if (remoteState.compareDateTo(lastLog.getFirstRegisterEvent().getDate()) == 0) {
                            try {
                                remoteState = registerDB.close(userID, files.getLastLog()).getRegisterState();
                                break block27;
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("The closure of the DB (following the already closed local) failed", e);
                            }
                        }
                        if (lastClosureDate != null && localState.compareDateTo(lastClosureDate) == 0) {
                            try {
                                localState = files.open(userID, fetchedState).getRegisterState();
                                break block27;
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("The local opening (following the already open DB) failed", e);
                            }
                        }
                        throw new IllegalStateException("DB was opened for a different date");
                    }
                    if (!localState.hasDate()) {
                        assert (remoteState.hasDate()) : "Both closed with no dates, but not equal";
                        throw new IllegalStateException("DB was opened and closed, but local log is missing");
                    }
                    if (remoteState.hasDate()) {
                        assert (remoteState.compareDateTo(localState) != 0) : "Both closed with equal dates, but not equal";
                        throw new IllegalStateException("DB was opened and closed for a different date");
                    }
                    throw new IllegalStateException("DB was never opened but local was closed");
                }
                catch (Exception e) {
                    throw new IllegalStateException("States couldn't be reconciled, local : " + localState + ", remote : " + remoteState, e);
                }
            }
        }
        if (!remoteState.equals(localState)) {
            throw new IllegalStateException("Unexpected state");
        }
        return remoteState;
    }

    public void showMenu() {
        System.out.println("CaisseFrame.showMenu()");
        this.invalidate();
        final CaisseMenuPanel panel = new CaisseMenuPanel(this);
        POSGlassPane glassPane2 = new POSGlassPane(panel, (this.getWidth() - panel.getPreferredSize().width) / 2, 100){

            @Override
            public void mousePressed(MouseEvent e) {
                Point containerPoint = SwingUtilities.convertPoint(this, e.getPoint(), panel);
                if (containerPoint.x < 0 || containerPoint.x > panel.getWidth() || containerPoint.y < 0 || containerPoint.y > panel.getHeight()) {
                    CaisseFrame.this.setGlassPane(new JPanel());
                    CaisseFrame.this.getGlassPane().setVisible(false);
                }
                super.mousePressed(e);
            }
        };
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
        this.getControler().setLCD("OpenConcerto", "Menu", 0);
    }

    public void showPriceEditor(Article article, CaisseControler caisseControler) {
        this.getControler().disableBarcodeReader();
        System.out.println("CaisseFrame.showPriceEditor()");
        this.invalidate();
        final PriceEditorPanel panel = new PriceEditorPanel(this, article);
        POSGlassPane glassPane2 = new POSGlassPane(panel, (this.getWidth() - panel.getPreferredSize().width) / 2, 100){

            @Override
            public void mousePressed(MouseEvent e) {
                Point containerPoint = SwingUtilities.convertPoint(this, e.getPoint(), panel);
                if (containerPoint.x < 0 || containerPoint.x > panel.getWidth() || containerPoint.y < 0 || containerPoint.y > panel.getHeight()) {
                    CaisseFrame.this.setGlassPane(new JPanel());
                    CaisseFrame.this.getGlassPane().setVisible(false);
                    CaisseFrame.this.getControler().enableBarcodeReader();
                }
                super.mousePressed(e);
            }
        };
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
    }

    public void showCaisse() {
        this.getControler().enableBarcodeReader();
        this.setGlassPane(new JPanel());
        this.getGlassPane().setVisible(false);
        System.out.println("CaisseFrame.showCaisse()");
        this.setContentPane(this.mainPanel);
        this.getControler().setLCD("OpenConcerto", "Caisse", 0);
        this.getControler().setLCDDefaultDisplay(5);
    }

    public void showTickets(Ticket t) {
        System.out.println("CaisseFrame.showMenu()");
        ListeDesTicketsPanel panel = new ListeDesTicketsPanel(this);
        panel.setSelectedTicket(t);
        this.setContentPane(panel);
    }

    public CaisseControler getControler() {
        return this.mainPanel.getControler();
    }

    public void showClients() {
        System.out.println("CaisseFrame.showClients()");
        ListeDesClientsPanel panel = new ListeDesClientsPanel(this);
        this.setContentPane(panel);
    }

    public void setClient(Client client) {
        System.err.println("CaisseFrame.setClient() " + client.getFullName());
        this.getControler().setClient(client);
    }

    @Override
    public void setContentPane(Container contentPane) {
        this.invalidate();
        this.setGlassPane(new JPanel());
        this.getGlassPane().setVisible(false);
        super.setContentPane(contentPane);
        this.validate();
        this.repaint();
    }
}

