/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import org.jdom2.JDOMException;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.io.ConcertProtocol;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialDisplay;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterLogEntry;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.POSDisplay;
import org.openconcerto.erp.core.sales.pos.ui.PrinterPOSDisplay;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.utils.Pair;

public class CaisseControler
implements BarcodeListener {
    private Article articleSelected;
    private Paiement paiementSelected;
    private Ticket t;
    private Client client = Client.NONE;
    private List<CaisseListener> listeners = new ArrayList<CaisseListener>();
    private final BarcodeReader r;
    private Paiement p1 = new Paiement(1);
    private Paiement p2 = new Paiement(3);
    private Paiement p3 = new Paiement(2);
    private final CaisseFrame caisseFrame;
    private final POSDisplay lcd;

    public CaisseControler(CaisseFrame caisseFrame) throws ParseException, JDOMException, IOException {
        int dayIndex;
        this.caisseFrame = caisseFrame;
        RegisterLog lastLog = caisseFrame.getFiles().getLastLog();
        if (lastLog == null || lastLog.getRegisterState().getStatus() != RegisterState.Status.OPEN) {
            throw new IllegalStateException("Not open");
        }
        String lastHash = lastLog.getLastReceiptHash();
        RegisterLogEntry.ReceiptEntry lastReceiptEvent = lastLog.getLastReceiptCreationEvent();
        if (lastReceiptEvent == null) {
            dayIndex = 1;
        } else {
            ReceiptCode lastCode = lastReceiptEvent.getCode();
            dayIndex = lastCode.getDayIndex() + 1;
        }
        this.t = new Ticket(POSConfiguration.getInstance().getPosID(), dayIndex, lastHash);
        this.t.addPaiement(this.p1);
        this.t.addPaiement(this.p2);
        this.t.addPaiement(this.p3);
        int scanDelay = POSConfiguration.getInstance().getScanDelay();
        this.r = new BarcodeReader(scanDelay);
        this.r.start();
        this.r.addBarcodeListener(this);
        this.lcd = POSConfiguration.getInstance().getLCDType().equals("serial") ? new ESCSerialDisplay(POSConfiguration.getInstance().getLCDPort()) : new PrinterPOSDisplay(POSConfiguration.getInstance().getLCDPort());
        this.setLCDDefaultDisplay(0);
    }

    public Article getArticleSelected() {
        return this.articleSelected;
    }

    public Paiement getPaiementSelected() {
        return this.paiementSelected;
    }

    void setArticleSelected(Article a) {
        if (a != this.articleSelected) {
            this.articleSelected = a;
            this.paiementSelected = null;
            this.fire();
        }
    }

    void setPaiementSelected(Paiement p) {
        this.paiementSelected = p;
        this.articleSelected = null;
        this.fire();
    }

    private void fire() {
        int stop = this.listeners.size();
        int i = 0;
        while (i < stop) {
            this.listeners.get(i).caisseStateChanged();
            ++i;
        }
    }

    void addCaisseListener(CaisseListener l) {
        this.listeners.add(l);
    }

    public void setClient(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("Customer cannot be null");
        }
        this.client = client;
        this.t.setClient(client);
        this.fire();
    }

    public boolean isClientDefined() {
        return this.client != Client.NONE;
    }

    public Client getClient() {
        return this.client;
    }

    void addArticle(Article a) {
        this.t.addArticle(a);
        this.fire();
        String price = TicketCellRenderer.centsToString(a.getPriceWithTax().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        this.setLCD(a.getName(), price, 0);
        this.setLCDDefaultDisplay(2);
    }

    void incrementArticle(Article a) {
        this.t.incrementArticle(a);
        this.fire();
        String price = TicketCellRenderer.centsToString(a.getPriceWithTax().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        this.setLCD(a.getName(), price, 0);
        this.setLCDDefaultDisplay(2);
    }

    void removeArticle(Article a) {
        this.t.removeArticle(a);
        this.fire();
    }

    public List<Paiement> getPaiements() {
        return this.t.getPaiements();
    }

    public void addPaiement(Paiement p) {
        this.t.addPaiement(p);
        this.fire();
    }

    public void clearPaiement(Paiement paiement) {
        if (this.p1.equals(paiement) || this.p2.equals(paiement) || this.p3.equals(paiement)) {
            paiement.setMontantInCents(0);
        }
        this.fire();
    }

    public void setPaiementValue(Paiement p, int v) {
        int soldeInCents;
        if (p.getType() == 4 && v > (soldeInCents = this.getClient().getSolde().movePointRight(2).intValue())) {
            v = soldeInCents;
        }
        p.setMontantInCents(v);
        this.fire();
        this.setLCD("Paiement " + p.getTypeAsString().replace('\u00e8', 'e').replace('\u00e9', 'e'), TicketCellRenderer.centsToString(p.getMontantInCents()), 0);
        this.setLCDDefaultDisplay(3);
    }

    public int getTotal() {
        return this.t.getTotalInCents();
    }

    public int getPaidTotal() {
        return this.t.getPaidTotal();
    }

    public List<Pair<Article, Integer>> getItems() {
        return this.t.getArticles();
    }

    public int getItemCount(Article article) {
        return this.t.getItemCount(article);
    }

    public void clearArticle(Article article) {
        this.t.clearArticle(article);
        this.setArticleSelected(null);
    }

    public void setArticleCount(Article article, int count) {
        this.t.setArticleCount(article, count);
        this.setArticleSelected(null);
    }

    @Override
    public void barcodeRead(String code) {
        System.err.println("CaisseControler.barcodeRead() barcode : " + code);
        if (code.equalsIgnoreCase("especes")) {
            this.autoFillPaiement(this.p1);
        } else if (code.equalsIgnoreCase("cb")) {
            this.autoFillPaiement(this.p2);
        } else if (code.equalsIgnoreCase("cheque")) {
            this.autoFillPaiement(this.p3);
        } else if (code.equalsIgnoreCase("annuler")) {
            if (this.articleSelected != null) {
                this.clearArticle(this.articleSelected);
            } else if (this.paiementSelected != null) {
                this.paiementSelected.setMontantInCents(0);
                this.fire();
            }
        } else if (!(code.equalsIgnoreCase("valider") || code.equalsIgnoreCase("facture") || code.equalsIgnoreCase("ticket"))) {
            Article a = Article.getArticleFromBarcode(code);
            if (a != null) {
                System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : product found : " + a.getName());
                this.incrementArticle(a);
                this.setArticleSelected(a);
            } else {
                System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : no product found");
                Ticket t = Ticket.getTicketFromCode(code, this.caisseFrame.getFiles());
                if (t != null) {
                    System.err.println("CaisseControler.barcodeRead() barcode : " + code + " : receipt found :" + t.getNumber());
                    this.caisseFrame.showTickets(t);
                }
            }
        }
    }

    void autoFillPaiement(Paiement p) {
        int soldeInCents;
        int nouveauMontant = this.getTotal() - this.getPaidTotal() + p.getMontantInCents();
        if (p.getType() == 4 && nouveauMontant > (soldeInCents = this.getClient().getSolde().movePointRight(2).intValue())) {
            nouveauMontant = soldeInCents;
        }
        p.setMontantInCents(nouveauMontant);
        this.setPaiementSelected(p);
        this.setLCD("Paiement " + p.getTypeAsString(), TicketCellRenderer.centsToString(p.getMontantInCents()), 0);
        this.setLCDDefaultDisplay(3);
    }

    void addBarcodeListener(BarcodeListener l) {
        this.r.addBarcodeListener(l);
    }

    public boolean canAddPaiement(int type) {
        int paiementCount = this.t.getPaiements().size();
        if (paiementCount >= 6) {
            return false;
        }
        int i = 0;
        while (i < paiementCount) {
            Paiement p = this.t.getPaiements().get(i);
            if (p.getType() == type && p.getMontantInCents() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void keyReceived(KeyEvent ee) {
    }

    public static String getCents(int cents) {
        String s = String.valueOf(cents % 100);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static String getEuros(int cents) {
        String s = String.valueOf(cents / 100);
        return s;
    }

    public void setTicketDate() {
        this.t.setCreationCal(Calendar.getInstance());
    }

    public void saveAndClearTicket(RegisterFiles files, SQLElementDirectory dir) throws IOException, SQLException {
        if (this.t.getTotalInCents() > 0 && this.getPaidTotal() >= this.getTotal()) {
            String fileHash = this.t.save(files, dir);
            int newIndex = this.t.getNumber() + 1;
            this.t = new Ticket(POSConfiguration.getInstance().getPosID(), newIndex, fileHash);
            this.p1 = new Paiement(1);
            this.p2 = new Paiement(3);
            this.p3 = new Paiement(2);
            this.t.addPaiement(this.p1);
            this.t.addPaiement(this.p2);
            this.t.addPaiement(this.p3);
            this.setPaiementSelected(null);
            this.setArticleSelected(null);
            this.client = Client.NONE;
        }
    }

    public int getTicketNumber() {
        return this.t.getNumber();
    }

    public void printTicket() {
        if (this.t.getTotalInCents() > 0) {
            if (this.getPaidTotal() >= this.getTotal()) {
                POSConfiguration.getInstance().print(this.t);
            } else {
                System.err.println("Ticket not printed because not paid");
            }
        } else {
            System.err.println("Ticket not printed total <= 0");
        }
    }

    public void openDrawer() {
        try {
            TicketPrinter prt = POSConfiguration.getInstance().getTicketPrinterConfiguration1().createTicketPrinter();
            prt.openDrawer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchListMode() {
        this.caisseFrame.mainPanel.switchListMode();
    }

    public void setLCD(final String line1, final String line2, int delay) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    CaisseControler.this.lcd.setMessage(line1, line2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Timer timer = new Timer("LCD : " + line1, true);
        timer.schedule(task, delay * 1000);
    }

    public void setLCDDefaultDisplay(int delay) {
        if (this.t.getTotalInCents() > 0) {
            int count = 0;
            List<Pair<Article, Integer>> articles = this.t.getArticles();
            for (Pair<Article, Integer> pair : articles) {
                count += pair.getSecond().intValue();
            }
            String line1 = count == 1 ? "1 article" : String.valueOf(count) + " articles";
            int cents = this.t.getTotalInCents();
            this.setLCD(line1, "Total : " + TicketCellRenderer.centsToString(cents), delay);
        } else {
            this.setLCD(POSConfiguration.getInstance().getLCDLine1(), POSConfiguration.getInstance().getLCDLine2(), delay);
        }
    }

    public void sendCBRequest(final Paiement p) {
        final String creditCardPort = POSConfiguration.getInstance().getCreditCardPort();
        if (creditCardPort != null && creditCardPort.trim().length() > 2) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcertProtocol cp = new ConcertProtocol(creditCardPort);
                        boolean ok = cp.sendCardPayment(p.getMontantInCents(), "978");
                        if (ok) {
                            JOptionPane.showMessageDialog(null, "Paiement CB OK");
                        } else {
                            JOptionPane.showMessageDialog(null, "Erreur paiement CB");
                        }
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(null, "Erreur terminal CB");
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    public void setArticleHT(Article article, BigDecimal ht) {
        Article existingArticle = null;
        List<Pair<Article, Integer>> articles = this.t.getArticles();
        for (Pair<Article, Integer> pair : articles) {
            Article a = pair.getFirst();
            if (a.getId() != article.getId() || article.getPriceWithoutTax().doubleValue() != a.getPriceWithoutTax().doubleValue()) continue;
            existingArticle = a;
            break;
        }
        if (existingArticle != null) {
            existingArticle.updatePriceWithoutTax(ht);
            this.fire();
        }
    }

    public void openPriceEditor(Article article) {
        this.caisseFrame.showPriceEditor(article, this);
    }

    public void enableBarcodeReader() {
        this.r.setEnabled(true);
    }

    public void disableBarcodeReader() {
        this.r.setEnabled(false);
    }

    public boolean isTicketValid() {
        return this.t.getTotalInCents() > 0 && this.getPaidTotal() >= this.getTotal();
    }
}

