/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.text.ParseException;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterDB;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.utils.CollectionUtils;

public final class DBState {
    private final RegisterDB registerDB;
    private final SQLRowValues registerVals;
    private final SQLRowValues lastReceiptVals;
    private final RegisterState registerState;

    protected DBState(RegisterDB registerDB, SQLRowValues registerR) {
        this.registerDB = registerDB;
        this.registerVals = registerR.toImmutable();
        if (this.getPosID() != registerDB.getPosID()) {
            throw new IllegalArgumentException("Not same register");
        }
        this.lastReceiptVals = (SQLRowValues)CollectionUtils.getSole(this.registerVals.getReferentRows(this.registerDB.getReceiptElement().getTable().getField("ID_CAISSE")));
        SQLRowValues lastEntry = this.getLastEntry();
        if (lastEntry == null) {
            this.registerState = new RegisterState(RegisterState.Status.CLOSED, null);
        } else {
            if (lastEntry.getForeignID("ID_CAISSE") != this.getPosID()) {
                throw new IllegalStateException("Incoherent register IDs");
            }
            RegisterState.Status status = RegisterState.Status.valueOf(lastEntry.getString("EVT"));
            if (status != RegisterState.Status.OPEN && status != RegisterState.Status.CLOSED) {
                throw new IllegalStateException("Invalid status : " + (Object)((Object)status));
            }
            this.registerState = new RegisterState(status, lastEntry.getDate("DATE").getTime());
        }
    }

    public final int getPosID() {
        return this.registerVals.getID();
    }

    public final RegisterState getRegisterState() {
        return this.registerState;
    }

    public SQLRowValues getRegisterRow() {
        return this.registerVals;
    }

    public final SQLRowValues getLastClosureEntry() {
        return this.registerVals.followPath(this.registerDB.getRegisterToLastClosureEntry());
    }

    public final SQLRowValues getLastEntry() {
        return (SQLRowValues)this.registerVals.getNonEmptyForeign("ID_DERNIERE_ENTREE_JOURNAL");
    }

    public final SQLRowValues getLastReceiptRow() {
        return this.lastReceiptVals;
    }

    public final ReceiptCode getLastReceiptCode() throws ParseException {
        SQLRowValues lastReceiptRow = this.getLastReceiptRow();
        return lastReceiptRow == null ? null : new ReceiptCode(lastReceiptRow.getString("NUMERO"));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for register " + this.getPosID() + " in state " + this.getRegisterState();
    }
}

