/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jdom2.JDOMException;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.RegisterDB;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterLogEntry;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Value;

public class CheckIntegrity {
    public static void main(String[] args) {
        POSConfiguration posConf = POSConfiguration.getInstance();
        ComptaPropsConfiguration conf = posConf.createConnexion();
        try {
            try {
                for (RegisterFiles files : RegisterFiles.scan(posConf.getRootDir())) {
                    CheckIntegrity.checkRegisterFiles(conf, files);
                }
                System.out.println("\n\nAll done");
            }
            catch (Exception e) {
                e.printStackTrace();
                posConf.closeConnexion();
            }
        }
        finally {
            posConf.closeConnexion();
        }
    }

    private static void checkRegisterFiles(ComptaPropsConfiguration conf, RegisterFiles files) throws IOException, JDOMException, ParseException {
        RegisterDB registerDB = new RegisterDB(conf.getDirectory(), conf.getProductInfo(), files.getPosID());
        Value<RegisterLogEntry> lastEntry = Value.getNone();
        for (Path logFile : files.findLogFiles()) {
            System.out.println("Checking " + logFile);
            RegisterLog log = new RegisterLog(logFile).parse();
            try {
                CheckIntegrity.checkOneLog(files, lastEntry, log, registerDB);
                System.out.println("OK for " + logFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            lastEntry = Value.getSome(log.getLastEvent());
        }
    }

    private static void checkOneLog(RegisterFiles files, Value<RegisterLogEntry> previousEntry, RegisterLog log, RegisterDB registerDB) throws IOException, JDOMException, ParseException {
        int expectedRowsCount;
        Where dateWhere;
        Date cal;
        if (log.getFirstRegisterEvent().getRegisterID() != files.getPosID()) {
            throw new IllegalStateException("Opening register ID mismatch");
        }
        SQLTable logT = registerDB.getLogElement().getTable();
        if (previousEntry.hasValue()) {
            if (previousEntry.getValue().getType() != RegisterLog.EventType.REGISTER_CLOSURE) {
                throw new IllegalStateException("Previous log isn't closed");
            }
            RegisterLogEntry.RegisterEntry previousLogClosure = (RegisterLogEntry.RegisterEntry)previousEntry.getValue();
            if (!Objects.equals(previousLogClosure.getLastReceiptHash(), log.getFirstRegisterEvent().getLastReceiptHash())) {
                throw new IllegalStateException("Register opening hash mismatch, chain broken");
            }
            if (log.getFirstRegisterEvent().getDate().compareTo(previousLogClosure.getDate()) < 0) {
                throw new IllegalStateException("Register opening before previous closure");
            }
            cal = previousLogClosure.getDate();
        } else {
            cal = null;
        }
        List<RegisterLogEntry.ReceiptEntry> receiptEvents = log.getReceiptEvents();
        List<RegisterLogEntry> allEvents = log.getAllEvents();
        for (RegisterLogEntry e : allEvents) {
            Date newDate = e.getDate();
            if (cal != null && newDate.compareTo(cal) < 0) {
                throw new IllegalStateException("Later event before last one");
            }
            cal = newDate;
        }
        CheckIntegrity.checkLogTable(logT, log.getFirstRegisterEvent());
        List<Ticket> receipts = log.parseReceipts();
        if (log.getRegisterState().getStatus() == RegisterState.Status.CLOSED) {
            String lastReceiptHash = receipts.isEmpty() ? null : log.getLastReceiptCreationEvent().getFileHash();
            RegisterLogEntry.RegisterEntry lastRegisterEvent = log.getLastRegisterEvent();
            if (!CompareUtils.equals(lastRegisterEvent.getLastReceiptHash(), lastReceiptHash)) {
                throw new IllegalStateException("Closure hash mismatch, recorded " + lastRegisterEvent.getLastReceiptHash() + " but was " + lastReceiptHash);
            }
            if (lastRegisterEvent.getRegisterID() != files.getPosID()) {
                throw new IllegalStateException("Closure register ID mismatch");
            }
            Number closureEntryID = CheckIntegrity.checkLogTable(logT, lastRegisterEvent);
            SQLRow closureRow = CheckIntegrity.getClosureRow(registerDB.getClosureElement().getTable(), lastRegisterEvent, closureEntryID);
            SQLRowValues expected = RegisterDB.fillRow(new SQLRowValues(closureRow.getTable()), receiptEvents, receipts);
            for (String expectedField : expected.getFields()) {
                Object expectedVal = expected.getObject(expectedField);
                Object dbVal = closureRow.getObject(expectedField);
                boolean equals = expectedVal instanceof Comparable ? CompareUtils.compare(expectedVal, dbVal) == 0 : Objects.equals(expectedVal, dbVal);
                if (equals) continue;
                throw new IllegalStateException("Closure row data doesn't match log for " + expectedField + " : " + expectedVal + " " + dbVal);
            }
        }
        SQLTable registerT = registerDB.getReceiptElement().getTable();
        SQLSelect selReceipts = new SQLSelect();
        selReceipts.addSelectStar(registerT);
        selReceipts.setWhere(new Where((FieldRef)registerT.getField("ID_CAISSE"), "=", files.getPosID()));
        Date lowerBound = log.getFirstRegisterEvent().getDate();
        if (log.getRegisterState().getStatus() == RegisterState.Status.CLOSED) {
            Date upperBound = log.getLastEvent().getDate();
            dateWhere = new Where((FieldRef)registerT.getField("DATE"), lowerBound, (Object)upperBound);
            expectedRowsCount = receipts.size();
        } else {
            dateWhere = new Where((FieldRef)registerT.getField("DATE"), ">=", (Object)lowerBound);
            expectedRowsCount = 0;
        }
        selReceipts.andWhere(dateWhere);
        selReceipts.addFieldOrder(registerT.getField("DATE"));
        List<SQLRow> receiptRows = SQLRowListRSH.execute(selReceipts);
        if (receiptRows.size() != expectedRowsCount) {
            throw new IllegalStateException("Receipts count in the DB (" + receiptRows.size() + ") doesn't match log (" + expectedRowsCount + ")");
        }
        if (expectedRowsCount > 0) {
            Iterator<SQLRow> iter = receiptRows.iterator();
            Iterator<RegisterLogEntry.ReceiptEntry> receiptEventsIter = receiptEvents.iterator();
            for (Ticket receipt : receipts) {
                SQLRow row = iter.next();
                RegisterLogEntry.ReceiptEntry receiptEvent = receiptEventsIter.next();
                if (!row.getString("NUMERO").equals(receipt.getCode())) {
                    throw new IllegalStateException("Code in the DB doesn't match log");
                }
                if (row.getDate("DATE").compareTo(receipt.getCreationCal()) != 0) {
                    throw new IllegalStateException("Date in the DB doesn't match log");
                }
                if (!row.getString("FILE_HASH").equals(receiptEvent.getFileHash())) {
                    throw new IllegalStateException("File hash in the DB doesn't match log : " + row.getString("FILE_HASH") + " != " + receiptEvent.getFileHash());
                }
                if (!Objects.equals(row.getString("FILE_HASH_PREVIOUS"), receipt.getPreviousHash())) {
                    throw new IllegalStateException("Previous file hash in the DB doesn't match log");
                }
                if (row.getLong("TOTAL_TTC") == (long)receipt.getPaidTotal()) continue;
                throw new IllegalStateException("TTC in the DB doesn't match log");
            }
            assert (!iter.hasNext() && !receiptEventsIter.hasNext());
        }
    }

    private static final Number checkLogTable(SQLTable logT, RegisterLogEntry.RegisterEntry entry) {
        SQLSelect sel = new SQLSelect();
        sel.addSelect(logT.getKey());
        sel.setWhere(new Where((FieldRef)logT.getField("ID_CAISSE"), "=", entry.getRegisterID()));
        sel.andWhere(new Where((FieldRef)logT.getField("EVT"), "=", (Object)(entry.getType() == RegisterLog.EventType.REGISTER_OPENING ? RegisterState.Status.OPEN : RegisterState.Status.CLOSED).name()));
        sel.andWhere(new Where((FieldRef)logT.getField("DATE"), "=", (Object)entry.getDate()));
        List ids = logT.getDBSystemRoot().getDataSource().executeCol(sel.asString());
        if (ids.size() != 1) {
            throw new IllegalStateException("Not found in the DB : " + entry);
        }
        return (Number)ids.get(0);
    }

    private static final SQLRow getClosureRow(SQLTable closureT, RegisterLogEntry.RegisterEntry entry, Number closureEntryID) {
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(closureT);
        sel.setWhere(new Where((FieldRef)closureT.getField("ID_ENTREE_JOURNAL"), "=", (Object)closureEntryID));
        List<SQLRow> rows = SQLRowListRSH.execute(sel);
        if (rows.size() != 1) {
            throw new IllegalStateException("Closure row not found for " + entry);
        }
        return rows.get(0);
    }
}

