/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.model.Article;

public class Categorie {
    private static List<Categorie> topLevelCategories = new ArrayList<Categorie>();
    private static List<Categorie> allCategories = new ArrayList<Categorie>();
    private String name;
    private List<Categorie> l = new ArrayList<Categorie>();
    private List<Article> articles = new ArrayList<Article>();
    private Categorie parent;

    public Categorie(String string) {
        this(string, false);
    }

    public Categorie(String string, boolean top) {
        this.name = string;
        if (top) {
            topLevelCategories.add(this);
        }
        allCategories.add(this);
    }

    public String toString() {
        return this.name;
    }

    public void add(Categorie s) {
        this.l.add(s);
        s.setParentCategorie(this);
    }

    private void setParentCategorie(Categorie categorie) {
        this.parent = categorie;
    }

    public Categorie getParent() {
        return this.parent;
    }

    void addArticle(Article a) {
        if (!this.articles.contains(a)) {
            this.articles.add(a);
        }
    }

    public static List<Categorie> getTopLevelCategories() {
        return topLevelCategories;
    }

    public static List<Categorie> getAllCategories() {
        return allCategories;
    }

    public List<Categorie> getSubCategories() {
        return this.l;
    }

    public String getName() {
        return this.name;
    }

    public List<Article> getArticles() {
        ArrayList<Article> result = new ArrayList<Article>();
        result.addAll(this.articles);
        for (Categorie c : this.l) {
            result.addAll(c.getArticles());
        }
        Collections.sort(result, new Comparator<Article>(){

            @Override
            public int compare(Article o1, Article o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }
}

