/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.ui;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.utils.i18n.TranslationManager;

public enum TypeFactureCommandeClient {
    GLOBALE(1, "sales.order.invoice.global"),
    SITUATION(2, "sales.order.invoice.partial"),
    SOLDE(3, "sales.order.invoice.rest");

    private final int id;
    private final String translationID;
    private static final Map<Integer, TypeFactureCommandeClient> idToEnum;

    static {
        idToEnum = new HashMap<Integer, TypeFactureCommandeClient>();
        TypeFactureCommandeClient[] typeFactureCommandeClientArray = TypeFactureCommandeClient.values();
        int n = typeFactureCommandeClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeFactureCommandeClient e = typeFactureCommandeClientArray[n2];
            idToEnum.put(e.getId(), e);
            ++n2;
        }
    }

    private TypeFactureCommandeClient(int id, String translationID) {
        this.id = id;
        this.translationID = translationID;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslationID() {
        return this.translationID;
    }

    public String getTranslation() {
        String translationForItem = TranslationManager.getInstance().getTranslationForItem(this.translationID);
        return translationForItem == null || translationForItem.trim().length() == 0 ? this.translationID : translationForItem;
    }

    public static TypeFactureCommandeClient fromID(int id) {
        return idToEnum.get(id);
    }

    public String toString() {
        return this.getTranslation();
    }
}

