/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Semaphore;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.EditPanel;

public class VisualisationPayeFrame
extends JFrame {
    private boolean ok = false;
    private EditPanel panel;
    private static final String frameTitle = "Visualisation d'une fiche de paye";

    public VisualisationPayeFrame(final Semaphore semaphore) {
        super(frameTitle);
        final SQLElement eltFichePaye = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualisationPayeFrame.this.panel = new EditPanel(eltFichePaye, EditPanel.READONLY);
                VisualisationPayeFrame.this.panel.disableCancel();
                VisualisationPayeFrame.this.setLayout(new GridBagLayout());
                Container content = VisualisationPayeFrame.this.getContentPane();
                GridBagConstraints c = new GridBagConstraints();
                c.gridheight = 1;
                c.gridwidth = 0;
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.insets = new Insets(2, 2, 1, 2);
                c.anchor = 17;
                c.fill = 1;
                content.add((Component)VisualisationPayeFrame.this.panel, c);
                JButton buttonAnnuler = new JButton("Annuler");
                buttonAnnuler.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VisualisationPayeFrame.this.ok = false;
                        semaphore.release();
                        VisualisationPayeFrame.this.setVisible(false);
                    }
                });
                JButton buttonContinue = new JButton("Continuer");
                buttonContinue.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VisualisationPayeFrame.this.ok = true;
                        VisualisationPayeFrame.this.panel.modifier();
                        semaphore.release();
                        VisualisationPayeFrame.this.setVisible(false);
                    }
                });
                ++c.gridy;
                c.gridx = -1;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.anchor = 13;
                c.fill = 0;
                content.add((Component)buttonContinue, c);
                c.weightx = 0.0;
                content.add((Component)buttonAnnuler, c);
            }
        });
    }

    public boolean getAnswer() {
        return this.ok;
    }

    public void setSelectedFichePaye(int id) {
        this.panel.selectionId(id, 1);
        SQLElement eltFichePaye = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
        SQLElement eltSalarie = Configuration.getInstance().getDirectory().getElement("SALARIE");
        SQLRow rowFiche = eltFichePaye.getTable().getRow(id);
        SQLRow rowSal = eltSalarie.getTable().getRow(rowFiche.getInt("ID_SALARIE"));
        this.setTitle("Visualisation d'une fiche de paye [" + rowSal.getString("CODE") + " " + rowSal.getString("NOM") + " " + rowSal.getString("PRENOM"));
    }
}

