/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.humanresources.payroll.ui.CaisseCotisationRenseignementTable;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.ListMap;

public class CaisseCotisationSQLElement
extends ConfSQLElement {
    private static final SQLTable tableCaisse = Configuration.getInstance().getBase().getTable("CAISSE_COTISATION");
    private static List<SQLRow> liste;

    public CaisseCotisationSQLElement() {
        super("CAISSE_COTISATION", "une caisse", "caisses");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("ID_ADRESSE_COMMON");
        l.add("NUMERO_COMPTE_PCE");
        l.add("NUMERO_COMPTE_PCE_CHARGES");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    public static List<SQLRow> getCaisseCotisation() {
        if (liste == null) {
            SQLSelect selCaisse = new SQLSelect(Configuration.getInstance().getBase());
            selCaisse.addSelect(tableCaisse.getField("ID"));
            selCaisse.addSelect(tableCaisse.getField("NOM"));
            String req = selCaisse.asString();
            liste = (List)Configuration.getInstance().getBase().getDataSource().execute(req, SQLRowListRSH.createFromSelect(selCaisse));
        }
        return liste;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            CaisseCotisationRenseignementTable table;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JPanel panelInfos = new JPanel();
                panelInfos.setBorder(BorderFactory.createTitledBorder("Renseignements"));
                panelInfos.setLayout(new GridBagLayout());
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                JTextField textNom = new JTextField();
                panelInfos.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textNom, c);
                c.weightx = 0.0;
                JCheckBox boxOrgProt = new JCheckBox(this.getLabelFor("ORG_PROTECTION_SOCIALE"));
                c.gridwidth = 0;
                c.weightx = 1.0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)boxOrgProt, c);
                this.addSQLObject(boxOrgProt, "ORG_PROTECTION_SOCIALE");
                c.gridwidth = 1;
                JCheckBox boxUrssaf = new JCheckBox(this.getLabelFor("URSSAF"));
                c.gridwidth = 0;
                c.weightx = 1.0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)boxUrssaf, c);
                this.addSQLObject(boxUrssaf, "URSSAF");
                c.gridwidth = 1;
                TitledSeparator sep = new TitledSeparator("Adresse");
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)sep, c);
                this.addView("ID_ADRESSE_COMMON", "required;notdecorated;noseparator");
                ElementSQLObject eltAdr = (ElementSQLObject)this.getView("ID_ADRESSE_COMMON");
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)eltAdr, c);
                TitledSeparator sepContact = new TitledSeparator("Contact");
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)sepContact, c);
                JLabel labelTel = new JLabel(this.getLabelFor("TEL"));
                JTextField textTel = new JTextField();
                ++c.gridy;
                c.gridwidth = 1;
                c.gridx = 0;
                panelInfos.add((Component)labelTel, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textTel, c);
                c.weightx = 0.0;
                JLabel labelTelP = new JLabel(this.getLabelFor("TEL_PORTABLE"));
                JTextField textTelP = new JTextField();
                ++c.gridx;
                panelInfos.add((Component)labelTelP, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textTelP, c);
                c.weightx = 0.0;
                JLabel labelMail = new JLabel(this.getLabelFor("MAIL"));
                JTextField textMail = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)labelMail, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textMail, c);
                this.addSQLObject(textMail, "MAIL");
                c.weightx = 0.0;
                c.gridx = 0;
                c.gridy = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)panelInfos, c);
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.fill = 2;
                JPanel panelCompta = new JPanel();
                panelCompta.setBorder(BorderFactory.createTitledBorder("Comptabilit\u00e9"));
                panelCompta.setLayout(new GridBagLayout());
                JLabel labelTiers = new JLabel(this.getLabelFor("NUMERO_COMPTE_PCE"));
                JTextField fieldCompte = new JTextField();
                this.addView(fieldCompte, "NUMERO_COMPTE_PCE");
                panelCompta.add((Component)labelTiers, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelCompta.add((Component)fieldCompte, c);
                c.weightx = 0.0;
                JLabel labelCharge = new JLabel(this.getLabelFor("NUMERO_COMPTE_PCE_CHARGES"));
                ++c.gridy;
                c.gridx = 0;
                panelCompta.add((Component)labelCharge, c);
                ++c.gridx;
                c.weightx = 1.0;
                JTextField fieldCompteCharge = new JTextField();
                panelCompta.add((Component)fieldCompteCharge, c);
                this.addView(fieldCompteCharge, "NUMERO_COMPTE_PCE_CHARGES");
                c.weightx = 0.0;
                c.gridx = 0;
                c.gridy = 1;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)panelCompta, c);
                c.weightx = 0.0;
                c.weighty = 0.0;
                this.addSQLObject(textNom, "NOM");
                this.addSQLObject(textTel, "TEL");
                this.addSQLObject(textTelP, "TEL_PORTABLE");
                TitledSeparator sepRenseignement = new TitledSeparator("Renseignement Organisme de protection social (S21.G00.20)");
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 1.0;
                this.add((Component)sepRenseignement, c);
                this.table = new CaisseCotisationRenseignementTable();
                this.table.setEnabled(true);
                ++c.gridy;
                c.weighty = 1.0;
                this.add((Component)this.table, c);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.table.getModel().insertFrom(r);
                } else {
                    this.table.getModel().clearRows();
                }
            }

            @Override
            public void update() {
                super.update();
                this.table.getModel().updateField("ID_CAISSE_COTISATION", this.getSelectedID());
            }

            @Override
            public int insert(SQLRow order) {
                int insertID = super.insert(order);
                this.table.getModel().updateField("ID_CAISSE_COTISATION", insertID);
                return insertID;
            }
        };
    }
}

