/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.MoisSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.FichePayeSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtFichePaye;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.utils.ExceptionHandler;

public class ClotureMensuellePayePanel
extends JPanel {
    private final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();

    public ClotureMensuellePayePanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(2, 2, 1, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        JLabel labelMois = new JLabel("Cloture du mois de ");
        this.add((Component)labelMois, c);
        final ElementComboBox selMois = new ElementComboBox(true, 25);
        selMois.init(((ComptaPropsConfiguration)Configuration.getInstance()).getDirectory().getElement(MoisSQLElement.class));
        selMois.setButtonsVisible(false);
        ++c.gridx;
        this.add((Component)selMois, c);
        JLabel labelAnnee = new JLabel("Ann\u00e9e");
        ++c.gridx;
        this.add((Component)labelAnnee, c);
        final JTextField textAnnee = new JTextField(5);
        ++c.gridx;
        this.add((Component)textAnnee, c);
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        textAnnee.setText(format.format(new Date()));
        ++c.gridy;
        c.gridx = 0;
        final JCheckBox boxValid = new JCheckBox("Valider toutes les payes du mois");
        final JCheckBox boxCompta = new JCheckBox("G\u00e9n\u00e9rer les \u00e9critures comptables associ\u00e9es");
        c.gridwidth = 0;
        this.add((Component)boxValid, c);
        boxValid.setSelected(true);
        ++c.gridy;
        this.add((Component)boxCompta, c);
        JButton buttonClot = new JButton("Cl\u00f4turer");
        JButton buttonFermer = new JButton("Fermer");
        JPanel panelButton = new JPanel();
        panelButton.add(buttonClot);
        panelButton.add(buttonFermer);
        c.anchor = 14;
        c.fill = 0;
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)panelButton, c);
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ClotureMensuellePayePanel.this)).dispose();
            }
        });
        buttonClot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SQLTable tableFiche;
                    SQLSelect selFiche;
                    if (boxValid.isSelected()) {
                        selFiche = new SQLSelect();
                        tableFiche = ClotureMensuellePayePanel.this.base.getTable("FICHE_PAYE");
                        SQLTable tableSalarie = ClotureMensuellePayePanel.this.base.getTable("SALARIE");
                        SQLTable tableInfosSal = ClotureMensuellePayePanel.this.base.getTable("INFOS_SALARIE_PAYE");
                        selFiche.addSelect(tableFiche.getField("ID"));
                        selFiche.setWhere(new Where((FieldRef)tableFiche.getField("VALIDE"), "=", (Object)Boolean.FALSE));
                        selFiche.andWhere(new Where((FieldRef)tableFiche.getField("ID_MOIS"), "=", selMois.getSelectedId()));
                        selFiche.andWhere(new Where((FieldRef)tableFiche.getField("ANNEE"), "=", (Object)new Integer(textAnnee.getText())));
                        selFiche.andWhere(new Where((FieldRef)tableSalarie.getField("ID"), "=", tableFiche.getField("ID_SALARIE")));
                        selFiche.andWhere(new Where((FieldRef)tableInfosSal.getField("ID"), "=", tableSalarie.getField("ID_INFOS_SALARIE_PAYE")));
                        selFiche.andWhere(new Where((FieldRef)tableSalarie.getField("ID_FICHE_PAYE"), "!=", tableFiche.getKey()));
                        Calendar cal = Calendar.getInstance();
                        cal.set(5, 1);
                        cal.set(2, selMois.getSelectedId() - 2);
                        cal.set(1, Integer.parseInt(textAnnee.getText()));
                        cal.set(5, cal.getActualMaximum(5));
                        Where w = new Where((FieldRef)tableInfosSal.getField("DATE_SORTIE"), "<=", (Object)cal.getTime());
                        w = w.or(new Where((FieldRef)tableInfosSal.getField("DATE_SORTIE"), "=", (Object)null));
                        selFiche.andWhere(w);
                        String req = selFiche.asString();
                        System.err.println(req);
                        List l = (List)ClotureMensuellePayePanel.this.base.getDataSource().execute(req, new ArrayListHandler());
                        int i = 0;
                        while (i < l.size()) {
                            Object[] tmp = (Object[])l.get(i);
                            SQLRow rowFicheTmp = tableFiche.getRow(Integer.parseInt(tmp[0].toString()));
                            System.err.println(rowFicheTmp);
                            FichePayeSQLElement.validationFiche(rowFicheTmp.getID());
                            ++i;
                        }
                    }
                    selFiche = new SQLSelect(ClotureMensuellePayePanel.this.base);
                    tableFiche = ClotureMensuellePayePanel.this.base.getTable("FICHE_PAYE");
                    SQLTable tableMois = ClotureMensuellePayePanel.this.base.getTable("MOIS");
                    selFiche.addSelect(tableFiche.getField("ID"));
                    selFiche.setWhere(new Where((FieldRef)tableFiche.getField("VALIDE"), "=", (Object)Boolean.TRUE));
                    selFiche.andWhere(new Where((FieldRef)tableFiche.getField("ID_MOIS"), "=", selMois.getSelectedId()));
                    selFiche.andWhere(new Where((FieldRef)tableFiche.getField("ANNEE"), "=", (Object)new Integer(textAnnee.getText())));
                    String req = selFiche.asString();
                    List l = (List)ClotureMensuellePayePanel.this.base.getDataSource().execute(req, new ArrayListHandler());
                    if (l != null && l.size() > 0) {
                        int[] idS = new int[l.size()];
                        SQLRow rowMois = tableMois.getRow(selMois.getSelectedId());
                        int i = 0;
                        while (i < l.size()) {
                            Object[] tmp = (Object[])l.get(i);
                            idS[i] = Integer.parseInt(tmp[0].toString());
                            SQLRow rowFiche = tableFiche.getRow(idS[i]);
                            FichePayeSQLElement.clotureMensuelle(selMois.getSelectedId(), Integer.parseInt(textAnnee.getText()), rowFiche.getInt("ID_SALARIE"));
                            ++i;
                        }
                        if (boxCompta.isSelected()) {
                            new GenerationMvtFichePaye(idS, rowMois.getString("NOM"), textAnnee.getText());
                        }
                    }
                    System.err.println("ClotureMensuellePayePanel.ClotureMensuellePayePanel().new ActionListener() {...}.actionPerformed()");
                    JOptionPane.showMessageDialog(null, "Cl\u00f4ture termin\u00e9e");
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Unable to complete operation", ex);
                }
            }
        });
    }
}

