/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;

public class ClotureManuellePanel
extends JPanel {
    private final JDate dateOuv = new JDate();
    private final JDate dateFerm = new JDate();
    private final SQLTable societe = Configuration.getInstance().getBase().getTable("SOCIETE_COMMON");
    private final SQLTable exercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
    private final SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private final SQLRow rowExercice = this.exercice.getRow(this.rowSociete.getInt("ID_EXERCICE_COMMON"));
    private JButton valider = new JButton("Valider");
    private JButton annul = new JButton("Annuler");
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public ClotureManuellePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelBold rappel = new JLabelBold("Op\u00e9rations \u00e0 effectuer avant de continuer: ");
        JLabel label = new JLabel("- report des charges et produits constat\u00e9s d'avance");
        JLabel label2 = new JLabel("- report des charges \u00e0 payer et produits \u00e0 recevoir");
        JLabel label3 = new JLabel("- impression du bilan, compte de r\u00e9sultat, grand livre, journaux et balance");
        JLabel label5 = new JLabel("- g\u00e9n\u00e9ration les \u00e9critures comptables des payes");
        JLabel label4 = new JLabel("Il est pr\u00e9f\u00e9rable de r\u00e9aliser une sauvegarde avant de continuer.");
        JLabelBold op = new JLabelBold("Op\u00e9rations qui vont etre effectu\u00e9es: ");
        JLabel labelValid = new JLabel("- validation de toutes les \u00e9critures concernant la p\u00e9riode de l'exercice.");
        JLabel labelExer = new JLabel("- mise \u00e0 jour de la p\u00e9riode de l'exercice.");
        c.gridy = -1;
        c.gridx = 0;
        java.util.Date dDebut = (java.util.Date)this.rowExercice.getObject("DATE_DEB");
        java.util.Date dFin = (java.util.Date)this.rowExercice.getObject("DATE_FIN");
        JLabel labelAncienExercice = new JLabel("Cl\u00f4ture de l'exercice du " + this.dateFormat.format(dDebut) + " au " + this.dateFormat.format(dFin));
        this.add((Component)labelAncienExercice, c);
        this.add((Component)rappel, c);
        this.add((Component)label, c);
        this.add((Component)label2, c);
        this.add((Component)label3, c);
        this.add((Component)label5, c);
        this.add((Component)label4, c);
        c.insets = new Insets(15, 2, 1, 2);
        this.add((Component)op, c);
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)labelValid, c);
        this.add((Component)labelExer, c);
        c.gridwidth = 1;
        c.gridy = -1;
        c.gridx = 0;
        c.gridx = -1;
        c.fill = 0;
        this.add((Component)new JLabel("Date du nouvel exercice du "), c);
        c.gridx = -1;
        java.util.Date d = (java.util.Date)this.rowExercice.getObject("DATE_FIN");
        this.dateOuv.setValue(new java.util.Date(d.getTime() + 86400000L));
        this.add((Component)this.dateOuv, c);
        this.add((Component)new JLabel("au"), c);
        this.add((Component)this.dateFerm, c);
        c.fill = 0;
        c.gridwidth = 1;
        c.anchor = 13;
        c.gridx = -1;
        c.gridy = 15;
        this.add((Component)this.valider, c);
        this.add((Component)this.annul, c);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClotureManuellePanel.this.valider.setEnabled(ClotureManuellePanel.this.isDateValid());
            }
        };
        this.dateFerm.addValueListener(listener);
        this.dateOuv.addValueListener(listener);
        this.valider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClotureManuellePanel.this.clotureExercice();
                Component comp = SwingUtilities.getRoot(ClotureManuellePanel.this);
                JOptionPane.showMessageDialog(ClotureManuellePanel.this, "Exercice clotur\u00e9", "Fin de la cloture", 1);
                ((JFrame)comp).dispose();
            }
        });
        this.valider.setEnabled(this.isDateValid());
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ClotureManuellePanel.this)).dispose();
            }
        });
    }

    private boolean isDateValid() {
        java.util.Date d = (java.util.Date)this.rowExercice.getObject("DATE_FIN");
        return !this.dateFerm.isEmpty() && !this.dateOuv.isEmpty() && this.dateFerm.getValue().getTime() > this.dateOuv.getValue().getTime() && this.dateOuv.getValue().getTime() > d.getTime();
    }

    private void clotureExercice() {
        EcritureSQLElement.validationEcrituresBefore((java.util.Date)this.rowExercice.getObject("DATE_FIN"), true);
        SQLRowValues valsExercice = new SQLRowValues(this.exercice);
        valsExercice.put("CLOTURE", Boolean.TRUE);
        try {
            valsExercice.update(this.rowExercice.getID());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        valsExercice.put("CLOTURE", Boolean.FALSE);
        valsExercice.put("DATE_DEB", new Date(this.dateOuv.getValue().getTime()));
        valsExercice.put("DATE_FIN", new Date(this.dateFerm.getValue().getTime()));
        valsExercice.put("ID_SOCIETE_COMMON", this.rowSociete.getID());
        try {
            SQLRow rowNewEx = valsExercice.insert();
            SQLRowValues rowValsSociete = new SQLRowValues(this.societe);
            rowValsSociete.put("ID_EXERCICE_COMMON", rowNewEx.getID());
            rowValsSociete.update(this.rowSociete.getID());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

