/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JLabel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.checks.ValidState;

public class ExerciceCommonSQLElement
extends ConfSQLElement {
    public ExerciceCommonSQLElement(DBRoot root) {
        super(root.getTable("EXERCICE_COMMON"), "un excercice", "exercices");
    }

    public ExerciceCommonSQLElement() {
        this(Configuration.getInstance().getRoot());
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE_DEB");
        l.add("DATE_FIN");
        l.add("DATE_CLOTURE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE_DEB");
        l.add("DATE_FIN");
        l.add("DATE_CLOTURE");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"DATE_DEB", "DATE_FIN"});
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            JDate dateDeb;
            JDate dateFin;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.gridx = -1;
                this.dateDeb = new JDate();
                this.dateFin = new JDate();
                JDate dateCloture = new JDate();
                Calendar cal = Calendar.getInstance();
                cal.set(2, 0);
                cal.set(5, 1);
                JLabel labelDateDeb = new JLabel(this.getLabelFor("DATE_DEB"));
                this.add((Component)labelDateDeb, c);
                this.add((Component)this.dateDeb, c);
                this.dateDeb.setValue(cal.getTime());
                cal.set(2, 11);
                cal.set(5, 31);
                JLabel labelDateFin = new JLabel(this.getLabelFor("DATE_FIN"));
                this.add((Component)labelDateFin, c);
                this.add((Component)this.dateFin, c);
                this.dateFin.setValue(cal.getTime());
                ++c.gridy;
                JLabel labelCloture = new JLabel(this.getLabelFor("DATE_CLOTURE"));
                this.add((Component)labelCloture, c);
                this.add((Component)dateCloture, c);
                this.addRequiredSQLObject(this.dateDeb, "DATE_DEB");
                this.addRequiredSQLObject(this.dateFin, "DATE_FIN");
                this.addSQLObject(dateCloture, "DATE_CLOTURE");
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues vals = new SQLRowValues(ExerciceCommonSQLElement.this.getTable());
                Calendar cal = Calendar.getInstance();
                cal.set(2, 0);
                cal.set(5, 1);
                vals.put("DATE_DEB", cal.getTime());
                cal.set(2, 11);
                cal.set(5, 31);
                vals.put("DATE_FIN", cal.getTime());
                return vals;
            }

            @Override
            public synchronized ValidState getValidState() {
                if (this.dateDeb.getValue() == null || this.dateFin.getValue() == null) {
                    return new ValidState(false, "Date de d\u00e9but ou de fin d'exercice non d\u00e9finie");
                }
                return super.getValidState().and(ValidState.createCached(this.dateDeb.getValue().before(this.dateFin.getValue()), "Date de d\u00e9but apr\u00e8s date de fin"));
            }
        };
    }
}

