/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ComptePCESQLElement
extends ComptaSQLConfElement {
    private static Map<String, String> mapCompteDefault = new HashMap<String, String>();

    static {
        mapCompteDefault.put("FOURNISSEURS", "40");
        mapCompteDefault.put("ACHATS", "60");
        mapCompteDefault.put("CLIENTS", "41");
        mapCompteDefault.put("VENTESPRODUITS", "701");
        mapCompteDefault.put("VENTESSERVICES", "706");
        mapCompteDefault.put("TVACOLLECTEE", "4457");
        mapCompteDefault.put("TVADEDUCTIBLE", "4456");
        mapCompteDefault.put("PAYEACOMPTE", "425");
        mapCompteDefault.put("PAYEREGLEMENTACOMPTE", "511");
        mapCompteDefault.put("PAYEREMUNERATIONPERSONNEL", "641");
        mapCompteDefault.put("PAYEREGLEMENT", "421");
        mapCompteDefault.put("ACHATCHEQUE", "512");
        mapCompteDefault.put("ACHATCB", "512");
        mapCompteDefault.put("ACHATTRAITE", "512");
        mapCompteDefault.put("ACHATESPECE", "53");
        mapCompteDefault.put("VENTECHEQUE", "512");
        mapCompteDefault.put("VENTECB", "512");
        mapCompteDefault.put("VENTETRAITE", "512");
        mapCompteDefault.put("VENTEESPECE", "53");
        mapCompteDefault.put("TVAINTRACOMM", "4452");
        mapCompteDefault.put("TVAIMMO", "445620");
        mapCompteDefault.put("BILANOUVERTURE", "890");
        mapCompteDefault.put("BILANFERMETURE", "891");
        mapCompteDefault.put("RESULTAT", "120");
        mapCompteDefault.put("ACHATSINTRA", "607120");
        mapCompteDefault.put("RESULTATPERTE", "129");
        mapCompteDefault.put("FACTOR", "467000");
        mapCompteDefault.put("PORTVENTESOUMISTVA", "708510");
        mapCompteDefault.put("PORTVENTENONSOUMISTVA", "708520");
        mapCompteDefault.put("AVANCECLIENTS", "4191");
        mapCompteDefault.put("VALEURENCAISSEMENT", "511");
    }

    public ComptePCESQLElement() {
        super("COMPTE_PCE", "un compte", "comptes");
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Consulter le compte"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues row = IListe.get(e).getSelectedRow();
                ((EcritureSQLElement)ComptePCESQLElement.this.getDirectory().getElement("ECRITURE")).consultationCompte(row);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        req.setWhere(new Where((FieldRef)this.getTable().getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("NUMERO");
        list.add("NOM");
        list.add("INFOS");
        list.add("OBSOLETE");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("NUMERO");
        list.add("NOM");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private ValidState compteNumeroValidState;
            private JUniqueTextField textNumero;
            {
                this.compteNumeroValidState = ValidState.getTrueInstance();
                this.textNumero = new JUniqueTextField(7);
            }

            @Override
            public void update() {
                int id = this.getSelectedID();
                super.update();
                DBSystemRoot sysRoot = this.getTable().getDBSystemRoot();
                SQLTable ecrT = sysRoot.getGraph().findReferentTable(this.getTable(), "ECRITURE", new String[0]);
                UpdateBuilder updateBuilder = new UpdateBuilder(ecrT);
                updateBuilder.addForwardVirtualJoin(this.getTable(), "ID_COMPTE_PCE");
                updateBuilder.setFromVirtualJoinField("COMPTE_NUMERO", this.getTable().getAlias(), "NUMERO");
                updateBuilder.setFromVirtualJoinField("COMPTE_NOM", this.getTable().getAlias(), "NOM");
                updateBuilder.setWhere(new Where((FieldRef)ecrT.getField("ID_COMPTE_PCE"), "=", id));
                sysRoot.getDataSource().execute(updateBuilder.asString());
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelNumero = new JLabel("Num\u00e9ro ");
                this.add((Component)labelNumero, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.weightx = 0.5;
                this.add((Component)this.textNumero, c);
                this.textNumero.getTextField().getDocument().addDocumentListener(new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        compteNumeroValidState = ComptePCESQLElement.this.getCompteNumeroValidState(textNumero.getText());
                        this.fireValidChange();
                    }
                });
                JLabel labelNom = new JLabel("Libell\u00e9 ");
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelNom, c);
                JTextField textNom = new JTextField(30);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textNom, c);
                ++c.gridx;
                c.weightx = 0.0;
                JCheckBox checkRacine = new JCheckBox("Racine");
                this.add((Component)checkRacine, c);
                ++c.gridy;
                ++c.gridx;
                c.weightx = 0.0;
                JCheckBox checkObs = new JCheckBox("Obsol\u00e8te");
                this.add((Component)checkObs, c);
                JLabel labelInfos = new JLabel(this.getLabelFor("INFOS"));
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)labelInfos, c);
                ITextArea textInfos = new ITextArea();
                ++c.gridx;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridwidth = 0;
                c.gridheight = 0;
                c.fill = 1;
                this.add((Component)textInfos, c);
                this.addRequiredSQLObject(this.textNumero, "NUMERO");
                this.addRequiredSQLObject(textNom, "NOM");
                this.addSQLObject(textInfos, "INFOS");
                this.addSQLObject(checkRacine, "RACINE");
                this.addSQLObject(checkObs, "OBSOLETE");
            }

            @Override
            public synchronized ValidState getValidState() {
                return super.getValidState().and(this.compteNumeroValidState);
            }
        };
    }

    public ValidState getCompteNumeroValidState(String text) {
        if (text.trim().length() > 0) {
            if (text.trim().charAt(0) < '1' || text.trim().charAt(0) > '8') {
                return ValidState.create(false, "Le num\u00e9ro de compte ne commence pas par un chiffre entre 1 et 8");
            }
            if (text.endsWith(" ")) {
                return ValidState.create(false, "Le num\u00e9ro de compte ne doit pas se terminer par un espace");
            }
            Pattern p = Pattern.compile("^\\d(\\w)+$");
            return ValidState.create(p.matcher(text).matches(), "Le num\u00e9ro de compte n'est pas correct.");
        }
        return ValidState.getTrueInstance();
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            SQLBase base = this.getTable().getBase();
            SQLTable ecritureTable = base.getTable("ECRITURE");
            SQLSelect selEcr = new SQLSelect();
            selEcr.addSelect(ecritureTable.getField("ID_COMPTE_PCE"));
            selEcr.setWhere(new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", row.getID()));
            String reqEcriture = selEcr.asString();
            Object obEcriture = base.getDataSource().execute(reqEcriture, new ArrayListHandler());
            List myListEcriture = (List)obEcriture;
            if (myListEcriture.size() != 0) {
                System.err.println("Impossible de supprimer un compte mouvement\u00e9!");
                ExceptionHandler.handle("", new Exception("Impossible de supprimer un compte mouvement\u00e9!"));
                continue;
            }
            super.archive(new TreesOfSQLRows((SQLElement)this, row), cutLinks);
        }
    }

    public static int getId(String numero) {
        return ComptePCESQLElement.getId(numero, "Cr\u00e9ation automatique");
    }

    public static SQLRow getRow(String numero, String nom) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLBackgroundTableCacheItem cacheForTable = SQLBackgroundTableCache.getInstance().getCacheForTable(compteTable);
        if (numero == null) {
            throw new IllegalArgumentException("null numero");
        }
        SQLField field = compteTable.getField("NUMERO");
        if (field == null) {
            throw new IllegalArgumentException("no field NUMERO in table " + compteTable.getName());
        }
        SQLRow res = cacheForTable.getFirstRowContains(numero.trim(), field);
        if (res != null) {
            return res;
        }
        SQLRowValues rowVals = new SQLRowValues(compteTable);
        rowVals.put("NUMERO", numero);
        rowVals.put("NOM", nom);
        try {
            return rowVals.insert();
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du compte num\u00e9ro : " + numero, e);
            return null;
        }
    }

    public static int getId(String numero, String nom) {
        return ComptePCESQLElement.getRow(numero, nom).getID();
    }

    public static boolean isExist(String account) {
        if (account.trim().length() == 0) {
            return false;
        }
        SQLTable tableAccount = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE").getTable();
        SQLBackgroundTableCacheItem item = SQLBackgroundTableCache.getInstance().getCacheForTable(tableAccount);
        return item.getFirstRowContains(account, tableAccount.getField("NUMERO")) != null;
    }

    public static String getComptePceDefault(String name) throws IllegalArgumentException {
        String numero = mapCompteDefault.get(name.toUpperCase());
        if (numero == null) {
            throw new IllegalArgumentException("Impossible de trouver le compte PCE par d\u00e9faut " + name);
        }
        return numero;
    }

    public static void setComptePceDefault(String name, String numero) {
        mapCompteDefault.put(name, numero);
    }

    public static int getIdComptePceDefault(String name) throws IllegalArgumentException {
        String numeroDefault = ComptePCESQLElement.getComptePceDefault(name);
        return ComptePCESQLElement.getId(numeroDefault);
    }

    public static SQLRow getRowComptePceDefault(String name) throws IllegalArgumentException {
        String numeroDefault = ComptePCESQLElement.getComptePceDefault(name);
        return ComptePCESQLElement.getRow(numeroDefault, "cr\u00e9ation automatique");
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".code.enterprise";
    }
}

