/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.openconcerto.erp.core.edm.AttachmentPanel;
import org.openconcerto.erp.core.edm.AttachmentUtils;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;

public class FilePanel
extends JPanel {
    JImage image = null;
    public static final int WIDTH = 128;
    public static final int HEIGHT = 80;
    JLabel label;

    public FilePanel(final SQLRowValues rowAttachment, final AttachmentPanel panelSource) {
        String name = rowAttachment.getString("NAME");
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        try {
            String type = rowAttachment.getString("MIMETYPE");
            this.image = type == null || type.trim().isEmpty() || type.equals("application/octet-stream") ? new JImage(this.getClass().getResource("data-icon.png")) : (type.equals("application/msword") ? new JImage(this.getClass().getResource("doc-icon.png")) : (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document") ? new JImage(this.getClass().getResource("docx-icon.png")) : (type.equals("application/vnd.oasis.opendocument.text") ? new JImage(this.getClass().getResource("odt-icon.png")) : (type.equals("application/pdf") ? new JImage(this.getClass().getResource("pdf-icon.png")) : (type.equals("image/jpeg") ? new JImage(this.getClass().getResource("jpg-icon.png")) : (type.equals("image/png") ? new JImage(this.getClass().getResource("png-icon.png")) : (type.equals("application/vnd.oasis.opendocument.spreadsheet") ? new JImage(this.getClass().getResource("ods-icon.png")) : (type.equals("application/msexcel") || type.equals("application/vnd.ms-excel") || type.equals("application/xls") ? new JImage(this.getClass().getResource("xls-icon.png")) : (type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") ? new JImage(this.getClass().getResource("xlsx-icon.png")) : new JImage(this.getClass().getResource("data-icon.png")))))))))));
            this.image.setOpaque(true);
            this.image.setCenterImage(true);
            this.add((Component)this.image, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBackground(Color.WHITE);
        this.label = new JLabel(name, 0);
        this.label.setOpaque(false);
        this.add((Component)this.label, "South");
        this.setPreferredSize(new Dimension(128, 80));
        this.setMinimumSize(new Dimension(128, 80));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                FilePanel.this.setBackground(Color.WHITE);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                FilePanel.this.setBackground(new Color(230, 240, 255));
            }
        });
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItemDelete = new JMenuItem("Supprimer");
        menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = JOptionPane.showConfirmDialog(FilePanel.this, "Voulez-vous vraiment supprimer ce fichier ?\n" + rowAttachment.getString("NAME") + "\nFichier orignal : " + rowAttachment.getString("FILENAME") + "\nType : " + rowAttachment.getString("MIMETYPE"), "Supprimer le ficher", 0);
                if (value == 0) {
                    AttachmentUtils utils = new AttachmentUtils();
                    try {
                        utils.deleteFile(rowAttachment);
                        panelSource.initUI();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle("Erreur lors de la suppression du fichier!", e1);
                    }
                }
            }
        });
        menu.add(menuItemDelete);
        JMenuItem menuItemRename = new JMenuItem("Renommer");
        menuItemRename.addActionListener(new ActionListener(name){
            final JTextField text;
            {
                this.text = new JTextField(string);
            }

            private void stopNameEditing() {
                FilePanel.this.invalidate();
                FilePanel.this.remove(this.text);
                FilePanel.this.add((Component)FilePanel.this.label, "South");
                FilePanel.this.validate();
                FilePanel.this.repaint();
            }

            public void validText(SQLRowValues rowAttachment2, String name, JTextField text) {
                try {
                    String newName = text.getText();
                    if (newName.trim().isEmpty()) {
                        newName = name;
                    }
                    rowAttachment2.put("NAME", newName).commit();
                    FilePanel.this.label.setText(newName);
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Erreur lors du renommage du fichier!", e1);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                final String name = rowAttachment.getString("NAME");
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            this.validText(rowAttachment, name, text);
                            this.stopNameEditing();
                        } else if (e.getKeyCode() == 27) {
                            this.stopNameEditing();
                        }
                    }
                });
                this.text.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        this.validText(rowAttachment, name, text);
                        this.stopNameEditing();
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
                this.text.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        this.validText(rowAttachment, name, text);
                        this.stopNameEditing();
                    }
                });
                FilePanel.this.invalidate();
                FilePanel.this.remove(FilePanel.this.label);
                FilePanel.this.add((Component)this.text, "South");
                FilePanel.this.validate();
                FilePanel.this.repaint();
                this.text.grabFocus();
                this.text.setSelectionStart(0);
                this.text.setSelectionEnd(name.length());
            }
        });
        menu.add(menuItemRename);
        menu.addSeparator();
        JMenuItem menuItemProperties = new JMenuItem("Propri\u00e9t\u00e9s");
        menuItemProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame();
                f.setTitle("Propri\u00e9t\u00e9s de " + rowAttachment.getString("NAME"));
                JPanel p = new JPanel();
                p.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.weightx = 0.0;
                p.add((Component)new JLabel("Nom : ", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                p.add((Component)new JLabel(rowAttachment.getString("NAME")), c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                p.add((Component)new JLabel("Type : ", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                p.add((Component)new JLabel(rowAttachment.getString("MIMETYPE")), c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                p.add((Component)new JLabel("Fichier original : ", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                p.add((Component)new JLabel(rowAttachment.getString("FILENAME")), c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                p.add((Component)new JLabel("Taille : ", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                p.add((Component)new JLabel(String.valueOf(rowAttachment.getInt("FILESIZE")) + " octets"), c);
                c.gridx = 1;
                ++c.gridy;
                c.weightx = 1.0;
                JPanel spacer = new JPanel();
                spacer.setPreferredSize(new Dimension(300, 1));
                p.add((Component)spacer, c);
                f.setDefaultCloseOperation(2);
                f.setContentPane(p);
                f.pack();
                f.setResizable(false);
                f.setLocationRelativeTo(FilePanel.this);
                f.setVisible(true);
            }
        });
        menu.add(menuItemProperties);
        this.setComponentPopupMenu(menu);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.image != null) {
            this.image.setBackground(bg);
        }
    }
}

