/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.itemview.VWRowItemView;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.valuewrapper.ValueWrapper;

public class VilleRowItemView
extends VWRowItemView<Ville> {
    public VilleRowItemView(ValueWrapper<Ville> wrapper) {
        super(wrapper);
    }

    @Override
    public void setEditable(InteractionMode b) {
        if (this.getComp() != null) {
            this.getComp().setEnabled(b.isEnabled());
        }
    }

    @Override
    public void show(SQLRowAccessor r) {
        String fieldName0 = this.getFields().get(0).getName();
        String fieldName1 = this.getFields().get(1).getName();
        if (r.getFields().contains(fieldName0) && r.getFields().contains(fieldName1)) {
            String cp = r.getString(fieldName0);
            String name = r.getString(fieldName1);
            Ville villeFromVilleEtCode = Ville.getVilleFromVilleEtCode(String.valueOf(name) + " (" + cp + ")");
            if (villeFromVilleEtCode != null) {
                this.getWrapper().setValue(villeFromVilleEtCode);
            } else {
                this.getWrapper().setValue(new Ville(name, 0L, 0L, 0L, cp));
            }
        }
    }

    @Override
    public void update(SQLRowValues vals) {
        vals.put(this.getFields().get(1).getName(), this.isEmpty() ? SQLRowValues.SQL_DEFAULT : ((Ville)this.getWrapper().getValue()).getName());
        vals.put(this.getFields().get(0).getName(), this.isEmpty() ? SQLRowValues.SQL_DEFAULT : ((Ville)this.getWrapper().getValue()).getCodepostal());
    }
}

