/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.VertexSetListener;
import org.jgrapht.graph.GraphDelegator;
import org.jgrapht.util.TypeUtil;

public class DefaultListenableGraph<V, E>
extends GraphDelegator<V, E>
implements Cloneable,
ListenableGraph<V, E> {
    private static final long serialVersionUID = 3977575900898471984L;
    private ArrayList<GraphListener<V, E>> graphListeners = new ArrayList();
    private ArrayList<VertexSetListener<V>> vertexSetListeners = new ArrayList();
    private FlyweightEdgeEvent<V, E> reuseableEdgeEvent;
    private FlyweightVertexEvent<V> reuseableVertexEvent;
    private boolean reuseEvents;

    public DefaultListenableGraph(Graph<V, E> g) {
        this(g, false);
    }

    public DefaultListenableGraph(Graph<V, E> g, boolean reuseEvents) {
        super(g);
        this.reuseEvents = reuseEvents;
        this.reuseableEdgeEvent = new FlyweightEdgeEvent((Object)this, -1, null);
        this.reuseableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, -1, null);
        if (g instanceof ListenableGraph) {
            throw new IllegalArgumentException("base graph cannot be listenable");
        }
    }

    public void setReuseEvents(boolean reuseEvents) {
        this.reuseEvents = reuseEvents;
    }

    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        Object e = super.addEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.fireEdgeAdded(e);
        }
        return e;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        boolean added = super.addEdge(sourceVertex, targetVertex, e);
        if (added) {
            this.fireEdgeAdded(e);
        }
        return added;
    }

    @Override
    public void addGraphListener(GraphListener<V, E> l) {
        DefaultListenableGraph.addToListenerList(this.graphListeners, l);
    }

    @Override
    public boolean addVertex(V v) {
        boolean modified = super.addVertex(v);
        if (modified) {
            this.fireVertexAdded(v);
        }
        return modified;
    }

    @Override
    public void addVertexSetListener(VertexSetListener<V> l) {
        DefaultListenableGraph.addToListenerList(this.vertexSetListeners, l);
    }

    public Object clone() {
        try {
            TypeUtil typeDecl = null;
            DefaultListenableGraph g = (DefaultListenableGraph)TypeUtil.uncheckedCast(super.clone(), typeDecl);
            g.graphListeners = new ArrayList();
            g.vertexSetListeners = new ArrayList();
            return g;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException("internal error");
        }
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        Object e = super.removeEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.fireEdgeRemoved(e);
        }
        return e;
    }

    @Override
    public boolean removeEdge(E e) {
        boolean modified = super.removeEdge(e);
        if (modified) {
            this.fireEdgeRemoved(e);
        }
        return modified;
    }

    @Override
    public void removeGraphListener(GraphListener<V, E> l) {
        this.graphListeners.remove(l);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set touchingEdgesList = this.edgesOf(v);
            this.removeAllEdges(new ArrayList(touchingEdgesList));
            super.removeVertex(v);
            this.fireVertexRemoved(v);
            return true;
        }
        return false;
    }

    @Override
    public void removeVertexSetListener(VertexSetListener<V> l) {
        this.vertexSetListeners.remove(l);
    }

    protected void fireEdgeAdded(E edge) {
        GraphEdgeChangeEvent<V, E> e = this.createGraphEdgeChangeEvent(23, edge);
        int i = 0;
        while (i < this.graphListeners.size()) {
            GraphListener<V, E> l = this.graphListeners.get(i);
            l.edgeAdded(e);
            ++i;
        }
    }

    protected void fireEdgeRemoved(E edge) {
        GraphEdgeChangeEvent<V, E> e = this.createGraphEdgeChangeEvent(24, edge);
        int i = 0;
        while (i < this.graphListeners.size()) {
            GraphListener<V, E> l = this.graphListeners.get(i);
            l.edgeRemoved(e);
            ++i;
        }
    }

    protected void fireVertexAdded(V vertex) {
        VertexSetListener<V> l;
        GraphVertexChangeEvent<V> e = this.createGraphVertexChangeEvent(13, vertex);
        int i = 0;
        while (i < this.vertexSetListeners.size()) {
            l = this.vertexSetListeners.get(i);
            l.vertexAdded(e);
            ++i;
        }
        i = 0;
        while (i < this.graphListeners.size()) {
            l = this.graphListeners.get(i);
            l.vertexAdded(e);
            ++i;
        }
    }

    protected void fireVertexRemoved(V vertex) {
        VertexSetListener<V> l;
        GraphVertexChangeEvent<V> e = this.createGraphVertexChangeEvent(14, vertex);
        int i = 0;
        while (i < this.vertexSetListeners.size()) {
            l = this.vertexSetListeners.get(i);
            l.vertexRemoved(e);
            ++i;
        }
        i = 0;
        while (i < this.graphListeners.size()) {
            l = this.graphListeners.get(i);
            l.vertexRemoved(e);
            ++i;
        }
    }

    private static <L extends EventListener> void addToListenerList(List<L> list, L l) {
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    private GraphEdgeChangeEvent<V, E> createGraphEdgeChangeEvent(int eventType, E edge) {
        if (this.reuseEvents) {
            this.reuseableEdgeEvent.setType(eventType);
            this.reuseableEdgeEvent.setEdge(edge);
            return this.reuseableEdgeEvent;
        }
        return new GraphEdgeChangeEvent(this, eventType, edge);
    }

    private GraphVertexChangeEvent<V> createGraphVertexChangeEvent(int eventType, V vertex) {
        if (this.reuseEvents) {
            this.reuseableVertexEvent.setType(eventType);
            this.reuseableVertexEvent.setVertex(vertex);
            return this.reuseableVertexEvent;
        }
        return new GraphVertexChangeEvent<V>(this, eventType, vertex);
    }

    private static class FlyweightEdgeEvent<VV, EE>
    extends GraphEdgeChangeEvent<VV, EE> {
        private static final long serialVersionUID = 3907207152526636089L;

        public FlyweightEdgeEvent(Object eventSource, int type, EE e) {
            super(eventSource, type, e);
        }

        protected void setEdge(EE e) {
            this.edge = e;
        }

        protected void setType(int type) {
            this.type = type;
        }
    }

    private static class FlyweightVertexEvent<VV>
    extends GraphVertexChangeEvent<VV> {
        private static final long serialVersionUID = 3257848787857585716L;

        public FlyweightVertexEvent(Object eventSource, int type, VV vertex) {
            super(eventSource, type, vertex);
        }

        protected void setType(int type) {
            this.type = type;
        }

        protected void setVertex(VV vertex) {
            this.vertex = vertex;
        }
    }
}

