/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.SimpleDirectedGraph;

public class TransitiveClosure {
    public static final TransitiveClosure INSTANCE = new TransitiveClosure();

    private TransitiveClosure() {
    }

    public <V, E> void closeSimpleDirectedGraph(SimpleDirectedGraph<V, E> graph) {
        Set vertexSet = graph.vertexSet();
        HashSet newEdgeTargets = new HashSet();
        int bound = this.computeBinaryLog(vertexSet.size());
        boolean done = false;
        int i = 0;
        while (!done && i < bound) {
            done = true;
            for (Object v1 : vertexSet) {
                newEdgeTargets.clear();
                for (Object v1OutEdge : graph.outgoingEdgesOf(v1)) {
                    Object v2 = graph.getEdgeTarget(v1OutEdge);
                    for (Object v2OutEdge : graph.outgoingEdgesOf(v2)) {
                        Object v3 = graph.getEdgeTarget(v2OutEdge);
                        if (v1.equals(v3) || graph.getEdge(v1, v3) != null) continue;
                        newEdgeTargets.add(v3);
                        done = false;
                    }
                }
                for (Object v3 : newEdgeTargets) {
                    graph.addEdge(v1, v3);
                }
            }
            ++i;
        }
    }

    private int computeBinaryLog(int n) {
        assert (n >= 0);
        int result = 0;
        while (n > 0) {
            n >>= 1;
            ++result;
        }
        return result;
    }
}

