/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.UndirectedMaskSubgraph;

public class BlockCutpointGraph<V, E>
extends SimpleGraph<UndirectedGraph<V, E>, DefaultEdge> {
    private static final long serialVersionUID = -9101341117013163934L;
    private Set<V> cutpoints = new HashSet<V>();
    private DirectedGraph<V, DefaultEdge> dfsTree;
    private UndirectedGraph<V, E> graph;
    private int numOrder;
    private Stack<BCGEdge> stack = new Stack();
    private Map<V, Set<UndirectedGraph<V, E>>> vertex2biconnectedSubgraphs = new HashMap<V, Set<UndirectedGraph<V, E>>>();
    private Map<V, UndirectedGraph<V, E>> vertex2block = new HashMap<V, UndirectedGraph<V, E>>();
    private Map<V, Integer> vertex2numOrder = new HashMap<V, Integer>();

    public BlockCutpointGraph(UndirectedGraph<V, E> graph) {
        super(DefaultEdge.class);
        this.graph = graph;
        this.dfsTree = new SimpleDirectedGraph(DefaultEdge.class);
        Object s = graph.vertexSet().iterator().next();
        this.dfsTree.addVertex(s);
        this.dfsVisit(s, s);
        if (this.dfsTree.edgesOf(s).size() > 1) {
            this.cutpoints.add(s);
        } else {
            this.cutpoints.remove(s);
        }
        for (V cutpoint : this.cutpoints) {
            SimpleGraph subgraph = new SimpleGraph(this.graph.getEdgeFactory());
            subgraph.addVertex(cutpoint);
            this.vertex2block.put(cutpoint, subgraph);
            this.addVertex(subgraph);
            Set<UndirectedGraph<V, E>> biconnectedSubgraphs = this.getBiconnectedSubgraphs(cutpoint);
            for (UndirectedGraph<V, E> biconnectedSubgraph : biconnectedSubgraphs) {
                assert (this.vertexSet().contains(biconnectedSubgraph));
                this.addEdge(subgraph, biconnectedSubgraph);
            }
        }
    }

    public UndirectedGraph<V, E> getBlock(V vertex) {
        if (!this.graph.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.vertex2block.get(vertex);
    }

    public Set<V> getCutpoints() {
        return this.cutpoints;
    }

    public boolean isCutpoint(V vertex) {
        if (!this.graph.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.cutpoints.contains(vertex);
    }

    private void biconnectedComponentFinished(V s, V n) {
        this.cutpoints.add(s);
        HashSet vertexComponent = new HashSet();
        HashSet<BCGEdge> edgeComponent = new HashSet<BCGEdge>();
        BCGEdge edge = this.stack.pop();
        while (this.getNumOrder(edge.getSource()) >= this.getNumOrder(n) && !this.stack.isEmpty()) {
            edgeComponent.add(edge);
            vertexComponent.add(edge.getSource());
            vertexComponent.add(edge.getTarget());
            edge = this.stack.pop();
        }
        edgeComponent.add(edge);
        vertexComponent.add(edge.getSource());
        vertexComponent.add(edge.getTarget());
        VertexComponentForbiddenFunction mask = new VertexComponentForbiddenFunction(vertexComponent);
        UndirectedMaskSubgraph<V, E> biconnectedSubgraph = new UndirectedMaskSubgraph<V, E>(this.graph, mask);
        for (Object vertex : vertexComponent) {
            this.vertex2block.put((UndirectedMaskSubgraph<V, E>)vertex, (UndirectedGraph<UndirectedMaskSubgraph<V, E>, E>)biconnectedSubgraph);
            this.getBiconnectedSubgraphs(vertex).add(biconnectedSubgraph);
        }
        this.addVertex(biconnectedSubgraph);
    }

    private int dfsVisit(V s, V father) {
        ++this.numOrder;
        int minS = this.numOrder;
        this.setNumOrder(s, this.numOrder);
        for (Object edge : this.graph.edgesOf(s)) {
            V n = Graphs.getOppositeVertex(this.graph, edge, s);
            if (this.getNumOrder(n) == 0) {
                this.dfsTree.addVertex(n);
                BCGEdge dfsEdge = new BCGEdge(s, n);
                this.dfsTree.addEdge(s, n, dfsEdge);
                this.stack.push(dfsEdge);
                int minN = this.dfsVisit(n, s);
                minS = Math.min(minN, minS);
                if (minN < this.getNumOrder(s)) continue;
                this.biconnectedComponentFinished(s, n);
                continue;
            }
            if (this.getNumOrder(n) >= this.getNumOrder(s) || n.equals(father)) continue;
            BCGEdge backwardEdge = new BCGEdge(s, n);
            this.stack.push(backwardEdge);
            minS = Math.min(this.getNumOrder(n), minS);
        }
        return minS;
    }

    private Set<UndirectedGraph<V, E>> getBiconnectedSubgraphs(V vertex) {
        Set<UndirectedGraph<V, E>> biconnectedSubgraphs = this.vertex2biconnectedSubgraphs.get(vertex);
        if (biconnectedSubgraphs == null) {
            biconnectedSubgraphs = new HashSet<UndirectedGraph<V, E>>();
            this.vertex2biconnectedSubgraphs.put((Set<UndirectedGraph<V, E>>)vertex, (Set<UndirectedGraph<Set<UndirectedGraph<V, E>>, E>>)biconnectedSubgraphs);
        }
        return biconnectedSubgraphs;
    }

    private int getNumOrder(V vertex) {
        assert (vertex != null);
        Integer numOrder = this.vertex2numOrder.get(vertex);
        if (numOrder == null) {
            return 0;
        }
        return numOrder;
    }

    private void setNumOrder(V vertex, int numOrder) {
        this.vertex2numOrder.put((Integer)vertex, numOrder);
    }

    private class BCGEdge
    extends DefaultEdge {
        private static final long serialVersionUID = -5115006161815760059L;
        private V source;
        private V target;

        public BCGEdge(V source, V target) {
            this.source = source;
            this.target = target;
        }

        public V getSource() {
            return this.source;
        }

        public V getTarget() {
            return this.target;
        }
    }

    private class VertexComponentForbiddenFunction
    implements MaskFunctor<V, E> {
        private Set<V> vertexComponent;

        public VertexComponentForbiddenFunction(Set<V> vertexComponent) {
            this.vertexComponent = vertexComponent;
        }

        @Override
        public boolean isEdgeMasked(E edge) {
            return false;
        }

        @Override
        public boolean isVertexMasked(V vertex) {
            return !this.vertexComponent.contains(vertex);
        }
    }
}

