/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.TextMimeDetector;
import eu.medsea.mimeutil.detector.MimeDetector;
import eu.medsea.util.EncodingGuesser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

class MimeDetectorRegistry {
    private static Logger log = Logger.getLogger(MimeDetectorRegistry.class.getName());
    private TextMimeDetector TextMimeDetector = new TextMimeDetector(1);
    private Map mimeDetectors = new TreeMap();

    MimeDetectorRegistry() {
    }

    MimeDetector registerMimeDetector(String mimeDetector) {
        if (this.mimeDetectors.containsKey(mimeDetector)) {
            log.warning("MimeDetector [" + mimeDetector + "] will not be registered as a MimeDetector with this name is already registered.");
            return (MimeDetector)this.mimeDetectors.get(mimeDetector);
        }
        try {
            MimeDetector md = (MimeDetector)Class.forName(mimeDetector).newInstance();
            md.init();
            log.finest("Registering MimeDetector with name [" + md.getName() + "] and description [" + md.getDescription() + "]");
            this.mimeDetectors.put(mimeDetector, md);
            return md;
        }
        catch (Exception e) {
            log.severe("Exception while registering MimeDetector [" + mimeDetector + "].");
            return null;
        }
    }

    Collection getMimeTypes(File file) throws MimeException {
        Collection<Object> mimeTypes = new ArrayList();
        try {
            if (!EncodingGuesser.getSupportedEncodings().isEmpty()) {
                mimeTypes = this.TextMimeDetector.getMimeTypes(file);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator it = this.mimeDetectors.values().iterator();
        while (it.hasNext()) {
            try {
                MimeDetector md = (MimeDetector)it.next();
                mimeTypes.addAll(md.getMimeTypes(file));
            }
            catch (UnsupportedOperationException md) {
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
        }
        return mimeTypes;
    }
}

