/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Assert;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.BytesDictionaryMatcher;
import com.ibm.icu.text.CharsDictionaryMatcher;
import com.ibm.icu.text.DictionaryMatcher;
import com.ibm.icu.util.UResourceBundle;
import java.io.IOException;
import java.nio.ByteBuffer;

final class DictionaryData {
    public static DictionaryMatcher loadDictionaryFor(String dictType) throws IOException {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt56b/brkitr");
        String dictFileName = rb.getStringWithFallback("dictionaries/" + dictType);
        dictFileName = "brkitr/" + dictFileName;
        ByteBuffer bytes = ICUBinary.getRequiredData(dictFileName);
        ICUBinary.readHeader(bytes, 1147757428, null);
        int[] indexes = new int[8];
        for (int i = 0; i < 8; ++i) {
            indexes[i] = bytes.getInt();
        }
        int offset = indexes[0];
        Assert.assrt(offset >= 32);
        if (offset > 32) {
            int diff = offset - 32;
            ICUBinary.skipBytes(bytes, diff);
        }
        int trieType = indexes[4] & 7;
        int totalSize = indexes[3] - offset;
        DictionaryMatcher m = null;
        if (trieType == 0) {
            int transform = indexes[5];
            byte[] data = new byte[totalSize];
            bytes.get(data);
            m = new BytesDictionaryMatcher(data, transform);
        } else if (trieType == 1) {
            Assert.assrt(totalSize % 2 == 0);
            String data = ICUBinary.getString(bytes, totalSize / 2, totalSize & 1);
            m = new CharsDictionaryMatcher(data);
        } else {
            m = null;
        }
        return m;
    }
}

