/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.UCharacterNameReader;
import com.ibm.icu.impl.UCharacterUtility;
import com.ibm.icu.lang.UCharacter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.MissingResourceException;

public final class UCharacterName {
    public static final UCharacterName INSTANCE;
    public int m_groupcount_ = 0;
    int m_groupsize_ = 0;
    private char[] m_tokentable_;
    private byte[] m_tokenstring_;
    private char[] m_groupinfo_;
    private byte[] m_groupstring_;
    private AlgorithmName[] m_algorithm_;
    private char[] m_groupoffsets_ = new char[33];
    private char[] m_grouplengths_ = new char[33];
    private int[] m_nameSet_ = new int[8];
    private int[] m_ISOCommentSet_ = new int[8];
    private StringBuffer m_utilStringBuffer_ = new StringBuffer();
    private int[] m_utilIntBuffer_ = new int[2];
    private static final String[] TYPE_NAMES_;

    public int getCharFromName(int choice, String name) {
        if (choice >= 4 || name == null || name.length() == 0) {
            return -1;
        }
        int result = UCharacterName.getExtendedChar(name.toLowerCase(Locale.ENGLISH), choice);
        if (result >= -1) {
            return result;
        }
        String upperCaseName = name.toUpperCase(Locale.ENGLISH);
        if (choice == 0 || choice == 2) {
            int count = 0;
            if (this.m_algorithm_ != null) {
                count = this.m_algorithm_.length;
            }
            --count;
            while (count >= 0) {
                result = this.m_algorithm_[count].getChar(upperCaseName);
                if (result >= 0) {
                    return result;
                }
                --count;
            }
        }
        if (choice == 2) {
            result = this.getGroupChar(upperCaseName, 0);
            if (result == -1) {
                result = this.getGroupChar(upperCaseName, 3);
            }
        } else {
            result = this.getGroupChar(upperCaseName, choice);
        }
        return result;
    }

    public int getGroupLengths(int index, char[] offsets, char[] lengths) {
        int length = 65535;
        byte b = 0;
        byte n = 0;
        int stringoffset = UCharacterUtility.toInt(this.m_groupinfo_[(index *= this.m_groupsize_) + 1], this.m_groupinfo_[index + 2]);
        offsets[0] = '\u0000';
        int i = 0;
        while (i < 32) {
            b = this.m_groupstring_[stringoffset];
            for (int shift = 4; shift >= 0; shift -= 4) {
                n = (byte)(b >> shift & 0xF);
                if (length == 65535 && n > 11) {
                    length = (char)(n - 12 << 4);
                    continue;
                }
                lengths[i] = length != 65535 ? (char)((length | n) + 12) : (char)n;
                if (i < 32) {
                    offsets[i + 1] = (char)(offsets[i] + lengths[i]);
                }
                length = 65535;
                ++i;
            }
            ++stringoffset;
        }
        return stringoffset;
    }

    boolean setToken(char[] token, byte[] tokenstring) {
        if (token != null && tokenstring != null && token.length > 0 && tokenstring.length > 0) {
            this.m_tokentable_ = token;
            this.m_tokenstring_ = tokenstring;
            return true;
        }
        return false;
    }

    boolean setAlgorithm(AlgorithmName[] alg) {
        if (alg != null && alg.length != 0) {
            this.m_algorithm_ = alg;
            return true;
        }
        return false;
    }

    boolean setGroupCountSize(int count, int size) {
        if (count <= 0 || size <= 0) {
            return false;
        }
        this.m_groupcount_ = count;
        this.m_groupsize_ = size;
        return true;
    }

    boolean setGroup(char[] group, byte[] groupstring) {
        if (group != null && groupstring != null && group.length > 0 && groupstring.length > 0) {
            this.m_groupinfo_ = group;
            this.m_groupstring_ = groupstring;
            return true;
        }
        return false;
    }

    private UCharacterName() throws IOException {
        ByteBuffer b = ICUBinary.getRequiredData("unames.icu");
        UCharacterNameReader reader = new UCharacterNameReader(b);
        reader.read(this);
    }

    private synchronized int getGroupChar(String name, int choice) {
        for (int i = 0; i < this.m_groupcount_; ++i) {
            int startgpstrindex = this.getGroupLengths(i, this.m_groupoffsets_, this.m_grouplengths_);
            int result = this.getGroupChar(startgpstrindex, this.m_grouplengths_, name, choice);
            if (result == -1) continue;
            return this.m_groupinfo_[i * this.m_groupsize_] << 5 | result;
        }
        return -1;
    }

    private int getGroupChar(int index, char[] length, String name, int choice) {
        byte b = 0;
        int namelen = name.length();
        for (int result = 0; result <= 32; ++result) {
            int nindex = 0;
            int len = length[result];
            if (choice != 0 && choice != 2) {
                int fieldIndex = choice == 4 ? 2 : choice;
                do {
                    int oldindex = index;
                    index += UCharacterUtility.skipByteSubString(this.m_groupstring_, index, len, (byte)59);
                    len -= index - oldindex;
                } while (--fieldIndex > 0);
            }
            int count = 0;
            while (count < len && nindex != -1 && nindex < namelen) {
                b = this.m_groupstring_[index + count];
                ++count;
                if (b >= this.m_tokentable_.length) {
                    if (name.charAt(nindex++) == (b & 0xFF)) continue;
                    nindex = -1;
                    continue;
                }
                char token = this.m_tokentable_[b & 0xFF];
                if (token == '\ufffe') {
                    token = this.m_tokentable_[b << 8 | this.m_groupstring_[index + count] & 0xFF];
                    ++count;
                }
                if (token == '\uffff') {
                    if (name.charAt(nindex++) == (b & 0xFF)) continue;
                    nindex = -1;
                    continue;
                }
                nindex = UCharacterUtility.compareNullTermByteSubString(name, this.m_tokenstring_, nindex, token);
            }
            if (namelen == nindex && (count == len || this.m_groupstring_[index + count] == 59)) {
                return result;
            }
            index += len;
        }
        return -1;
    }

    private static int getType(int ch) {
        if (UCharacterUtility.isNonCharacter(ch)) {
            return 30;
        }
        int result = UCharacter.getType(ch);
        if (result == 18) {
            result = ch <= 56319 ? 31 : 32;
        }
        return result;
    }

    private static int getExtendedChar(String name, int choice) {
        if (name.charAt(0) == '<') {
            int startIndex;
            int endIndex;
            if (choice == 2 && name.charAt(endIndex = name.length() - 1) == '>' && (startIndex = name.lastIndexOf(45)) >= 0) {
                ++startIndex;
                int result = -1;
                try {
                    result = Integer.parseInt(name.substring(startIndex, endIndex), 16);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                String type = name.substring(1, startIndex - 1);
                int length = TYPE_NAMES_.length;
                for (int i = 0; i < length; ++i) {
                    if (type.compareTo(TYPE_NAMES_[i]) != 0) continue;
                    if (UCharacterName.getType(result) != i) break;
                    return result;
                }
            }
            return -1;
        }
        return -2;
    }

    static {
        try {
            INSTANCE = new UCharacterName();
        }
        catch (IOException e) {
            throw new MissingResourceException("Could not construct UCharacterName. Missing unames.icu", "", "");
        }
        TYPE_NAMES_ = new String[]{"unassigned", "uppercase letter", "lowercase letter", "titlecase letter", "modifier letter", "other letter", "non spacing mark", "enclosing mark", "combining spacing mark", "decimal digit number", "letter number", "other number", "space separator", "line separator", "paragraph separator", "control", "format", "private use area", "surrogate", "dash punctuation", "start punctuation", "end punctuation", "connector punctuation", "other punctuation", "math symbol", "currency symbol", "modifier symbol", "other symbol", "initial punctuation", "final punctuation", "noncharacter", "lead surrogate", "trail surrogate"};
    }

    static final class AlgorithmName {
        private int m_rangestart_;
        private int m_rangeend_;
        private byte m_type_;
        private byte m_variant_;
        private char[] m_factor_;
        private String m_prefix_;
        private byte[] m_factorstring_;
        private StringBuffer m_utilStringBuffer_ = new StringBuffer();
        private int[] m_utilIntBuffer_ = new int[256];

        AlgorithmName() {
        }

        boolean setInfo(int rangestart, int rangeend, byte type, byte variant) {
            if (rangestart >= 0 && rangestart <= rangeend && rangeend <= 0x10FFFF && (type == 0 || type == 1)) {
                this.m_rangestart_ = rangestart;
                this.m_rangeend_ = rangeend;
                this.m_type_ = type;
                this.m_variant_ = variant;
                return true;
            }
            return false;
        }

        boolean setFactor(char[] factor) {
            if (factor.length == this.m_variant_) {
                this.m_factor_ = factor;
                return true;
            }
            return false;
        }

        boolean setPrefix(String prefix) {
            if (prefix != null && prefix.length() > 0) {
                this.m_prefix_ = prefix;
                return true;
            }
            return false;
        }

        boolean setFactorString(byte[] string) {
            this.m_factorstring_ = string;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        int getChar(String name) {
            int prefixlen = this.m_prefix_.length();
            if (name.length() < prefixlen) return -1;
            if (!this.m_prefix_.equals(name.substring(0, prefixlen))) {
                return -1;
            }
            switch (this.m_type_) {
                case 0: {
                    try {
                        int result = Integer.parseInt(name.substring(prefixlen), 16);
                        if (this.m_rangestart_ > result) return -1;
                        if (result > this.m_rangeend_) return -1;
                        return result;
                    }
                    catch (NumberFormatException e) {
                        return -1;
                    }
                }
                case 1: {
                    int ch = this.m_rangestart_;
                    while (ch <= this.m_rangeend_) {
                        int factor;
                        int offset = ch - this.m_rangestart_;
                        int[] indexes = this.m_utilIntBuffer_;
                        int[] nArray = this.m_utilIntBuffer_;
                        // MONITORENTER : this.m_utilIntBuffer_
                        for (int i = this.m_variant_ - 1; i > 0; offset /= factor, --i) {
                            factor = this.m_factor_[i] & 0xFF;
                            indexes[i] = offset % factor;
                        }
                        indexes[0] = offset;
                        if (this.compareFactorString(indexes, this.m_variant_, name, prefixlen)) {
                            // MONITOREXIT : nArray
                            return ch;
                        }
                        // MONITOREXIT : nArray
                        ++ch;
                    }
                    return -1;
                }
            }
            return -1;
        }

        private boolean compareFactorString(int[] index, int length, String str, int offset) {
            int size = this.m_factor_.length;
            if (index == null || length != size) {
                return false;
            }
            int count = 0;
            int strcount = offset;
            --size;
            for (int i = 0; i <= size; ++i) {
                char factor = this.m_factor_[i];
                if ((strcount = UCharacterUtility.compareNullTermByteSubString(str, this.m_factorstring_, strcount, count = UCharacterUtility.skipNullTermByteSubString(this.m_factorstring_, count, index[i]))) < 0) {
                    return false;
                }
                if (i == size) continue;
                count = UCharacterUtility.skipNullTermByteSubString(this.m_factorstring_, count, factor - index[i]);
            }
            return strcount == str.length();
        }
    }
}

