/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.regex.Pattern;

public class PercentEncoder {
    static BitSet dontNeedEncoding;
    static String dfltEncName;
    private static String zeroes;
    private static Pattern percentU;

    static {
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(126);
        dontNeedEncoding.set(32);
        zeroes = "0000";
        percentU = Pattern.compile("%u\\p{XDigit}{4}");
    }

    public static String encode(String s, Charset charset) {
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == ' ') {
                    out.append("%20");
                    needToChange = true;
                } else {
                    out.append(c);
                }
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !dontNeedEncoding.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset);
            int j = 0;
            while (j < ba.length) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ++j;
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }
}

