/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.cc.AbstractMapDecorator;

class UnmodifiableCollectionMap<K, C extends Collection<V>, V>
extends AbstractMapDecorator<K, C>
implements CollectionMap2Itf<K, C, V> {
    private final CollectionMap2Itf<K, C, V> del;

    UnmodifiableCollectionMap(CollectionMap2Itf<K, C, V> delegate, UnmodifiableMap<K, C> unmodif) {
        super(unmodif);
        if (((UnmodifiableMap)unmodif).del != delegate) {
            throw new IllegalArgumentException("Mismatched arguments");
        }
        this.del = delegate;
    }

    private final CollectionMap2Itf<K, C, V> getDel() {
        return this.del;
    }

    @Override
    public C getNonNull(K key) {
        return this.getDel().getNonNull(key);
    }

    public static abstract class UnmodifiableMap<K, C extends Collection<?>>
    extends AbstractMapDecorator<K, C> {
        private final Map<K, C> del;
        private transient Collection<C> values;
        private transient Set<Map.Entry<K, C>> entrySet;

        protected UnmodifiableMap(Map<K, C> delegate) {
            super(Collections.unmodifiableMap(delegate));
            this.del = delegate;
        }

        @Override
        public final C get(Object key) {
            return (C)this.toUnmodifiable((Collection)super.get(key));
        }

        @Override
        public final Collection<C> values() {
            AbstractCollection vs = this.values;
            return vs != null ? vs : (this.values = new AbstractCollection<C>(){

                @Override
                public boolean contains(Object o) {
                    return UnmodifiableMap.this.containsValue(o);
                }

                @Override
                public Iterator<C> iterator() {
                    final Iterator iter = UnmodifiableMap.this.entrySet().iterator();
                    return new Iterator<C>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public C next() {
                            return (Collection)((Map.Entry)iter.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return UnmodifiableMap.this.size();
                }
            });
        }

        @Override
        public final Set<Map.Entry<K, C>> entrySet() {
            AbstractSet es = this.entrySet;
            return es != null ? es : (this.entrySet = new AbstractSet<Map.Entry<K, C>>(){
                private final Set<Map.Entry<K, C>> delegateES;
                {
                    this.delegateES = UnmodifiableMap.super.entrySet();
                }

                @Override
                public boolean contains(Object o) {
                    return this.delegateES.contains(o);
                }

                @Override
                public Iterator<Map.Entry<K, C>> iterator() {
                    final Iterator iter = this.delegateES.iterator();
                    return new Iterator<Map.Entry<K, C>>(){

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public Map.Entry<K, C> next() {
                            final Map.Entry orig = (Map.Entry)iter.next();
                            return new Map.Entry<K, C>(){

                                @Override
                                public K getKey() {
                                    return orig.getKey();
                                }

                                @Override
                                public C getValue() {
                                    return UnmodifiableMap.this.toUnmodifiable((Collection)orig.getValue());
                                }

                                @Override
                                public C setValue(C value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return UnmodifiableMap.this.size();
                }

                @Override
                public boolean equals(Object o) {
                    return o == this || this.delegateES.equals(o);
                }

                @Override
                public int hashCode() {
                    return this.delegateES.hashCode();
                }
            });
        }

        protected final C toUnmodifiable(C coll) {
            if (coll == null) {
                return null;
            }
            return this.nonNullToUnmodifiable(coll);
        }

        protected abstract C nonNullToUnmodifiable(C var1);
    }
}

