/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactory
implements java.util.concurrent.ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;
    private final Boolean daemon;
    private Integer priority = null;

    public ThreadFactory(String name, Boolean daemon) {
        this.name = name;
        this.daemon = daemon;
    }

    public final ThreadFactory setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread res = new Thread(r);
        res.setName(String.valueOf(this.name) + this.threadNumber.getAndIncrement());
        if (this.daemon != null) {
            res.setDaemon(this.daemon);
        }
        if (this.priority != null) {
            res.setPriority(this.priority);
        }
        return res;
    }
}

